/* Copyright (c) 2018 VMware, Inc. All rights reserved. -- VMware
 Confidential */
namespace platform {

   /**
    * Wrapper component designed specifically to upgrade pluginIframe directive and
    * allow pluginIframe usage in angular.next components.
    */
   export class UpgradablePluginIframe {
      public template: string;
      public controller: any;
      public bindings: any;

      constructor() {
         this.controller = UpgradablePluginIframeController;
         this.bindings = {
            viewUrl: "=",
            isModal: "=?",
            viewUrlParams: "=?",
            context: "=?",
            viewId: "=?",
         };
         this.template =
            `<plugin-iframe
                  ng-style="style"
                  class="sandbox-iframe vx-portlet-content"
                  view-url="$ctrl.viewUrl"
                  is-modal="$ctrl.isModal"
                  view-url-params="$ctrl.viewUrlParams"
                  context="$ctrl.context"
                  view-id="$ctrl.viewId"
            ></plugin-iframe>`;
      }
   }

   class UpgradablePluginIframeController {
   }

   angular.module("com.vmware.platform.ui")
      .component("upgradablePluginIframe", new UpgradablePluginIframe());
}
