/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.InstanceNameTranslator;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerDeviceNameTranslator
implements InstanceNameTranslator {
    private static final Log _logger = LogFactory.getLog(PerDeviceNameTranslator.class);
    private final List<PerformanceCounter> _counters;

    public PerDeviceNameTranslator(List<PerformanceCounter> counters) {
        this._counters = counters;
    }

    @Override
    public String getInstanceName(ManagedObjectReference object, PerformanceManager.MetricId metricId) {
        PerformanceCounter counter = this.getCounter(metricId.counterId);
        if (counter == null) {
            return null;
        }
        String statNameKey = String.format("topNChart.legend.%s.%s", counter.groupId, counter.nameKey);
        String statName = ResourceUtil.getString((String)"AdvPerfCharts", (String)statNameKey, (ClassLoader)PerDeviceNameTranslator.class.getClassLoader());
        if ("".equals(metricId.instance)) {
            return statName;
        }
        return ResourceUtil.getString((String)"AdvPerfCharts", (String)"topNChart.legend.forDevice", (String[])new String[]{statName, metricId.instance}, (ClassLoader)PerDeviceNameTranslator.class.getClassLoader());
    }

    private PerformanceCounter getCounter(int id) {
        for (PerformanceCounter counter : this._counters) {
            if (id != counter.id) continue;
            return counter;
        }
        _logger.error((Object)("Could not find counter for the translation, id: " + id));
        return null;
    }
}

