/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.PerDeviceNameTranslator;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AllDevicesMetricIdProvider
implements MetricIdProvider {
    public static final String ANY_RELATED_DEVICE_ID = "*";

    @Override
    public MetricIdData getMetricIdData(ManagedObjectReference object, List<PerformanceCounter> queriedCounters) {
        MetricIdData result = new MetricIdData();
        result.queriedMetricIds = this.getQueriedMetrics(object, queriedCounters);
        result.nameTranslator = new PerDeviceNameTranslator(queriedCounters);
        return result;
    }

    private Map<ManagedObjectReference, List<PerformanceManager.MetricId>> getQueriedMetrics(ManagedObjectReference object, List<PerformanceCounter> allCounters) {
        ArrayList<PerformanceManager.MetricId> queriedMetrics = new ArrayList<PerformanceManager.MetricId>(allCounters.size());
        for (PerformanceCounter counter : allCounters) {
            PerformanceManager.MetricId metricId = new PerformanceManager.MetricId();
            metricId.counterId = counter.id;
            metricId.instance = ANY_RELATED_DEVICE_ID;
            queriedMetrics.add(metricId);
        }
        return Collections.singletonMap(object, queriedMetrics);
    }
}

