/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.data;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QueryBinding(value="Datastore")
public class DatastoreInfoData {
    private static final Log _logger = LogFactory.getLog(DatastoreInfoData.class);
    @Property(value="Datastore/info")
    public Datastore.Info info;

    public String getDatastoreVolumeUuid() {
        String[] dsUrlSplitArray;
        if (this.info.url != null && (dsUrlSplitArray = this.info.url.split("/")).length > 0) {
            return dsUrlSplitArray[dsUrlSplitArray.length - 1];
        }
        _logger.error((Object)("Could not extract the volume UUID from datastore info " + this.info));
        return null;
    }

    public List<String> getVmfsDiskNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.info instanceof VmfsDatastoreInfo) {
            VmfsDatastoreInfo vmfsDatastoreInfo = (VmfsDatastoreInfo)this.info;
            if (vmfsDatastoreInfo.vmfs != null) {
                for (ScsiDisk.Partition partition : vmfsDatastoreInfo.vmfs.extent) {
                    result.add(partition.diskName);
                }
            }
        }
        return result;
    }
}

