/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.opsmgmt.client.advperfcharts.ChartSeriesOptions;
import com.vmware.opsmgmt.client.advperfcharts.ChartSeriesOptionsAdapter;
import com.vmware.opsmgmt.client.advperfcharts.ChartTypes;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceStatsData;
import com.vmware.opsmgmt.client.advperfcharts.data.QueryStatsError;
import com.vmware.opsmgmt.client.advperfcharts.topn.ChartSeriesTopNResult;
import com.vmware.opsmgmt.client.advperfcharts.topn.PerfchartsServiceTopNProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.TopNProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.TopNQuery;
import com.vmware.opsmgmt.client.advperfcharts.topn.TopNResult;
import com.vmware.opsmgmt.client.advperfcharts.util.CompositePerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.PerObjectPerformanceCounterProvider;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCache;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceManagerUtil;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceStatsCollector;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.fault.RestrictedByAdministrator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceStatsPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(PerformanceStatsPropertyProvider.class);
    private final QueryService _queryService;
    private final PerformanceManagerUtil _performanceManagerUtil;
    private final ChartSeriesOptionsAdapter _chartSeriesOptionsAdapter;
    private final TopNProvider _topNProvider;
    private final PerfchartsServiceTopNProvider _topNPerfchartsProvider;
    private final PerformanceCounterCache _perfCounterCache;

    public PerformanceStatsPropertyProvider(QueryService queryService, PerformanceManagerUtil performanceManagerUtil, ChartSeriesOptionsAdapter chartSeriesOptionsAdapter, TopNProvider topNProvider, PerfchartsServiceTopNProvider topNPerfchartsProvider, PerformanceCounterCache perfCounterCache) {
        this._queryService = queryService;
        this._performanceManagerUtil = performanceManagerUtil;
        this._chartSeriesOptionsAdapter = chartSeriesOptionsAdapter;
        this._topNProvider = topNProvider;
        this._topNPerfchartsProvider = topNPerfchartsProvider;
        this._perfCounterCache = perfCounterCache;
    }

    @type(value="Datacenter,ResourcePool,ClusterComputeResource,HostSystem,Datastore,VirtualMachine,VirtualApp")
    public PerformanceStatsData getPerformanceStats(ManagedObjectReference moRef, PerformanceInfoQuerySpec params) throws Exception {
        PerObjectPerformanceCounterProvider counterProvider = new PerObjectPerformanceCounterProvider(params.availableCounters);
        PerformanceManager performanceManager = this._performanceManagerUtil.getPerformanceManager(moRef.getServerGuid());
        PerformanceStatsData result = new PerformanceStatsData();
        try {
            List<PerformanceCounterStats> stats;
            if (params.chartType == ChartTypes.LINE_GRAPH || params.chartType == ChartTypes.STACKED_GRAPH) {
                PerformanceStatsCollector pcsc = new PerformanceStatsCollector(moRef, performanceManager, params, counterProvider);
                stats = pcsc.getStats();
            } else {
                CompositePerformanceStats statsProvider = new CompositePerformanceStats(moRef, this._queryService, performanceManager, params, counterProvider, this._perfCounterCache);
                stats = statsProvider.getStats();
            }
            result.queriedPerformanceStats = this.chartSeriesFromStats(stats);
        }
        catch (RestrictedByAdministrator e) {
            _logger.error((Object)"Failed to retrieve performance counter stats", (Throwable)e);
            result.errorCode = QueryStatsError.RESTRICTED_BY_ADMINISTRATOR;
        }
        return result;
    }

    @type(value="Datacenter,ResourcePool,ClusterComputeResource,StoragePod,HostSystem,Datastore,VirtualMachine,VirtualApp")
    public List<ChartSeriesTopNResult> getTopNStats(ManagedObjectReference moRef, TopNQuery query) throws Exception {
        ArrayList<ChartSeriesTopNResult> result = new ArrayList<ChartSeriesTopNResult>();
        List<TopNResult> topNResults = this._topNProvider.queryReports(moRef, query);
        for (TopNResult topNResult : topNResults) {
            ChartSeriesTopNResult seriesTopNResult = new ChartSeriesTopNResult();
            seriesTopNResult.reportId = topNResult.reportId;
            seriesTopNResult.requiredLevel = topNResult.requiredLevel;
            seriesTopNResult.errorCode = topNResult.errorCode;
            seriesTopNResult.series = new ArrayList<ChartSeriesOptions>();
            if (topNResult.stats != null) {
                for (PerformanceCounterStats stat : topNResult.stats) {
                    seriesTopNResult.series.add(this._chartSeriesOptionsAdapter.createSeriesOptions(stat));
                }
            }
            result.add(seriesTopNResult);
        }
        return result;
    }

    @type(value="Datacenter,ResourcePool,ClusterComputeResource,StoragePod,HostSystem,VirtualMachine,VirtualApp")
    public ChartSeriesTopNResult getTopNPerfChartsStats(ManagedObjectReference moRef, TopNQuery query) throws Exception {
        ChartSeriesTopNResult topNResult = this._topNPerfchartsProvider.queryReports(moRef, query);
        return topNResult;
    }

    private List<ChartSeriesOptions> chartSeriesFromStats(List<PerformanceCounterStats> stats) {
        if (stats == null) {
            return Collections.emptyList();
        }
        ArrayList<ChartSeriesOptions> series = new ArrayList<ChartSeriesOptions>(stats.size());
        for (PerformanceCounterStats stat : stats) {
            series.add(this._chartSeriesOptionsAdapter.createSeriesOptions(stat));
        }
        return series;
    }
}

