/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.primitives.Ints;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricStatValue;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.data.DataPoint;
import com.vmware.opsmgmt.client.advperfcharts.data.GenericMoPerfCounterGroupsData;
import com.vmware.opsmgmt.client.advperfcharts.data.HostPerfCounterGroupsData;
import com.vmware.opsmgmt.client.advperfcharts.data.PerfCounterGroupsData;
import com.vmware.opsmgmt.client.advperfcharts.data.QueryStatsError;
import com.vmware.opsmgmt.client.advperfcharts.data.VmPerfCounterGroupsData;
import com.vmware.opsmgmt.client.advperfcharts.data.utilization.UtilizationResult;
import com.vmware.opsmgmt.client.advperfcharts.data.utilization.UtilizationStat;
import com.vmware.opsmgmt.client.advperfcharts.data.utilization.UtilizationStatGroup;
import com.vmware.opsmgmt.client.advperfcharts.util.Constants;
import com.vmware.opsmgmt.client.advperfcharts.util.PerObjectPerformanceCounterProvider;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCache;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterUtil;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceManagerUtil;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceStatsCollector;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.fault.RestrictedByAdministrator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCountersPropertyProvider
implements PropertyProviderBean {
    private static final int TOP_5 = 5;
    private static final int TOP_10 = 10;
    private static final int KB_IN_GB = 0x100000;
    private static final String RESOURCE_BUNDLE_NAME = "AdvPerfCharts";
    private static final String GROUP_ID_RESCPU = "rescpu";
    private static final String GROUP_ID_DISK = "disk";
    private static final String COUNTER_ID_CAPACITY = "capacity";
    private static final String COUNTER_ID_USED = "used";
    private static final String DELTAFILE = "DELTAFILE";
    private static final String DISKFILE = "DISKFILE";
    private static final String OTHERFILE = "OTHERFILE";
    private static final String SWAPFILE = "SWAPFILE";
    private static final String OTHER = "OTHER";
    private static final String CAPACITY = "CAPACITY";
    private static final String FREE = "FREE";
    private static final String TOTAL_USED = "";
    private static final String TOTAL_USED_KEY = "TOTAL_USED";
    private static final Comparator<Map.Entry<ManagedObjectReference, Float>> UTILIZATION_COMPARATOR = new Comparator<Map.Entry<ManagedObjectReference, Float>>(){

        @Override
        public int compare(Map.Entry<ManagedObjectReference, Float> datastore1, Map.Entry<ManagedObjectReference, Float> datastore2) {
            return datastore1.getValue().compareTo(datastore2.getValue()) * -1;
        }
    };
    private static final HashSet<String> SPACE_UTILIZATION_COUNTERS = new HashSet<String>(Arrays.asList("capacity", "used"));
    private static final HashSet<String> DISK_USAGE_TYPE = new HashSet<String>(Arrays.asList("DELTAFILE", "DISKFILE", "OTHERFILE", "SWAPFILE", ""));
    private static final String VM_VALUE_PREFIX = "vm-";
    private static final int VM_VALUE_PREFIX_LENGTH = "vm-".length();
    private static final Log _logger = LogFactory.getLog(PerformanceCountersPropertyProvider.class);
    private final PerformanceManagerUtil _performanceManagerUtil;
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;
    private final PerformanceCounterCache _perfCounterCache;

    public PerformanceCountersPropertyProvider(PerformanceManagerUtil performanceManagerUtil, QueryBindingServiceFactory queryBindingServiceFactory, QueryServiceFactory queryServiceFactory, PerformanceCounterCache perfCounterCache) {
        this._performanceManagerUtil = performanceManagerUtil;
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._queryService = queryServiceFactory.getQueryService();
        this._perfCounterCache = perfCounterCache;
    }

    @type(value="Datacenter,ResourcePool,ClusterComputeResource,HostSystem,VirtualMachine,VirtualApp")
    public PerformanceCounter[] getAvailablePerformanceCounters(ManagedObjectReference moRef) throws Exception {
        long start = System.currentTimeMillis();
        PerformanceManager perfManager = this._performanceManagerUtil.getPerformanceManager(moRef.getServerGuid());
        _logger.info((Object)("Performance counters requested for object " + moRef));
        PerfCounterGroupsData moCounterData = this.retrieveCountersData(moRef);
        PerformanceCounterCollector counterCollector = new PerformanceCounterCollector(moCounterData, perfManager, this._perfCounterCache);
        List<PerformanceCounter> availableCounters = counterCollector.getAvailableCountersSorted();
        ArrayList<PerformanceCounter> filteredList = new ArrayList<PerformanceCounter>(availableCounters.size());
        for (PerformanceCounter counter : availableCounters) {
            if (!this.isMeaningfulForUser(counter)) continue;
            filteredList.add(counter);
        }
        long end = System.currentTimeMillis();
        _logger.debug((Object)String.format("Time spent in PerformanceCountersPropertyProvider for entity [%s] is %d ms.", moRef, end - start));
        return filteredList.toArray(new PerformanceCounter[0]);
    }

    @type(value="Datacenter,ResourcePool,ClusterComputeResource,HostSystem,Datastore,VirtualMachine,VirtualApp")
    public Map<String, Map<String, List<PerformanceCounter>>> getPerformanceCounterGroups(ManagedObjectReference moRef) throws Exception {
        PerformanceCounter[] performanceCounters = this.getAvailablePerformanceCounters(moRef);
        HashMap<String, Map<String, List<PerformanceCounter>>> counters = new HashMap<String, Map<String, List<PerformanceCounter>>>();
        for (PerformanceCounter counter : performanceCounters) {
            List<PerformanceCounter> countersWithKey;
            Map countersInGroup;
            String groupId = counter.groupId;
            String key = counter.nameKey + "." + counter.rollupType;
            if (counters.containsKey(groupId)) {
                countersInGroup = (Map)counters.get(groupId);
            } else {
                countersInGroup = new HashMap();
                counters.put(groupId, countersInGroup);
            }
            if (countersInGroup.containsKey(key)) {
                countersWithKey = (List)countersInGroup.get(key);
            } else {
                countersWithKey = new ArrayList();
                countersInGroup.put(key, countersWithKey);
            }
            countersWithKey.add(counter);
        }
        return counters;
    }

    @type(value="Datastore,VirtualMachine")
    public UtilizationResult<UtilizationStat> getSpaceUtilizationByType(ManagedObjectReference moRef) throws Exception {
        UtilizationResult<UtilizationStat> result = new UtilizationResult<UtilizationStat>();
        PerformanceManager perfManager = this._performanceManagerUtil.getPerformanceManager(moRef.getServerGuid());
        PerfCounterGroupsData moCounterData = null;
        boolean isResourceConsumer = false;
        if (Constants.TYPE_DATASTORE.equals(moRef.getType())) {
            moCounterData = this.retrieveCountersData(moRef);
            isResourceConsumer = false;
        } else if (Constants.TYPE_VM.equals(moRef.getType())) {
            moCounterData = this.retrieveGenericCountersData(moRef);
            isResourceConsumer = true;
        }
        PerformanceCounterCollector counterCollector = new PerformanceCounterCollector(moCounterData, perfManager, this._perfCounterCache);
        List<PerformanceCounter> availableCounters = counterCollector.getAvailableCountersSorted();
        PerObjectPerformanceCounterProvider counterProvider = new PerObjectPerformanceCounterProvider(availableCounters);
        availableCounters = PerformanceCountersPropertyProvider.filterAvailableCounters(availableCounters, DISK_USAGE_TYPE);
        PerformanceInfoQuerySpec perfQuerySpec = PerformanceCountersPropertyProvider.getSpaceUtilizationQuerySpec(availableCounters);
        PerformanceStatsCollector statsCollector = new PerformanceStatsCollector(moRef, perfManager, perfQuerySpec, counterProvider);
        ArrayList<PerformanceCounterStats> counterStats = new ArrayList();
        boolean isRestrictedByAdministrator = false;
        try {
            counterStats = statsCollector.getStats();
        }
        catch (RestrictedByAdministrator e) {
            _logger.error((Object)"Failed to retrieve performance counter stats", (Throwable)e);
            isRestrictedByAdministrator = true;
        }
        if (isRestrictedByAdministrator) {
            result.errorCode = QueryStatsError.RESTRICTED_BY_ADMINISTRATOR;
            return result;
        }
        result.data = PerformanceCountersPropertyProvider.getSpaceUtilizationStats(counterStats, !isResourceConsumer, !isResourceConsumer, isResourceConsumer);
        return result;
    }

    @type(value="VirtualMachine")
    public UtilizationResult<UtilizationStat> getSpaceUtilizationByDatastore(ManagedObjectReference moRef) throws Exception {
        UtilizationResult<UtilizationStat> result = new UtilizationResult<UtilizationStat>();
        Map<ManagedObjectReference, String> relatedDatastoresNames = this.retrieveRelatedDatastoresData(moRef);
        if (relatedDatastoresNames.isEmpty()) {
            return result;
        }
        ManagedObjectReference[] datastores = relatedDatastoresNames.keySet().toArray(new ManagedObjectReference[0]);
        List<PerformanceCounterStats> counterStats = Collections.emptyList();
        boolean isRestrictedByAdministrator = false;
        try {
            counterStats = this.retrieveUtilizationStats(moRef, datastores);
        }
        catch (RestrictedByAdministrator e) {
            _logger.error((Object)"Failed to retrieve performance counter stats", (Throwable)e);
            isRestrictedByAdministrator = true;
        }
        if (isRestrictedByAdministrator) {
            result.errorCode = QueryStatsError.RESTRICTED_BY_ADMINISTRATOR;
            return result;
        }
        List<Map.Entry<ManagedObjectReference, Float>> datastoresUtilization = PerformanceCountersPropertyProvider.filterDiskCountersForVm(counterStats, PerformanceCountersPropertyProvider.getVmInstanceId(moRef));
        ManagedObjectReference[] topDatastoresByUsage = PerformanceCountersPropertyProvider.getTopEntitiesByUtilization(datastoresUtilization, 5);
        HashMap<ManagedObjectReference, Float> counterStatsMap = new HashMap<ManagedObjectReference, Float>();
        for (PerformanceCounterStats stat : counterStats) {
            float value = !ArrayUtil.isNullOrEmpty((Object[])stat.statistics) ? stat.statistics[stat.statistics.length - 1].value : 0.0f;
            counterStatsMap.put(stat.entity, Float.valueOf(value));
        }
        ArrayList utilizationByDatastore = new ArrayList(topDatastoresByUsage.length);
        Double totalUsedForAllDatastores = 0.0;
        for (ManagedObjectReference datastore : topDatastoresByUsage) {
            Float statForDatastore = (Float)counterStatsMap.get(datastore);
            totalUsedForAllDatastores = totalUsedForAllDatastores + (double)statForDatastore.floatValue();
            utilizationByDatastore.add(PerformanceCountersPropertyProvider.createUtilizationStat(datastore.toString(), relatedDatastoresNames.get(datastore), statForDatastore));
        }
        UtilizationStat totalUtilization = PerformanceCountersPropertyProvider.createUtilizationStat(TOTAL_USED_KEY, Float.valueOf(totalUsedForAllDatastores.floatValue()));
        utilizationByDatastore.add(totalUtilization);
        result.data = utilizationByDatastore;
        return result;
    }

    @type(value="Datacenter,StoragePod")
    public UtilizationResult<UtilizationStatGroup> getTopSpaceUtilizationByType(ManagedObjectReference moRef) throws Exception {
        UtilizationResult<UtilizationStatGroup> result = new UtilizationResult<UtilizationStatGroup>();
        Map<ManagedObjectReference, String> relatedDatastoresNames = this.retrieveRelatedDatastoresData(moRef);
        if (relatedDatastoresNames.isEmpty()) {
            return result;
        }
        ManagedObjectReference[] datastores = relatedDatastoresNames.keySet().toArray(new ManagedObjectReference[0]);
        List<PerformanceCounterStats> counterStats = Collections.emptyList();
        boolean isRestrictedByAdministrator = false;
        try {
            counterStats = this.retrieveUtilizationStats(moRef, datastores);
        }
        catch (RestrictedByAdministrator e) {
            _logger.error((Object)"Failed to retrieve performance counter stats", (Throwable)e);
            isRestrictedByAdministrator = true;
        }
        if (isRestrictedByAdministrator) {
            result.errorCode = QueryStatsError.RESTRICTED_BY_ADMINISTRATOR;
            return result;
        }
        List<Map.Entry<ManagedObjectReference, Float>> datastoresUtilization = PerformanceCountersPropertyProvider.filterDiskCounters(counterStats);
        ManagedObjectReference[] topDatastoresByUsage = PerformanceCountersPropertyProvider.getTopEntitiesByUtilization(datastoresUtilization, 10);
        HashMultimap counterStatsMap = HashMultimap.create();
        for (PerformanceCounterStats performanceCounterStats : counterStats) {
            counterStatsMap.put((Object)performanceCounterStats.entity, (Object)performanceCounterStats);
        }
        LinkedListMultimap statsByFileType = LinkedListMultimap.create();
        for (ManagedObjectReference datastore : topDatastoresByUsage) {
            List<UtilizationStat> statsForDatastore = PerformanceCountersPropertyProvider.getSpaceUtilizationStats(counterStatsMap.get((Object)datastore), true, false, false);
            for (UtilizationStat statForDatastore : statsForDatastore) {
                DataPoint dataPoint = new DataPoint();
                dataPoint.name = relatedDatastoresNames.get(datastore);
                dataPoint.y = PerformanceCountersPropertyProvider.kbToGb(statForDatastore.y);
                statsByFileType.put((Object)statForDatastore.ID, (Object)dataPoint);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : statsByFileType.asMap().entrySet()) {
            String fileTypeId;
            UtilizationStatGroup utilization = new UtilizationStatGroup();
            utilization.ID = fileTypeId = (String)entry.getKey();
            utilization.name = PerformanceCountersPropertyProvider.getString(fileTypeId, new String[0]);
            utilization.data = (Collection)entry.getValue();
            arrayList.add(utilization);
        }
        result.data = arrayList;
        return result;
    }

    @type(value="Datastore")
    public UtilizationResult<UtilizationStat> getSpaceUtilizationByVm(ManagedObjectReference moRef) throws Exception {
        UtilizationResult<UtilizationStat> result = new UtilizationResult<UtilizationStat>();
        PerformanceManager perfManager = this._performanceManagerUtil.getPerformanceManager(moRef.getServerGuid());
        GenericMoPerfCounterGroupsData moCounterData = new GenericMoPerfCounterGroupsData(moRef, TOTAL_USED);
        PerformanceCounterCollector counterCollector = new PerformanceCounterCollector(moCounterData, perfManager, this._perfCounterCache);
        List<PerformanceCounter> availableCounters = counterCollector.getAvailableCountersSorted();
        PerObjectPerformanceCounterProvider counterProvider = new PerObjectPerformanceCounterProvider(availableCounters);
        availableCounters = PerformanceCountersPropertyProvider.filterPerVmCounters(availableCounters);
        PerformanceInfoQuerySpec perfQuerySpec = PerformanceCountersPropertyProvider.getSpaceUtilizationQuerySpec(availableCounters);
        PerformanceStatsCollector statsCollector = new PerformanceStatsCollector(moRef, perfManager, perfQuerySpec, counterProvider);
        List<PerformanceCounterStats> counterStats = Collections.emptyList();
        boolean isRestrictedByAdministrator = false;
        try {
            counterStats = statsCollector.getStats();
        }
        catch (RestrictedByAdministrator e) {
            _logger.error((Object)"Failed to retrieve performance counter stats", (Throwable)e);
            isRestrictedByAdministrator = true;
        }
        if (isRestrictedByAdministrator) {
            result.errorCode = QueryStatsError.RESTRICTED_BY_ADMINISTRATOR;
            return result;
        }
        Map<ManagedObjectReference, Float> vmsSpaceUtilization = PerformanceCountersPropertyProvider.filterDiskCountersForVms(counterStats);
        ManagedObjectReference[] topVmsByUsage = PerformanceCountersPropertyProvider.getTopEntitiesByUtilization(new ArrayList<Map.Entry<ManagedObjectReference, Float>>(vmsSpaceUtilization.entrySet()), 5);
        Map<ManagedObjectReference, String> objectNames = this.retrieveNameData(Arrays.asList(topVmsByUsage));
        ArrayList utilizationResult = new ArrayList();
        Double totalUsedForTopVms = 0.0;
        for (ManagedObjectReference mor : topVmsByUsage) {
            if (!objectNames.containsKey(mor)) continue;
            Float utilizationValue = vmsSpaceUtilization.get(mor);
            totalUsedForTopVms = totalUsedForTopVms + (double)utilizationValue.floatValue();
            UtilizationStat stat = PerformanceCountersPropertyProvider.createUtilizationStat(mor.toString(), objectNames.get(mor), utilizationValue);
            utilizationResult.add(stat);
        }
        if (!utilizationResult.isEmpty()) {
            UtilizationStat totalUtilization = PerformanceCountersPropertyProvider.createUtilizationStat(TOTAL_USED_KEY, Float.valueOf(totalUsedForTopVms.floatValue()));
            utilizationResult.add(totalUtilization);
        }
        result.data = utilizationResult;
        return result;
    }

    private static List<Map.Entry<ManagedObjectReference, Float>> filterDiskCounters(Collection<PerformanceCounterStats> counterStats) {
        ArrayList<Map.Entry<ManagedObjectReference, Float>> datastoresUtilization = new ArrayList<Map.Entry<ManagedObjectReference, Float>>();
        for (PerformanceCounterStats stat : counterStats) {
            if (!GROUP_ID_DISK.equals(stat.performanceCounter.groupId) || !COUNTER_ID_USED.equals(stat.performanceCounter.nameKey) || stat.performanceCounter.metricId.instance != TOTAL_USED) continue;
            Float value = Float.valueOf(!ArrayUtil.isNullOrEmpty((Object[])stat.statistics) ? stat.statistics[stat.statistics.length - 1].value : 0.0f);
            datastoresUtilization.add(new AbstractMap.SimpleEntry<ManagedObjectReference, Float>(stat.entity, value));
        }
        return datastoresUtilization;
    }

    private static List<Map.Entry<ManagedObjectReference, Float>> filterDiskCountersForVm(Collection<PerformanceCounterStats> counterStats, String instanceId) {
        ArrayList<Map.Entry<ManagedObjectReference, Float>> datastoresUtilization = new ArrayList<Map.Entry<ManagedObjectReference, Float>>();
        for (PerformanceCounterStats stat : counterStats) {
            if (!GROUP_ID_DISK.equals(stat.performanceCounter.groupId) || !COUNTER_ID_USED.equals(stat.performanceCounter.nameKey) || !instanceId.equals(stat.performanceCounter.metricId.instance)) continue;
            Float value = Float.valueOf(!ArrayUtil.isNullOrEmpty((Object[])stat.statistics) ? stat.statistics[stat.statistics.length - 1].value : 0.0f);
            datastoresUtilization.add(new AbstractMap.SimpleEntry<ManagedObjectReference, Float>(stat.entity, value));
        }
        return datastoresUtilization;
    }

    private static Map<ManagedObjectReference, Float> filterDiskCountersForVms(Collection<PerformanceCounterStats> counterStats) {
        HashMap<ManagedObjectReference, Float> datastoresUtilization = new HashMap<ManagedObjectReference, Float>();
        for (PerformanceCounterStats stat : counterStats) {
            if (!GROUP_ID_DISK.equals(stat.performanceCounter.groupId) || !COUNTER_ID_USED.equals(stat.performanceCounter.nameKey) || DISK_USAGE_TYPE.contains(stat.performanceCounter.metricId.instance)) continue;
            Float value = Float.valueOf(!ArrayUtil.isNullOrEmpty((Object[])stat.statistics) ? stat.statistics[stat.statistics.length - 1].value : 0.0f);
            ManagedObjectReference vm = PerformanceCountersPropertyProvider.getVmReference(stat.performanceCounter.metricId.instance, stat.entity.getServerGuid());
            datastoresUtilization.put(vm, value);
        }
        return datastoresUtilization;
    }

    private static List<PerformanceCounter> filterAvailableCounters(List<PerformanceCounter> availableCounters, Collection<String> metricIds) {
        ArrayList<PerformanceCounter> filteredCounters = new ArrayList<PerformanceCounter>();
        for (PerformanceCounter counter : availableCounters) {
            if (!GROUP_ID_DISK.equals(counter.groupId) || !SPACE_UTILIZATION_COUNTERS.contains(counter.nameKey) || counter.metricId == null || !metricIds.contains(counter.metricId.instance)) continue;
            filteredCounters.add(counter);
        }
        return filteredCounters;
    }

    private static List<PerformanceCounter> filterPerVmCounters(List<PerformanceCounter> availableCounters) {
        ArrayList<PerformanceCounter> filteredCounters = new ArrayList<PerformanceCounter>();
        for (PerformanceCounter counter : availableCounters) {
            if (DISK_USAGE_TYPE.contains(counter.metricId.instance)) continue;
            filteredCounters.add(counter);
        }
        return filteredCounters;
    }

    private static ManagedObjectReference[] getTopEntitiesByUtilization(List<Map.Entry<ManagedObjectReference, Float>> counterStats, int top) {
        Collections.sort(counterStats, UTILIZATION_COMPARATOR);
        int topCount = Ints.min((int[])new int[]{top, counterStats.size()});
        ManagedObjectReference[] topEntities = new ManagedObjectReference[topCount];
        for (int index = 0; index < topCount; ++index) {
            topEntities[index] = counterStats.get(index).getKey();
        }
        return topEntities;
    }

    private Collection<PerformanceCounterStats> retrieveUtilizationStats(ManagedObjectReference moRef, ManagedObjectReference[] datastores) throws Exception {
        PerformanceManager perfManager = this._performanceManagerUtil.getPerformanceManager(moRef.getServerGuid());
        Collection<PerformanceManager.CounterInfo> counters = this._perfCounterCache.getCountersForServer(perfManager);
        HashMap<Integer, PerformanceManager.CounterInfo> filteredCountersMap = new HashMap<Integer, PerformanceManager.CounterInfo>(2);
        int diskCapacityCounterId = 0;
        int diskUsageCounterId = 0;
        for (PerformanceManager.CounterInfo counterInfo : counters) {
            if (GROUP_ID_DISK.equals(counterInfo.groupInfo.key) && COUNTER_ID_CAPACITY.equals(counterInfo.nameInfo.key)) {
                diskCapacityCounterId = counterInfo.key;
                filteredCountersMap.put(counterInfo.key, counterInfo);
                continue;
            }
            if (!GROUP_ID_DISK.equals(counterInfo.groupInfo.key) || !COUNTER_ID_USED.equals(counterInfo.nameInfo.key)) continue;
            filteredCountersMap.put(counterInfo.key, counterInfo);
            diskUsageCounterId = counterInfo.key;
        }
        if (diskCapacityCounterId == 0 || diskUsageCounterId == 0) {
            return Collections.emptyList();
        }
        PerformanceManager.MetricId[] metricIds = PerformanceCountersPropertyProvider.createMetricIds(moRef, diskCapacityCounterId, diskUsageCounterId);
        List<PerformanceCounter> availableCounters = PerformanceCounterUtil.createCounters(metricIds, filteredCountersMap, PerformanceMetricTimeIntervals.RAW_DATA_FEED);
        ImmutableList metricIdsToQuery = Constants.TYPE_VM.equals(moRef.getType()) ? ImmutableList.of((Object)PerformanceCountersPropertyProvider.getVmInstanceId(moRef)) : DISK_USAGE_TYPE;
        availableCounters = PerformanceCountersPropertyProvider.filterAvailableCounters(availableCounters, (Collection<String>)metricIdsToQuery);
        PerformanceInfoQuerySpec perfQuerySpec = PerformanceCountersPropertyProvider.getSpaceUtilizationQuerySpec(availableCounters);
        PerObjectPerformanceCounterProvider counterProvider = new PerObjectPerformanceCounterProvider(availableCounters);
        PerformanceStats stats = new PerformanceStats(Arrays.asList(datastores), perfQuerySpec, perfManager, null, counterProvider);
        return stats.getStats();
    }

    private static PerformanceManager.MetricId[] createMetricIds(ManagedObjectReference moRef, int diskCapacityCounterId, int diskUsageCounterId) {
        Preconditions.checkArgument((boolean)ImmutableList.of((Object)Constants.TYPE_DATACENTER, (Object)Constants.TYPE_STORAGE_POD, (Object)Constants.TYPE_VM).contains((Object)moRef.getType()), (Object)String.format("Unsupported type: %s", moRef.getType()));
        if (Constants.TYPE_VM.equals(moRef.getType())) {
            return new PerformanceManager.MetricId[]{new PerformanceManager.MetricId(diskUsageCounterId, PerformanceCountersPropertyProvider.getVmInstanceId(moRef))};
        }
        return new PerformanceManager.MetricId[]{new PerformanceManager.MetricId(diskCapacityCounterId, TOTAL_USED), new PerformanceManager.MetricId(diskUsageCounterId, TOTAL_USED), new PerformanceManager.MetricId(diskUsageCounterId, DELTAFILE), new PerformanceManager.MetricId(diskUsageCounterId, DISKFILE), new PerformanceManager.MetricId(diskUsageCounterId, SWAPFILE), new PerformanceManager.MetricId(diskUsageCounterId, OTHERFILE)};
    }

    private Map<ManagedObjectReference, String> retrieveRelatedDatastoresData(ManagedObjectReference entity) {
        Preconditions.checkArgument((boolean)ImmutableList.of((Object)Constants.TYPE_DATACENTER, (Object)Constants.TYPE_STORAGE_POD, (Object)Constants.TYPE_VM).contains((Object)entity.getType()), (Object)String.format("Unsupported type: %s", entity.getType()));
        String opId = ManagedObjectUtil.morefToString((ManagedObjectReference)entity) + ".relatedDatastoresData";
        String entityType = entity.getType();
        String relation = TOTAL_USED;
        if (Constants.TYPE_DATACENTER.equals(entityType)) {
            relation = "dc";
        } else if (Constants.TYPE_STORAGE_POD.equals(entityType)) {
            relation = "parentStoragePod";
        } else if (Constants.TYPE_VM.equals(entityType)) {
            relation = "vm";
        }
        ResultSet resultSet = this._queryService.select(new String[]{"name", "@modelKey"}).from(new String[]{Constants.TYPE_DATASTORE}).where(relation, PropertyPredicate.ComparisonOperator.EQUAL, (Object)entity).opId(opId).fetch();
        List resourceItems = resultSet.getItems();
        HashMap<ManagedObjectReference, String> objectNames = new HashMap<ManagedObjectReference, String>(resourceItems.size());
        for (ResourceItem item : resourceItems) {
            objectNames.put((ManagedObjectReference)item.get("@modelKey"), (String)item.get("name"));
        }
        return objectNames;
    }

    private Map<ManagedObjectReference, String> retrieveNameData(Collection<ManagedObjectReference> vms) {
        ResultSet resultSet = this._queryService.select(new String[]{"name", "@modelKey"}).from(new String[]{Constants.TYPE_VM}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vms).fetch();
        List resourceItems = resultSet.getItems();
        HashMap<ManagedObjectReference, String> objectNames = new HashMap<ManagedObjectReference, String>(resourceItems.size());
        for (ResourceItem item : resourceItems) {
            objectNames.put((ManagedObjectReference)item.get("@modelKey"), (String)item.get("name"));
        }
        return objectNames;
    }

    private PerfCounterGroupsData retrieveCountersData(ManagedObjectReference entity) {
        String opId = ManagedObjectUtil.morefToString((ManagedObjectReference)entity) + ".performanceCountersData";
        if (Constants.TYPE_HOST.equals(entity.getType()) || Constants.TYPE_VM.equals(entity.getType())) {
            Class modelType = Constants.TYPE_HOST.equals(entity.getType()) ? HostPerfCounterGroupsData.class : VmPerfCounterGroupsData.class;
            PerfCounterGroupsData resultSet = (PerfCounterGroupsData)this._queryBindingService.prepare(modelType).opId(opId).fetch((Object)entity);
            return resultSet;
        }
        return this.retrieveGenericCountersData(entity);
    }

    private PerfCounterGroupsData retrieveGenericCountersData(ManagedObjectReference entity) {
        String opId = ManagedObjectUtil.morefToString((ManagedObjectReference)entity) + ".performanceCountersData";
        ResultSet rs = this._queryService.select(new String[]{"name", "@modelKey"}).from(new String[]{entity.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)entity).opId(opId).fetch();
        ResourceItem ri = (ResourceItem)rs.getItems().get(0);
        String name = (String)ri.get("name");
        ManagedObjectReference object = (ManagedObjectReference)ri.get("@modelKey");
        return new GenericMoPerfCounterGroupsData(object, name);
    }

    private static PerformanceInfoQuerySpec getSpaceUtilizationQuerySpec(List<PerformanceCounter> availableCounters) {
        ArrayList<PerformanceManager.MetricId> metricsToRetrieve = new ArrayList<PerformanceManager.MetricId>();
        ArrayList<String> deviceIds = new ArrayList<String>();
        for (PerformanceCounter counter : availableCounters) {
            metricsToRetrieve.add(counter.metricId);
            if (counter.relatedDeviceId == null) continue;
            deviceIds.add(counter.relatedDeviceId);
        }
        PerformanceInfoQuerySpec perfQuerySpec = new PerformanceInfoQuerySpec();
        perfQuerySpec.interval = PerformanceMetricTimeIntervals.RAW_DATA_FEED;
        perfQuerySpec.metricIds = metricsToRetrieve.toArray(new PerformanceManager.MetricId[0]);
        perfQuerySpec.relatedDeviceIds = deviceIds;
        perfQuerySpec.availableCounters = availableCounters;
        perfQuerySpec.format = PerformanceManager.Format.csv;
        return perfQuerySpec;
    }

    private static List<UtilizationStat> getSpaceUtilizationStats(Collection<PerformanceCounterStats> perfCounterStatses, boolean includeFree, boolean includeCapacity, boolean includeTotalUsed) {
        ArrayList<UtilizationStat> stats = new ArrayList<UtilizationStat>();
        float totalCapacity = 0.0f;
        float totalUsed = 0.0f;
        float totalFilesSize = 0.0f;
        for (PerformanceCounterStats counterStat : perfCounterStatses) {
            String instanceId;
            PerformanceMetricStatValue[] statsValue = counterStat.statistics;
            PerformanceMetricStatValue lastStat = !ArrayUtil.isNullOrEmpty((Object[])statsValue) ? statsValue[statsValue.length - 1] : null;
            Float value = lastStat != null ? Float.valueOf(lastStat.value) : null;
            PerformanceCounter counter = counterStat.performanceCounter;
            String counterNameKey = counter.nameKey;
            if (COUNTER_ID_CAPACITY.equals(counterNameKey)) {
                totalCapacity = value.floatValue();
                continue;
            }
            if (!COUNTER_ID_USED.equals(counterNameKey)) continue;
            switch (instanceId = counter.metricId.instance) {
                case "DISKFILE": 
                case "OTHERFILE": 
                case "DELTAFILE": 
                case "SWAPFILE": {
                    if (value == null || !(value.floatValue() > 0.0f)) break;
                    totalFilesSize += value.floatValue();
                    stats.add(PerformanceCountersPropertyProvider.createUtilizationStat(instanceId, value));
                    break;
                }
                case "": {
                    totalUsed = value != null ? value.floatValue() : 0.0f;
                }
            }
        }
        float otherFilesSize = totalUsed - totalFilesSize;
        if (otherFilesSize > 0.0f) {
            stats.add(PerformanceCountersPropertyProvider.createUtilizationStat(OTHER, Float.valueOf(otherFilesSize)));
        }
        if (includeFree) {
            stats.add(PerformanceCountersPropertyProvider.createUtilizationStat(FREE, Float.valueOf(totalCapacity - totalUsed)));
        }
        if (includeCapacity) {
            stats.add(PerformanceCountersPropertyProvider.createUtilizationStat(CAPACITY, Float.valueOf(totalCapacity)));
        }
        if (includeTotalUsed) {
            stats.add(PerformanceCountersPropertyProvider.createUtilizationStat(TOTAL_USED_KEY, Float.valueOf(totalFilesSize)));
        }
        return stats;
    }

    private static UtilizationStat createUtilizationStat(String ID, Float value) {
        return PerformanceCountersPropertyProvider.createUtilizationStat(ID, PerformanceCountersPropertyProvider.getString(ID, new String[0]), value);
    }

    private static UtilizationStat createUtilizationStat(String ID, String name, Float value) {
        String formattedStorage = FormatUtil.getStorageFormatted((Long)(value != null ? value.longValue() : 0L), (long)1024L, (long)-1L);
        UtilizationStat utilizationStat = new UtilizationStat();
        utilizationStat.name = PerformanceCountersPropertyProvider.getString("file.type.format", name, formattedStorage);
        utilizationStat.ID = ID;
        utilizationStat.y = value;
        return utilizationStat;
    }

    private static String getString(String key, String ... parameters) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])parameters, (ClassLoader)PerformanceCountersPropertyProvider.class.getClassLoader());
    }

    private static String getVmInstanceId(ManagedObjectReference moRef) {
        Preconditions.checkArgument((boolean)Constants.TYPE_VM.equals(moRef.getType()), (Object)String.format("Unsupported type: %s", moRef.getType()));
        return moRef.getValue().substring(VM_VALUE_PREFIX_LENGTH);
    }

    private static ManagedObjectReference getVmReference(String vmId, String serverGuid) {
        Preconditions.checkArgument((!StringUtil.isNullOrEmpty((String)vmId) ? 1 : 0) != 0);
        String value = VM_VALUE_PREFIX + vmId;
        return new ManagedObjectReference(Constants.TYPE_VM, value, serverGuid);
    }

    private static Float kbToGb(Float kb) {
        return Float.valueOf(kb.floatValue() / 1048576.0f);
    }

    private boolean isMeaningfulForUser(PerformanceCounter counter) {
        return !GROUP_ID_RESCPU.equals(counter.groupId);
    }
}

