/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.HealthStatusChangedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.GlobalObjectUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceAlarmInfoRetriever {
    private static final String EVENT_MANAGER_KEY = "EventManager";
    private static final String SERVICES_PROPERTY_NAME = "vsphere:serviceList";
    private static final String ALARMS_UTIL_SYNC_OBJECT_KEY = "com.vmware.opsmgmt.client.alarms.util.ALARMS_UTIL_SYNC_OBJECT_KEY";
    private static final int MAX_EVENTS_QUERY_SIZE = 1000;
    private static final Log _logger = LogFactory.getLog(ServiceAlarmInfoRetriever.class);
    private static final Log _performanceLogger = LogFactory.getLog((String)"PerformanceAuditingLogger");
    private DataService _dataService;
    private Cache<Pair<String, String>, URI> _cachedServiceUrisMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(1024L).build();
    private ReentrantLock _uriLock = new ReentrantLock();
    private Cache<URI, String> _cachedServiceNamesMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(1024L).build();
    private Lock _namesLock = new ReentrantLock();
    private Cache<String, Object> _cachedEvents = CacheBuilder.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(2048L).build();
    private Lock _eventsLock = new ReentrantLock();
    private static final Object NON_HEALTH_STATUS_EVENT = new Object();

    public ServiceAlarmInfoRetriever(DataService dataService) {
        this._dataService = dataService;
    }

    public Map<String, ServiceAlarmInfo> retrieve(List<AlarmState> alarmStates, String performanceLoggingPrefix) {
        Map<String, HealthStatusChangedEvent> serviceEventsMap;
        Set<String> serviceAlarmKeys;
        HashMap<String, ServiceAlarmInfo> result = new HashMap<String, ServiceAlarmInfo>();
        ArrayList<AlarmState> filteredAlarmStates = new ArrayList<AlarmState>();
        for (AlarmState alarmState : alarmStates) {
            if (alarmState.alarm == null || alarmState.alarm.getServerGuid() == null || alarmState.eventKey == null) continue;
            filteredAlarmStates.add(alarmState);
        }
        if (filteredAlarmStates.size() == 0) {
            return result;
        }
        boolean isPerformanceLoggerInfoEnabled = _performanceLogger.isInfoEnabled();
        long startTime = 0L;
        long stopTime = 0L;
        if (isPerformanceLoggerInfoEnabled) {
            startTime = System.currentTimeMillis();
        }
        Map<String, List<HealthStatusChangedEvent>> eventMap = this.getEventMap(filteredAlarmStates);
        if (isPerformanceLoggerInfoEnabled) {
            stopTime = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: EventMap (part of ServiceAlarmInfos retrieval) retrieved in %d ms.", performanceLoggingPrefix, stopTime - startTime));
        }
        if ((serviceAlarmKeys = (serviceEventsMap = this.getServiceEventsMap(eventMap, filteredAlarmStates)).keySet()).isEmpty()) {
            return result;
        }
        Map<URI, String> serviceReferencesMap = this.getServiceReferencesMap(eventMap, serviceEventsMap, performanceLoggingPrefix);
        if (serviceReferencesMap.isEmpty()) {
            ListIterator<AlarmState> iterator = alarmStates.listIterator();
            while (iterator.hasNext()) {
                AlarmState alarm = (AlarmState)iterator.next();
                String alarmKey = Util.buildAlarmKey(alarm);
                if (!serviceAlarmKeys.contains(alarmKey)) continue;
                iterator.remove();
            }
            return result;
        }
        Map<String, String> serviceNamesMap = this.getServiceNamesMap(serviceReferencesMap, performanceLoggingPrefix);
        for (Map.Entry<URI, String> serviceAlarmEntry : serviceReferencesMap.entrySet()) {
            URI serviceRef = serviceAlarmEntry.getKey();
            String alarmKey = serviceAlarmEntry.getValue();
            String serviceName = serviceNamesMap.get(alarmKey);
            HealthStatusChangedEvent event = serviceEventsMap.get(alarmKey);
            ServiceAlarmInfo info = this.createServiceAlarmInfo(event, serviceName, serviceRef);
            result.put(alarmKey, info);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<HealthStatusChangedEvent>> getEventMap(List<AlarmState> alarmStates) {
        HashMap<String, List<HealthStatusChangedEvent>> result = new HashMap<String, List<HealthStatusChangedEvent>>();
        Map<String, Set<Integer>> eventKeyMap = this.getEventKeyMap(alarmStates);
        for (String serverGuid : eventKeyMap.keySet()) {
            Set<Integer> eventKeySet = eventKeyMap.get(serverGuid);
            if (eventKeySet == null || eventKeySet.isEmpty()) continue;
            ArrayList<HealthStatusChangedEvent> healthStatusEvents = new ArrayList<HealthStatusChangedEvent>();
            this._eventsLock.lock();
            try {
                ArrayList<Integer> eventKeysToRetrieve = new ArrayList<Integer>();
                for (Integer eventKey : eventKeySet) {
                    Object cacheValue = this._cachedEvents.getIfPresent((Object)(serverGuid + ':' + eventKey));
                    if (cacheValue != null) {
                        if (cacheValue == NON_HEALTH_STATUS_EVENT) continue;
                        healthStatusEvents.add((HealthStatusChangedEvent)cacheValue);
                        continue;
                    }
                    eventKeysToRetrieve.add(eventKey);
                }
                if (eventKeysToRetrieve.isEmpty()) {
                    result.put(serverGuid, healthStatusEvents);
                    continue;
                }
                EventManager eventManager = this.getEventManager(serverGuid);
                if (eventManager == null) {
                    _logger.error((Object)String.format("Unable to get event manager. Server GUID: %s", serverGuid));
                    continue;
                }
                Integer[] eventKeys = eventKeysToRetrieve.toArray(new Integer[0]);
                List<Integer[]> chunks = ServiceAlarmInfoRetriever.split(eventKeys, 1000);
                for (Integer[] chunk : chunks) {
                    int[] queryArgs = new int[chunk.length];
                    for (int i = 0; i < queryArgs.length; ++i) {
                        queryArgs[i] = chunk[i];
                    }
                    Event[] events = eventManager.queryEventsById(queryArgs);
                    if (events == null) continue;
                    for (Event event : events) {
                        if (event instanceof HealthStatusChangedEvent) {
                            this._cachedEvents.put((Object)(serverGuid + ':' + event.key), (Object)event);
                            healthStatusEvents.add((HealthStatusChangedEvent)event);
                            continue;
                        }
                        this._cachedEvents.put((Object)(serverGuid + ':' + event.key), NON_HEALTH_STATUS_EVENT);
                    }
                }
            }
            finally {
                this._eventsLock.unlock();
                continue;
            }
            result.put(serverGuid, healthStatusEvents);
        }
        return result;
    }

    private Map<String, Set<Integer>> getEventKeyMap(List<AlarmState> alarmStates) {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        for (AlarmState alarmState : alarmStates) {
            String serverGuid = alarmState.alarm.getServerGuid();
            if (!result.containsKey(serverGuid)) {
                result.put(serverGuid, new HashSet());
            }
            ((Set)result.get(serverGuid)).add(alarmState.eventKey);
        }
        return result;
    }

    private Map<String, HealthStatusChangedEvent> getServiceEventsMap(Map<String, List<HealthStatusChangedEvent>> eventMap, List<AlarmState> alarmStates) {
        HashMap<String, HealthStatusChangedEvent> result = new HashMap<String, HealthStatusChangedEvent>();
        block0: for (AlarmState alarm : alarmStates) {
            List<HealthStatusChangedEvent> events = eventMap.get(alarm.alarm.getServerGuid());
            if (events == null || events.isEmpty()) continue;
            for (HealthStatusChangedEvent event : events) {
                if (event.key != alarm.eventKey) continue;
                result.put(Util.buildAlarmKey(alarm), event);
                continue block0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventManager getEventManager(String serverGuid) {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            return null;
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        if (httpSession == null) {
            return null;
        }
        Object syncObject = SessionUtil.getSyncObject((String)ALARMS_UTIL_SYNC_OBJECT_KEY, (HttpSession)httpSession);
        HashMap<String, EventManager> serverGuidToEventMgrMap = null;
        Object object = syncObject;
        synchronized (object) {
            serverGuidToEventMgrMap = (HashMap<String, EventManager>)SessionUtil.getData((String)EVENT_MANAGER_KEY, (HttpSession)httpSession);
            if (serverGuidToEventMgrMap == null) {
                serverGuidToEventMgrMap = new HashMap<String, EventManager>();
                SessionUtil.setData((String)EVENT_MANAGER_KEY, serverGuidToEventMgrMap);
            }
            if (serverGuidToEventMgrMap.containsKey(serverGuid)) {
                return (EventManager)serverGuidToEventMgrMap.get(serverGuid);
            }
        }
        EventManager eventManager = null;
        try {
            eventManager = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().eventManager);
        }
        catch (Exception e) {
            _logger.error((Object)("Failed to retrieve event manager for serverGUID: " + serverGuid), (Throwable)e);
            return null;
        }
        Object object2 = syncObject;
        synchronized (object2) {
            serverGuidToEventMgrMap.put(serverGuid, eventManager);
        }
        return eventManager;
    }

    private ServiceAlarmInfo createServiceAlarmInfo(HealthStatusChangedEvent event, String serviceName, URI serviceRef) {
        ServiceAlarmInfo info = new ServiceAlarmInfo();
        info.serviceName = serviceName;
        info.service = serviceRef;
        info.message = event.fullFormattedMessage;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URI, String> getServiceReferencesMap(Map<String, List<HealthStatusChangedEvent>> eventMap, Map<String, HealthStatusChangedEvent> alarmKeyByEvent, String performanceLoggingPrefix) {
        Serializable serviceUri;
        HashMap<URI, String> result = new HashMap<URI, String>();
        ArrayList<Pair> serviceIdByServerGuids = new ArrayList<Pair>();
        ArrayList<String> alarmKeys = new ArrayList<String>();
        for (String serverGuid : eventMap.keySet()) {
            List<HealthStatusChangedEvent> events = eventMap.get(serverGuid);
            for (HealthStatusChangedEvent event : events) {
                String alarmKeyForResult = null;
                for (String alarmKey : alarmKeyByEvent.keySet()) {
                    if (event.key != alarmKeyByEvent.get((Object)alarmKey).key) continue;
                    alarmKeyForResult = alarmKey;
                    break;
                }
                if (alarmKeyForResult == null) {
                    _logger.error((Object)"Events and Service based alarms don't match!");
                    return result;
                }
                Pair serviceIdGuidPair = new Pair((Object)event.serviceId, (Object)serverGuid);
                serviceUri = (URI)this._cachedServiceUrisMap.getIfPresent((Object)serviceIdGuidPair);
                if (serviceUri == null) {
                    serviceIdByServerGuids.add(serviceIdGuidPair);
                    alarmKeys.add(alarmKeyForResult);
                    continue;
                }
                result.put((URI)serviceUri, alarmKeyForResult);
            }
        }
        if (!serviceIdByServerGuids.isEmpty()) {
            this._uriLock.lock();
            try {
                for (int i = 0; i < serviceIdByServerGuids.size(); ++i) {
                    Pair serviceIdGuidPair = (Pair)serviceIdByServerGuids.get(i);
                    URI serviceUri2 = (URI)this._cachedServiceUrisMap.getIfPresent((Object)serviceIdGuidPair);
                    if (serviceUri2 == null) continue;
                    result.put(serviceUri2, (String)alarmKeys.get(i));
                    serviceIdByServerGuids.remove(i);
                    alarmKeys.remove(i);
                    --i;
                }
                if (alarmKeys.isEmpty()) {
                    HashMap<URI, String> i = result;
                    return i;
                }
                QuerySpec query = this.buildServiceReferencesQuery(serviceIdByServerGuids.toArray(new Object[0]));
                boolean isPerformanceLoggerInfoEnabled = _performanceLogger.isInfoEnabled();
                long startTime = 0L;
                long stopTime = 0L;
                if (isPerformanceLoggerInfoEnabled) {
                    startTime = System.currentTimeMillis();
                }
                ResultSet dataResult = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
                if (isPerformanceLoggerInfoEnabled) {
                    stopTime = System.currentTimeMillis();
                    _performanceLogger.info((Object)String.format("%s: ServiceReferences (part of ServiceAlarmInfos retrieval) retrieved in: %d ms.", performanceLoggingPrefix, stopTime - startTime));
                }
                if (dataResult == null) {
                    _logger.error((Object)"Data service returned null result for service URI query");
                    serviceUri = result;
                    return serviceUri;
                }
                if (dataResult.error != null || ArrayUtil.isNullOrEmpty((Object[])dataResult.items)) {
                    _logger.warn((Object)"URIs for requested services are not found!", (Throwable)dataResult.error);
                    serviceUri = result;
                    return serviceUri;
                }
                URI[] uris = (URI[])dataResult.items[0].properties[0].value;
                for (int i = 0; i < uris.length; ++i) {
                    this._cachedServiceUrisMap.put(serviceIdByServerGuids.get(i), (Object)uris[i]);
                    result.put(uris[i], (String)alarmKeys.get(i));
                }
            }
            catch (Exception e) {
                _logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this._uriLock.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getServiceNamesMap(Map<URI, String> alarmKeysByServiceUris, String performanceLoggingPrefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<Map.Entry<URI, String>> nonCachedServices = new ArrayList<Map.Entry<URI, String>>();
        for (Map.Entry<URI, String> entry : alarmKeysByServiceUris.entrySet()) {
            String serviceName = (String)this._cachedServiceNamesMap.getIfPresent((Object)entry.getKey());
            if (serviceName != null) {
                result.put(entry.getValue(), serviceName);
                continue;
            }
            nonCachedServices.add(entry);
        }
        if (!nonCachedServices.isEmpty()) {
            this._namesLock.lock();
            try {
                ArrayList<URI> urisForNameRequest = new ArrayList<URI>();
                for (int i = 0; i < nonCachedServices.size(); ++i) {
                    Map.Entry serviceUriAlarmKeyPair = (Map.Entry)nonCachedServices.get(i);
                    URI serviceUri = (URI)serviceUriAlarmKeyPair.getKey();
                    String serviceName = (String)this._cachedServiceNamesMap.getIfPresent((Object)serviceUri);
                    if (serviceName != null) {
                        result.put((String)serviceUriAlarmKeyPair.getValue(), serviceName);
                        nonCachedServices.remove(i);
                        --i;
                        continue;
                    }
                    urisForNameRequest.add(serviceUri);
                }
                if (urisForNameRequest.isEmpty()) {
                    HashMap<String, String> i = result;
                    return i;
                }
                boolean isPerformanceLoggerInfoEnabled = _performanceLogger.isInfoEnabled();
                long startTime = 0L;
                long stopTime = 0L;
                if (isPerformanceLoggerInfoEnabled) {
                    startTime = System.currentTimeMillis();
                }
                PropertyValue[] propertyValues = QueryUtil.getProperty((DataService)this._dataService, (Object[])urisForNameRequest.toArray(new URI[0]), (String)"name");
                if (isPerformanceLoggerInfoEnabled) {
                    stopTime = System.currentTimeMillis();
                    _performanceLogger.info((Object)String.format("%s: ServiceNames (part of ServiceAlarmInfos retrieval) retrieved in %d ms.", performanceLoggingPrefix, stopTime - startTime));
                }
                if (propertyValues != null) {
                    for (PropertyValue propertyValue : propertyValues) {
                        URI serviceUri = (URI)propertyValue.resourceObject;
                        String serviceName = (String)propertyValue.value;
                        this._cachedServiceNamesMap.put((Object)serviceUri, (Object)serviceName);
                        String alarmKey = alarmKeysByServiceUris.get(serviceUri);
                        if (alarmKey == null) {
                            _logger.error((Object)("Cannot match name for service uri:" + serviceUri));
                            continue;
                        }
                        result.put(alarmKey, serviceName);
                    }
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Failed to retrieve service names", (Throwable)e);
            }
            finally {
                this._namesLock.unlock();
            }
        }
        return result;
    }

    private QuerySpec buildServiceReferencesQuery(Object[] serviceIdByServiceGuids) {
        QuerySpec query = new QuerySpec();
        ObjectIdentityConstraint oic = new ObjectIdentityConstraint();
        oic.target = GlobalObjectUtil.getVSphereClientInstance();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec property = new PropertySpec();
        property.propertyNames = new String[]{SERVICES_PROPERTY_NAME};
        ParameterSpec parameter = new ParameterSpec();
        parameter.propertyName = SERVICES_PROPERTY_NAME;
        parameter.parameter = serviceIdByServiceGuids;
        property.parameters = new ParameterSpec[]{parameter};
        resourceSpec.propertySpecs = new PropertySpec[]{property};
        resourceSpec.constraint = oic;
        query.resourceSpec = resourceSpec;
        return query;
    }

    private static <T> List<T[]> split(T[] source, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid argument: n");
        }
        if (source == null) {
            return Collections.emptyList();
        }
        LinkedList<T[]> chunks = new LinkedList<T[]>();
        int from = 0;
        while (from < source.length) {
            int to = from + Math.min(n, source.length - from);
            T[] chunk = Arrays.copyOfRange(source, from, to);
            chunks.add(chunk);
            from = to;
        }
        return chunks;
    }
}

