/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.opsmgmt.client.alarms.util.AlarmStateComparator;
import com.vmware.opsmgmt.client.alarms.util.AlarmStateFilter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmStateRetriever {
    private static final Log _logger = LogFactory.getLog(AlarmStateRetriever.class);
    private static final String _TRIGGERED_ALARMS_PROPERTY = "triggeredAlarmState";
    private static final String _TRIGGERED_ALARMS_LENGTH_PROPERTY = "triggeredAlarmState._length";
    private static final String _TOP_TRIGGERED_UNACKNOWLEDGED_ALARMS_PROPERTY = "topTriggeredAndUnacknowledgedAlarmState";
    private static final String _TOP_TRIGGERED_ACKNOWLEDGED_ALARMS_PROPERTY = "topTriggeredAndAcknowledgedAlarmState";
    private final AlarmStateComparator _alarmStateComparator;
    private final AlarmStateFilter _alarmStateFilter;
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;

    public AlarmStateRetriever(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
        this._alarmStateComparator = new AlarmStateComparator();
        this._alarmStateFilter = new AlarmStateFilter();
    }

    public Result retrieve(boolean sort, List<Object> objects, String issueType, Integer maxResultCount, Integer offset) {
        Response response = this.queryData(objects, maxResultCount);
        if (response == null) {
            _logger.error((Object)"Error retrieving triggered alarms: null response");
            return new Result(null, 0);
        }
        if (ArrayUtil.isNullOrEmpty((Object[])response.resultSet)) {
            return new Result(null, 0);
        }
        ExtractVcAlarmsResult data = AlarmStateRetriever.extractVcAlarms(response.resultSet);
        int totalAlarms = 0;
        int maxCount = maxResultCount != null ? maxResultCount : -1;
        offset = offset != null ? offset : -1;
        for (int i = 0; i < data.alarmsPerVc.size(); ++i) {
            int thisVcTotalAlarms;
            List<AlarmState> alarmList = data.alarmsPerVc.get(i);
            int thisVcReceivedAlarms = alarmList.size();
            boolean allAlarmsReceived = thisVcReceivedAlarms == (thisVcTotalAlarms = data.totalCountPerVc.get(i).intValue());
            totalAlarms = (alarmList = this.filterAlarms(alarmList, issueType)) != null && allAlarmsReceived ? (totalAlarms += alarmList.size()) : (totalAlarms += thisVcTotalAlarms);
            alarmList = this.sortAndLimitAlarms(alarmList, sort, maxCount, offset);
            data.alarmsPerVc.set(i, alarmList);
        }
        List<AlarmState> allAlarms = this.mergeAlarms(data.alarmsPerVc);
        allAlarms = this.sortAndLimitAlarms(allAlarms, sort, maxCount, offset);
        return new Result(allAlarms.toArray(new AlarmState[allAlarms.size()]), totalAlarms);
    }

    public Response queryData(List<Object> objects, Integer maxResultCount) {
        List<QuerySpec> querySpecs = null;
        querySpecs = AlarmStateRetriever.isMaxResultCountOptimizable(maxResultCount) ? this.getOptimizedQuerySpec(objects, maxResultCount) : this.getUnoptimizedQuerySpec(objects, maxResultCount);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = (QuerySpec[])ArrayUtil.toArray(querySpecs, QuerySpec.class);
        Response response = this._dataService.getData(requestSpec);
        return response;
    }

    private static ExtractVcAlarmsResult extractVcAlarms(ResultSet[] resultSets) {
        ArrayList<List<AlarmState>> alarmsPerVc = new ArrayList<List<AlarmState>>();
        ArrayList<Integer> totalCountPerVc = new ArrayList<Integer>();
        for (ResultSet result : resultSets) {
            if (result == null) continue;
            ResultItem[] items = result.items;
            if (ArrayUtil.isNullOrEmpty((Object[])result.items)) continue;
            for (ResultItem item : items) {
                Object[] properties = item.properties;
                if (ArrayUtil.isNullOrEmpty((Object[])properties)) continue;
                ArrayList<Object> alarmsPerThisVc = new ArrayList<Object>();
                int totalCountPerThisVc = -1;
                for (Object prop : properties) {
                    int triggeredAlarmsStateLength;
                    Object[] vcAlarms;
                    if (prop == null) continue;
                    if ((_TRIGGERED_ALARMS_PROPERTY.equals(((PropertyValue)prop).propertyName) || _TOP_TRIGGERED_UNACKNOWLEDGED_ALARMS_PROPERTY.equals(((PropertyValue)prop).propertyName) || _TOP_TRIGGERED_ACKNOWLEDGED_ALARMS_PROPERTY.equals(((PropertyValue)prop).propertyName)) && !ArrayUtil.isNullOrEmpty((Object[])(vcAlarms = (AlarmState[])((PropertyValue)prop).value))) {
                        alarmsPerThisVc.addAll(Arrays.asList(vcAlarms));
                    }
                    if (!_TRIGGERED_ALARMS_LENGTH_PROPERTY.equals(((PropertyValue)prop).propertyName)) continue;
                    totalCountPerThisVc = triggeredAlarmsStateLength = ((Integer)((PropertyValue)prop).value).intValue();
                }
                alarmsPerVc.add(alarmsPerThisVc);
                totalCountPerVc.add(totalCountPerThisVc < 0 ? alarmsPerThisVc.size() : totalCountPerThisVc);
            }
        }
        return new ExtractVcAlarmsResult(alarmsPerVc, totalCountPerVc);
    }

    private List<AlarmState> filterAlarms(List<AlarmState> alarms, String issueType) {
        return this._alarmStateFilter.filterByIssueType(alarms, issueType);
    }

    private List<AlarmState> sortAndLimitAlarms(List<AlarmState> alarms, boolean sort, int maxCount, int offset) {
        if (sort) {
            Collections.sort(alarms, this._alarmStateComparator);
        }
        if (maxCount > 0 && maxCount < alarms.size()) {
            if (offset > 0) {
                if (maxCount + offset > alarms.size()) {
                    if (alarms.size() < offset) {
                        return Collections.emptyList();
                    }
                    return alarms.subList(offset, alarms.size());
                }
                return alarms.subList(offset, maxCount + offset);
            }
            return alarms.subList(0, maxCount);
        }
        return alarms;
    }

    private List<AlarmState> mergeAlarms(List<List<AlarmState>> alarmsPerVc) {
        if (alarmsPerVc.isEmpty()) {
            return new ArrayList<AlarmState>();
        }
        if (alarmsPerVc.size() == 1) {
            return alarmsPerVc.get(0);
        }
        int totalCount = 0;
        for (List<AlarmState> alarms : alarmsPerVc) {
            totalCount += alarms.size();
        }
        ArrayList<AlarmState> allAlarms = new ArrayList<AlarmState>(totalCount);
        for (List<AlarmState> alarms : alarmsPerVc) {
            allAlarms.addAll(alarms);
        }
        return allAlarms;
    }

    private static boolean isMaxResultCountOptimizable(Integer maxResultCount) {
        return maxResultCount != null && maxResultCount >= 0 && maxResultCount <= 150;
    }

    private List<QuerySpec> getUnoptimizedQuerySpec(List<Object> objects, Integer maxResultCount) {
        Constraint[] nestedConstraints = new Constraint[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            ObjectIdentityConstraint objectConstraint = new ObjectIdentityConstraint();
            objectConstraint.target = object;
            nestedConstraints[i] = objectConstraint;
        }
        CompositeConstraint constraint = new CompositeConstraint();
        constraint.nestedConstraints = nestedConstraints;
        constraint.conjoiner = Conjoiner.OR;
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)constraint, new String[]{_TRIGGERED_ALARMS_PROPERTY});
        querySpec.resultSpec = new ResultSpec();
        querySpec.resultSpec.maxResultCount = maxResultCount;
        ArrayList<QuerySpec> result = new ArrayList<QuerySpec>(1);
        result.add(querySpec);
        return result;
    }

    private List<QuerySpec> getOptimizedQuerySpec(List<Object> objects, Integer maxResultCount) {
        QuerySpec querySpec;
        CompositeConstraint constraint;
        ArrayList<ObjectIdentityConstraint> optimizableObjects = new ArrayList<ObjectIdentityConstraint>();
        ArrayList<ObjectIdentityConstraint> unoptimizableObjects = new ArrayList<ObjectIdentityConstraint>();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            ObjectIdentityConstraint objectConstraint = new ObjectIdentityConstraint();
            objectConstraint.target = object;
            if (object instanceof ManagedObjectReference) {
                ManagedObjectReference mor = (ManagedObjectReference)object;
                if (VcServiceUtil.is65VcOrLaterByServerGuid((String)mor.getServerGuid(), (boolean)true) && ManagedObjectUtil.isOfType((ManagedObjectReference)mor, Folder.class)) {
                    optimizableObjects.add(objectConstraint);
                    continue;
                }
                unoptimizableObjects.add(objectConstraint);
                continue;
            }
            unoptimizableObjects.add(objectConstraint);
        }
        ArrayList<QuerySpec> result = new ArrayList<QuerySpec>(2);
        if (!unoptimizableObjects.isEmpty()) {
            constraint = new CompositeConstraint();
            constraint.nestedConstraints = (Constraint[])ArrayUtil.toArray(unoptimizableObjects, Constraint.class);
            constraint.conjoiner = Conjoiner.OR;
            querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)constraint, new String[]{_TRIGGERED_ALARMS_PROPERTY});
            querySpec.resultSpec = new ResultSpec();
            querySpec.resultSpec.maxResultCount = maxResultCount;
            result.add(querySpec);
        }
        if (!optimizableObjects.isEmpty()) {
            constraint = new CompositeConstraint();
            constraint.nestedConstraints = (Constraint[])ArrayUtil.toArray(optimizableObjects, Constraint.class);
            constraint.conjoiner = Conjoiner.OR;
            querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)constraint, new String[]{_TOP_TRIGGERED_UNACKNOWLEDGED_ALARMS_PROPERTY, _TOP_TRIGGERED_ACKNOWLEDGED_ALARMS_PROPERTY, _TRIGGERED_ALARMS_LENGTH_PROPERTY});
            querySpec.resultSpec = new ResultSpec();
            querySpec.resultSpec.maxResultCount = maxResultCount;
            result.add(querySpec);
        }
        return result;
    }

    public static class Result {
        public AlarmState[] alarms;
        public int totalAlarms;

        public Result() {
        }

        public Result(AlarmState[] alarms, int total) {
            this.alarms = alarms;
            this.totalAlarms = total;
        }
    }

    private static class ExtractVcAlarmsResult {
        public List<List<AlarmState>> alarmsPerVc;
        public List<Integer> totalCountPerVc;

        public ExtractVcAlarmsResult(List<List<AlarmState>> alarmsPerVc, List<Integer> totalCountPerVc) {
            this.alarmsPerVc = alarmsPerVc;
            this.totalCountPerVc = totalCountPerVc;
        }
    }
}

