/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.opsmgmt.client.alarms.util.ServiceAlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import com.vmware.vise.vim.commons.messaging.UpdatesProcessor;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggeredAlarmsUpdatesProcessor
implements UpdatesProcessor<AlarmState> {
    private static final Log _logger = LogFactory.getLog(TriggeredAlarmsUpdatesProcessor.class);
    private static final String TRIGGERED_ALARM_STATE = "triggeredAlarmState";
    private static final String ALARM_INFOS_QUERY_NAME = "TriggeredAlarmsUpdatesProcessor.alarmInfos";
    private static final String ENTITY_NAMES_QUERY_NAME = "TriggeredAlarmsUpdatesProcessor.entityNames";
    private static final String SERVICE_INFOS_LOGGING_PREFIX = "TriggeredAlarmsUpdatesProcessor.serviceInfos";
    private static final Pattern ALARM_STATE_KEY = Pattern.compile("triggeredAlarmState\\[\"(?<key>.*?)\"\\]");
    private static final String REGEX_ALARMSTATE_KEY = "key";
    private final ConfigurationService _configurationService;
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private ServiceAlarmInfoRetriever _serviceAlarmInfoRetriever;

    public TriggeredAlarmsUpdatesProcessor(ConfigurationService configurationService, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._configurationService = configurationService;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    public void setServiceAlarmInfoRetriever(ServiceAlarmInfoRetriever serviceAlarmInfoRetriever) {
        this._serviceAlarmInfoRetriever = serviceAlarmInfoRetriever;
    }

    public PartialUpdate<AlarmState> process(String destination, PropertyCollector.FilterUpdate filterUpdate) {
        if (!this.enableProcessing()) {
            return null;
        }
        if (!"/topic/alarms".equals(destination)) {
            return null;
        }
        PartialUpdate result = PartialUpdate.empty();
        PropertyCollector.ObjectUpdate[] objectUpdates = filterUpdate.getObjectSet();
        if (objectUpdates == null) {
            return result;
        }
        block0: for (PropertyCollector.ObjectUpdate objectUpdate : objectUpdates) {
            PropertyCollector.Change[] changes;
            if (objectUpdate.missingSet != null) {
                _logger.warn((Object)"missing object set");
            }
            for (PropertyCollector.Change change : changes = objectUpdate.getChangeSet()) {
                if (change.getName().startsWith(TRIGGERED_ALARM_STATE)) {
                    if (this.isNewAbsoluteValueReceived(change)) {
                        AlarmState[] alarmStates;
                        if (!change.val.getClass().isArray()) {
                            _logger.error((Object)"'triggeredAlarmState' property value MUST be an array");
                            continue block0;
                        }
                        for (AlarmState alarmState : alarmStates = (AlarmState[])change.val) {
                            result.getUpdates().add(PartialUpdateItem.of((Object)alarmState, (Object)alarmState.alarm));
                        }
                        result.isDelta = false;
                        result.deleted.add(objectUpdate.obj);
                        if (changes.length == 1) continue block0;
                        _logger.error((Object)"Unable to handle a delta together with an absolute value");
                        continue block0;
                    }
                    PartialUpdateItem<AlarmState> update = this.createAlarmUpdate(change);
                    if (update == null) continue;
                    AlarmUtil.assignMetadata(update, "objUpdateGuid", objectUpdate.obj.getServerGuid());
                    result.updates.add(update);
                    continue;
                }
                _logger.warn((Object)("Unexpected change with name: " + change.getName()));
            }
        }
        boolean metadataAdded = this.addMetadataToNewAlarms((PartialUpdate<AlarmState>)result, result.updates);
        if (!metadataAdded) {
            this.filterNewAlarms((PartialUpdate<AlarmState>)result);
        }
        return result;
    }

    public PropertyCollector.FilterSpec createFilterSpec(String destination, VcService vc) {
        if (!this.enableProcessing()) {
            return null;
        }
        if (!"/topic/alarms".equals(destination)) {
            return null;
        }
        if (VcServiceUtil.is65VcOrLaterByVersion((String)vc.getServiceVersion())) {
            return null;
        }
        PropertyCollector.ObjectSpec objectSpec = new PropertyCollector.ObjectSpec();
        objectSpec.setObj(vc.getServiceInstanceContent().rootFolder);
        objectSpec.setSkip(Boolean.valueOf(false));
        PropertyCollector.PropertySpec propSpec = new PropertyCollector.PropertySpec();
        propSpec.setType((TypeName)new TypeNameImpl("Folder"));
        propSpec.setPathSet(new String[]{TRIGGERED_ALARM_STATE});
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec();
        filterSpec.objectSet = new PropertyCollector.ObjectSpec[]{objectSpec};
        filterSpec.propSet = new PropertyCollector.PropertySpec[]{propSpec};
        return filterSpec;
    }

    private void filterNewAlarms(PartialUpdate<AlarmState> update) {
        ArrayList<PartialUpdateItem> filteredUpdate = new ArrayList<PartialUpdateItem>();
        for (PartialUpdateItem updateItem : update.updates) {
            if (!updateItem.isDelta) continue;
            filteredUpdate.add(updateItem);
        }
        update.updates = filteredUpdate;
    }

    private boolean isNewAbsoluteValueReceived(PropertyCollector.Change change) {
        return TRIGGERED_ALARM_STATE.equals(change.getName()) && change.getOp() == PropertyCollector.Change.Op.assign;
    }

    private PartialUpdateItem<AlarmState> createAlarmUpdate(PropertyCollector.Change change) {
        Object val;
        PartialUpdateItem update = null;
        if (change.getOp() == PropertyCollector.Change.Op.remove) {
            String alarmStateKey = TriggeredAlarmsUpdatesProcessor.extractAlarmStateKey(change.getName());
            AlarmState alarmState = new AlarmState();
            alarmState.key = alarmStateKey;
            update = PartialUpdateItem.deltaOf(null, (Object)alarmStateKey);
        } else if (change.getOp() == PropertyCollector.Change.Op.add) {
            AlarmState alarmState = (AlarmState)change.getVal();
            update = PartialUpdateItem.of((Object)alarmState, (Object)alarmState.alarm);
        } else if (change.getOp() == PropertyCollector.Change.Op.assign && (val = change.getVal()) instanceof AlarmState) {
            AlarmState alarmState = (AlarmState)val;
            update = PartialUpdateItem.deltaOf((Object)alarmState, (Object)alarmState.alarm);
        }
        return update;
    }

    private boolean addMetadataToNewAlarms(PartialUpdate<AlarmState> result, List<PartialUpdateItem<AlarmState>> updates) {
        if (updates.isEmpty()) {
            return true;
        }
        ArrayList<AlarmState> alarmsList = new ArrayList<AlarmState>();
        HashMap<ManagedObjectReference, AlarmInfo> alarmInfos = new HashMap<ManagedObjectReference, AlarmInfo>();
        HashSet<ManagedObjectReference> entityNonRoots = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> entityRoots = new HashSet<ManagedObjectReference>();
        HashMap<ManagedObjectReference, String> entityNames = new HashMap<ManagedObjectReference, String>();
        this.extractAlarmInfosAndEntities(updates, alarmsList, alarmInfos, entityNonRoots, entityRoots);
        Set<ManagedObjectReference> alarmInfoKeys = alarmInfos.keySet();
        if (!this.populateAlarmInfos(alarmInfos, entityNonRoots, entityRoots, alarmInfoKeys) || !this.populateEntityNames(entityNonRoots, entityRoots, entityNames)) {
            return false;
        }
        Map<String, ServiceAlarmInfo> serviceInfos = this._serviceAlarmInfoRetriever.retrieve(alarmsList, SERVICE_INFOS_LOGGING_PREFIX);
        this.populateMetadataForAlarms(result, alarmInfos, entityNames, serviceInfos);
        return true;
    }

    private void populateMetadataForAlarms(PartialUpdate<AlarmState> result, HashMap<ManagedObjectReference, AlarmInfo> alarmInfos, Map<ManagedObjectReference, String> entityNames, Map<String, ServiceAlarmInfo> serviceInfos) {
        StringBuilder unpopulatedAlarmsMessage = null;
        for (PartialUpdateItem partialUpdateItem : result.updates) {
            if (partialUpdateItem.isDelta) continue;
            AlarmState alarmState = (AlarmState)partialUpdateItem.data;
            String alarmStateKey = alarmState.key;
            ManagedObjectReference alarmStateEntity = alarmState.entity;
            AlarmInfo alarmInfo = alarmInfos.get(alarmState.alarm);
            if (alarmInfo != null) {
                AlarmUtil.assignMetadata(partialUpdateItem, alarmStateKey, alarmInfo);
                ManagedObjectReference alarmInfoEntity = alarmInfo.entity;
                this.assignAlarmInfoNameMetadata(entityNames, (PartialUpdateItem<AlarmState>)partialUpdateItem, alarmInfoEntity);
                boolean showVamiLink = AlarmUtil.isVamiLinkVisisble(alarmInfo, alarmStateEntity);
                AlarmUtil.assignMetadata(partialUpdateItem, "showVAMILink", showVamiLink);
                AlarmUtil.assignMetadata(partialUpdateItem, "issueUri", DefaultUriSchemeUtil.createUri((String)"AlarmIssue", (String)alarmStateKey));
                this.assignIssueInfoMetadata(entityNames, serviceInfos, (PartialUpdateItem<AlarmState>)partialUpdateItem, alarmState, alarmStateEntity, alarmInfo);
                continue;
            }
            String alarmId = alarmStateEntity != null ? alarmStateKey + '(' + alarmStateEntity.getValue() + ':' + alarmStateEntity.getServerGuid() + ')' : alarmStateKey;
            if (unpopulatedAlarmsMessage == null) {
                unpopulatedAlarmsMessage = new StringBuilder("AlarmInfo is not populated for the following alarms:");
                unpopulatedAlarmsMessage.append(alarmId);
                continue;
            }
            unpopulatedAlarmsMessage.append(',').append(alarmId);
        }
        if (unpopulatedAlarmsMessage != null) {
            _logger.error((Object)unpopulatedAlarmsMessage.toString());
        }
    }

    private void assignIssueInfoMetadata(Map<ManagedObjectReference, String> entityNames, Map<String, ServiceAlarmInfo> serviceInfos, PartialUpdateItem<AlarmState> partialUpdateItem, AlarmState alarmState, ManagedObjectReference alarmStateEntity, AlarmInfo alarmInfo) {
        IssueInfo issueInfo = new IssueInfo();
        if (alarmStateEntity != null) {
            issueInfo.entity = alarmStateEntity;
            String alarmStateEntityName = entityNames.get(alarmStateEntity);
            if (alarmStateEntityName != null) {
                issueInfo.entityName = alarmStateEntityName;
            } else {
                _logger.error((Object)"AlarmState entity name is null");
            }
        } else {
            _logger.error((Object)"AlarmState entity is null");
        }
        issueInfo.description = alarmInfo.description;
        ServiceAlarmInfo serviceAlarmInfo = serviceInfos.get(Util.buildAlarmKey(alarmState));
        issueInfo.service = serviceAlarmInfo;
        AlarmUtil.assignMetadata(partialUpdateItem, "issueInfo", issueInfo);
    }

    private void assignAlarmInfoNameMetadata(Map<ManagedObjectReference, String> entityNames, PartialUpdateItem<AlarmState> partialUpdateItem, ManagedObjectReference alarmInfoEntity) {
        if (alarmInfoEntity != null) {
            String alarmInfoEntityName = entityNames.get(alarmInfoEntity);
            if (alarmInfoEntityName != null) {
                AlarmUtil.assignMetadata(partialUpdateItem, "alarmInfoName", alarmInfoEntityName);
            } else {
                _logger.error((Object)"AlarmInfo entity name is null.");
            }
        } else {
            _logger.error((Object)"AlarmInfo entity is null.");
        }
    }

    private boolean populateAlarmInfos(HashMap<ManagedObjectReference, AlarmInfo> alarmInfos, Set<ManagedObjectReference> entityNonRoots, Set<ManagedObjectReference> entityRoots, Set<ManagedObjectReference> alarmInfoKeys) {
        PropertyValue[] alarmInfoProps;
        if (alarmInfoKeys.isEmpty()) {
            return true;
        }
        try {
            alarmInfoProps = this.queryProperties(alarmInfoKeys, "info", ALARM_INFOS_QUERY_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)("[LiveRefresh] Couldnt retrieve infos: " + e.getMessage()), (Throwable)e);
            return false;
        }
        for (PropertyValue pv : alarmInfoProps) {
            AlarmInfo alarmInfo = (AlarmInfo)pv.value;
            if (alarmInfo == null || alarmInfo.alarm == null) continue;
            alarmInfos.put(alarmInfo.alarm, alarmInfo);
            if (alarmInfo.entity == null) continue;
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmInfo.entity)) {
                entityRoots.add(alarmInfo.entity);
                continue;
            }
            entityNonRoots.add(alarmInfo.entity);
        }
        return true;
    }

    private boolean populateEntityNames(Set<ManagedObjectReference> entityNonRoots, Set<ManagedObjectReference> entityRoots, Map<ManagedObjectReference, String> entityNames) {
        PropertyValue[] entityNameProps;
        for (ManagedObjectReference entityRoot : entityRoots) {
            String entityName = VcServiceUtil.getServiceName((String)entityRoot.getServerGuid());
            if (entityName == null) continue;
            entityNames.put(entityRoot, entityName);
        }
        if (entityNonRoots.isEmpty()) {
            return true;
        }
        try {
            entityNameProps = this.queryProperties(entityNonRoots, "name", ENTITY_NAMES_QUERY_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot extract entity names", (Throwable)e);
            return false;
        }
        for (PropertyValue entityPropVal : entityNameProps) {
            entityNames.put((ManagedObjectReference)entityPropVal.resourceObject, (String)entityPropVal.value);
        }
        return true;
    }

    private PropertyValue[] queryProperties(Set<ManagedObjectReference> objects, String propertyName, String queryName) throws Exception {
        ResultItem[] items;
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(ArrayUtil.toArray(objects, ManagedObjectReference.class), new String[]{propertyName});
        querySpec.name = queryName;
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                for (PropertyValue v : item.properties) {
                    v.resourceObject = item.resourceObject;
                    result.add(v);
                }
            }
        }
        if (result.isEmpty() && resultSet != null && resultSet.error != null) {
            throw resultSet.error;
        }
        return result.toArray(new PropertyValue[0]);
    }

    private void extractAlarmInfosAndEntities(List<PartialUpdateItem<AlarmState>> updates, List<AlarmState> alarmsList, HashMap<ManagedObjectReference, AlarmInfo> alarmInfos, Set<ManagedObjectReference> entityNonRoots, Set<ManagedObjectReference> entityRoots) {
        for (PartialUpdateItem<AlarmState> pui : updates) {
            if (pui.isDelta) continue;
            AlarmState alarmState = (AlarmState)pui.data;
            alarmsList.add(alarmState);
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmState.entity)) {
                entityRoots.add(alarmState.entity);
            } else {
                entityNonRoots.add(alarmState.entity);
            }
            alarmInfos.put(alarmState.alarm, null);
        }
    }

    private static String extractAlarmStateKey(String name) {
        Matcher m = ALARM_STATE_KEY.matcher(name);
        if (!m.matches()) {
            _logger.error((Object)("Couldnt find a regex match for: " + name));
            return "";
        }
        String key = m.group(REGEX_ALARMSTATE_KEY);
        return key;
    }

    private boolean enableProcessing() {
        return LiveUpdatesUtil.alarmsEnabled((ConfigurationService)this._configurationService) && LiveUpdatesUtil.alarmsPcBasedUpdateEnabled((ConfigurationService)this._configurationService);
    }
}

