/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.AlarmAcknowledgementSpec;
import com.vmware.opsmgmt.client.alarms.AlarmStatusSpec;
import com.vmware.opsmgmt.client.alarms.EnableAlarmActionsSpec;
import com.vmware.opsmgmt.client.alarms.NewAlarmDefinitionSpec;
import com.vmware.opsmgmt.client.alarms.RemoveAlarmDefinitionSpec;
import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.Alarm;
import com.vmware.vim.binding.vim.alarm.AlarmManager;
import com.vmware.vim.binding.vim.alarm.AlarmSpec;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.messaging.MutationOperationUpdatePublisher;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(AlarmMutationProvider.class);
    private ConfigurationService _configurationService;
    private MutationOperationUpdatePublisher _mutationOperationUpdatePublisher;

    public void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    public void setMutationOperationUpdatePublisher(MutationOperationUpdatePublisher mutationOperationUpdatePublisher) {
        this._mutationOperationUpdatePublisher = mutationOperationUpdatePublisher;
    }

    public OperationResult apply(ManagedObjectReference entity, AlarmAcknowledgementSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = entity;
        try {
            _logger.info((Object)"Set alarm acknowledged state.");
            AlarmManager alarmManager = this.getAlarmManager(entity.getServerGuid());
            ManagedObjectReference alarm = spec.alarm;
            alarmManager.acknowledgeAlarm(alarm, entity);
            this.publishOperationUpdateIfNeeded(alarmManager, entity, alarm);
        }
        catch (Exception ex) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
            _logger.error((Object)("Unable to set the alarm's acknowledged state " + ex));
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference entity, AlarmStatusSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = entity;
        try {
            _logger.info((Object)("Set alarm status " + spec.status));
            AlarmManager alarmManager = this.getAlarmManager(entity.getServerGuid());
            ManagedObjectReference alarm = spec.alarm;
            alarmManager.setAlarmStatus(alarm, entity, spec.status);
            this.publishOperationUpdateIfNeeded(alarmManager, entity, alarm);
        }
        catch (Exception ex) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
            _logger.error((Object)("Unable to set the alarm status " + ex));
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference entity, AlarmSpec alarmSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = entity;
        try {
            _logger.info((Object)("Reconfigure alarm " + alarmSpec.name));
            Alarm alarm = (Alarm)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entity);
            alarm.reconfigure(alarmSpec);
        }
        catch (Exception ex) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
            _logger.error((Object)("Unable to reconfigure alarm " + ex));
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference entity, EnableAlarmActionsSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = entity;
        try {
            _logger.info((Object)("Set enabled alarms state to " + spec.enabled));
            AlarmManager alarmMgr = this.getAlarmManager(entity.getServerGuid());
            alarmMgr.setAlarmActionsEnabled(entity, spec.enabled);
        }
        catch (Exception ex) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
            _logger.error((Object)("Unable to set the enabled alarm state. " + ex.getMessage()));
        }
        return operationResult;
    }

    public OperationResult add(NewAlarmDefinitionSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = spec.context;
        try {
            _logger.info((Object)("Create mew Alarm " + spec.alarmSpec.name));
            AlarmManager alarmMgr = this.getAlarmManager(spec.context.getServerGuid());
            alarmMgr.create(spec.context, spec.alarmSpec);
        }
        catch (Exception ex) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
            _logger.error((Object)("Unable to crate a new alarm " + ex.getMessage()));
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference alarmRef, RemoveAlarmDefinitionSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = alarmRef;
        try {
            _logger.info((Object)("Remove alarm " + alarmRef));
            Alarm alarm = (Alarm)ManagedObjectUtil.getManagedObject((ManagedObjectReference)alarmRef);
            alarm.remove();
        }
        catch (Exception ex) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
            _logger.error((Object)("Unable to remove alarm " + ex.getMessage()));
        }
        return operationResult;
    }

    private void publishOperationUpdateIfNeeded(AlarmManager alarmManager, ManagedObjectReference entity, ManagedObjectReference alarm) {
        String serverGuid = entity.getServerGuid();
        boolean is65OrLater = VcServiceUtil.is65VcOrLaterByServerGuid((String)serverGuid);
        if (is65OrLater || !LiveUpdatesUtil.alarmsEnabled((ConfigurationService)this._configurationService) || LiveUpdatesUtil.alarmsPcBasedUpdateEnabled((ConfigurationService)this._configurationService)) {
            return;
        }
        if (this._mutationOperationUpdatePublisher == null) {
            _logger.warn((Object)"The mutation publisher is not initialized.");
            return;
        }
        try {
            AlarmState[] states = alarmManager.getAlarmState(entity);
            if (states == null) {
                return;
            }
            PartialUpdateItem item = null;
            for (AlarmState state : states) {
                if (!state.alarm.equals((Object)alarm)) continue;
                if (state.overallStatus.equals((Object)ManagedEntity.Status.green)) {
                    item = PartialUpdateItem.deltaOf(null, (Object)state.key);
                    break;
                }
                if (!state.acknowledged.booleanValue()) break;
                item = PartialUpdateItem.deltaOf((Object)state, (Object)state.alarm);
                break;
            }
            if (item == null) {
                return;
            }
            AlarmUtil.assignMetadata(item, "objUpdateGuid", serverGuid);
            PartialUpdate update = PartialUpdate.empty();
            update.updates.add(item);
            update.setDestination("/topic/alarms");
            this._mutationOperationUpdatePublisher.publish(update);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to publish operation update.", (Throwable)exception);
        }
    }

    private AlarmManager getAlarmManager(String vcServerGuid) throws Exception {
        ManagedObjectReference alarmMgrRef = VimSessionUtil.getService((String)vcServerGuid).getServiceInstance().getContent().alarmManager;
        return (AlarmManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)alarmMgrRef);
    }
}

