/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.commons.util.MorUtil;
import com.vmware.opsmgmt.client.event.EventDetailDescription;
import com.vmware.opsmgmt.client.event.impl.EntityEventArgumentWrapper;
import com.vmware.opsmgmt.client.event.impl.EventDescriptionCollector;
import com.vmware.opsmgmt.client.event.impl.i18n.MessageParser;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vim.event.TaskEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vise.messaging.amf.DataObjectProxy;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventWrapper {
    private final String VIM_EVENT = "vim.event.";
    private final String VIM_BINDING_PREFIX = "com.vmware.vim.binding.";
    private ManagedObjectReference _targetMor;
    private String _targetMorName = "";
    private EventDetailDescription _eventDetailDescription;
    private String _eventLongDescription;
    private List<ManagedObjectReference> _extractedMoRefs;
    private List<EntityEventArgumentWrapper> _eventArguments;
    private final Event _serverEvent;
    private final EventDescriptionCollector _descriptionCollector;
    private final String _serverGuid;
    private static final Map<String, Pair<EventDescription.EventCategory, String>> localizedSeverities = new HashMap<String, Pair<EventDescription.EventCategory, String>>();

    public EventWrapper(Event serverEvent, EventDescriptionCollector collector, String serverGuid) {
        this._serverEvent = serverEvent;
        this._descriptionCollector = collector;
        this._serverGuid = serverGuid;
        this._eventArguments = new ArrayList<EntityEventArgumentWrapper>();
        this._extractedMoRefs = new ArrayList<ManagedObjectReference>();
        this.extractTarget();
        this.processEventDescription();
    }

    public ManagedObjectReference getTargetMor() {
        return this._targetMor;
    }

    public String getTargetMorName() {
        return MixedUtil.unescapeVimEntityNameSpecialChars((String)this._targetMorName);
    }

    public List<EntityEventArgumentWrapper> getEventArguments() {
        return this._eventArguments;
    }

    public Event getServerEvent() {
        return this._serverEvent;
    }

    public EventDetailDescription getEventDescription() {
        EventDetailDescription[] descriptions;
        if (this._eventDetailDescription == null && (descriptions = this._descriptionCollector.collectDetails(new String[]{this.getEventTypeId(this._serverEvent)})) != null && descriptions.length == 1 && descriptions[0] != null) {
            this._eventDetailDescription = descriptions[0];
        }
        return this._eventDetailDescription;
    }

    public String getEventTypeId() {
        String typeId = this.getEventTypeId(this._serverEvent);
        if (typeId.startsWith("com.vmware.vim.binding.")) {
            typeId = typeId.substring("com.vmware.vim.binding.".length());
        }
        return typeId;
    }

    public String getLongDescription() {
        if (this._eventLongDescription == null) {
            String typeId = this.getEventTypeId();
            if (typeId.startsWith("vim.event.")) {
                typeId = typeId.substring("vim.event.".length());
            }
            this._eventLongDescription = LocalizationUtil.getLocalizedMessage((String)(typeId + ".longDescription"), null);
        }
        return this._eventLongDescription;
    }

    public List<ManagedObjectReference> getMoRefs() {
        if (this._targetMor != null) {
            this._extractedMoRefs.add(this._targetMor);
        }
        return this._extractedMoRefs;
    }

    public String getCategoryKey() {
        if (this._eventDetailDescription != null && this._eventDetailDescription.categoryDescription != null) {
            return this._eventDetailDescription.categoryDescription.key;
        }
        Pair<EventDescription.EventCategory, String> categoryMessagePair = this.getCategoryBySeverity(this._serverEvent);
        if (categoryMessagePair != null) {
            return ((EventDescription.EventCategory)categoryMessagePair.first).name();
        }
        return EventDescription.EventCategory.error.name();
    }

    public String getCategoryName() {
        if (this._eventDetailDescription != null && this._eventDetailDescription.categoryDescription != null) {
            return this._eventDetailDescription.categoryDescription.summary;
        }
        Pair<EventDescription.EventCategory, String> categoryMessagePair = this.getCategoryBySeverity(this._serverEvent);
        if (categoryMessagePair != null) {
            return (String)categoryMessagePair.second;
        }
        return Util.getLocalizedString("errorEventMessage");
    }

    private Pair<EventDescription.EventCategory, String> getCategoryBySeverity(Event event) {
        if (this._serverEvent instanceof EventEx) {
            EventEx eventEx = (EventEx)this._serverEvent;
            if (!StringUtil.isNullOrEmpty((String)eventEx.severity)) {
                return localizedSeverities.get(eventEx.severity);
            }
        }
        return null;
    }

    private String getEventTypeId(Event serverEvent) {
        String eventTypeId = null;
        eventTypeId = serverEvent instanceof ExtendedEvent ? ((ExtendedEvent)serverEvent).eventTypeId : (serverEvent instanceof EventEx ? ((EventEx)serverEvent).eventTypeId : serverEvent.getClass().getName());
        return eventTypeId;
    }

    private void extractTarget() {
        if (this._serverEvent instanceof TaskEvent) {
            TaskEvent event = (TaskEvent)this._serverEvent;
            this._targetMor = event.info.entity;
            this._targetMorName = event.info.entityName;
        } else {
            Event event = this._serverEvent;
            if (this.isStoragePodRelated()) {
                EventEx storagePodEvent = (EventEx)event;
                this._targetMor = this.constructStoragePodMor(storagePodEvent.objectId);
                this._targetMorName = storagePodEvent.objectName;
            } else if (event.getDvs() != null && event.getDvs().getDvs() != null) {
                this._targetMor = event.getDvs().getDvs();
                this._targetMorName = event.getDvs().getName();
            } else if (event.getNet() != null && event.getNet().getNetwork() != null) {
                this._targetMor = event.getNet().getNetwork();
                this._targetMorName = event.getNet().getName();
            } else if (event.getVm() != null && event.getVm().getVm() != null) {
                this._targetMor = event.getVm().getVm();
                this._targetMorName = event.getVm().getName();
            } else if (event.getHost() != null && event.getHost().getHost() != null) {
                this._targetMor = event.getHost().getHost();
                this._targetMorName = event.getHost().getName();
            } else if (event.getComputeResource() != null && event.getComputeResource().getComputeResource() != null) {
                this._targetMor = event.getComputeResource().getComputeResource();
                this._targetMorName = event.getComputeResource().getName();
            } else if (event.getDs() != null && event.getDs().getDatastore() != null) {
                this._targetMor = event.getDs().getDatastore();
                this._targetMorName = event.getDs().getName();
            } else if (event.getDatacenter() != null && event.getDatacenter().getDatacenter() != null) {
                this._targetMor = event.getDatacenter().getDatacenter();
                this._targetMorName = event.getDatacenter().getName();
            }
        }
    }

    private boolean isStoragePodRelated() {
        boolean result = false;
        if (this._serverEvent instanceof EventEx) {
            String objectType;
            EventEx event = (EventEx)this._serverEvent;
            String storagePodClassName = StoragePod.class.getAnnotation(wsdlName.class).value();
            if (event.objectType != null && storagePodClassName.equals(objectType = ((TypeNameImpl)event.objectType).getWsdlName())) {
                result = true;
            }
        }
        return result;
    }

    private ManagedObjectReference constructStoragePodMor(String value) {
        String type2 = StoragePod.class.getAnnotation(wsdlName.class).value();
        return MorUtil.buildMor((String)this._serverGuid, (String)type2, (String)value);
    }

    private void processEventDescription() {
        EventDetailDescription eventDescription = this.getEventDescription();
        if (eventDescription == null) {
            return;
        }
        MessageParser parser = new MessageParser(new DataObjectProxy((Object)this._serverEvent), this._serverEvent);
        parser.parse(eventDescription.eventDetail.fullFormat);
        List<EntityEventArgumentWrapper> argumentWrappers = parser.getArguments();
        for (EntityEventArgumentWrapper argumentWrapper : argumentWrappers) {
            this._eventArguments.add(argumentWrapper);
            this._extractedMoRefs.add(argumentWrapper.getMoref());
        }
    }

    static {
        localizedSeverities.put(Event.EventSeverity.error.name(), (Pair<EventDescription.EventCategory, String>)new Pair((Object)EventDescription.EventCategory.error, (Object)Util.getLocalizedString("errorEventMessage")));
        localizedSeverities.put(Event.EventSeverity.info.name(), (Pair<EventDescription.EventCategory, String>)new Pair((Object)EventDescription.EventCategory.info, (Object)Util.getLocalizedString("informationEventMessage")));
        localizedSeverities.put(Event.EventSeverity.user.name(), (Pair<EventDescription.EventCategory, String>)new Pair((Object)EventDescription.EventCategory.user, (Object)Util.getLocalizedString("userEventMessage")));
        localizedSeverities.put(Event.EventSeverity.warning.name(), (Pair<EventDescription.EventCategory, String>)new Pair((Object)EventDescription.EventCategory.warning, (Object)Util.getLocalizedString("warningEventMessage")));
    }
}

