/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseInventoryCache
implements UserSessionListener {
    private Log _logger = LogFactory.getLog(LicenseInventoryCache.class);
    private static final String APP_DEFENSE_FEATURE_NAME = "appdplugin";
    private final AtomicBoolean _containsLicenseWithAppDefenseFeature = new AtomicBoolean(false);
    private final ManagementEditor _managementEditor;
    private final Executor _executor;

    public LicenseInventoryCache(ManagementEditor licenseEditor, Executor executor) {
        Validate.notNull((Object)licenseEditor);
        Validate.notNull((Object)executor);
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseEditor, executor});
        this._managementEditor = licenseEditor;
        this._executor = executor;
    }

    public void sessionStarted(HttpSessionEvent event, Locale locale) {
        this.updateCachedValues();
    }

    public void sessionEnded(HttpSessionEvent event) throws Exception {
    }

    public boolean getContainsAppDefenseFeature() {
        return this._containsLicenseWithAppDefenseFeature.get();
    }

    protected void updateCachedValues() {
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext((boolean)true);
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                SessionUtil.ThreadContext originalThreadCtx = SessionUtil.getThreadContext();
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                try {
                    LicenseInventoryCache.this._logger.info((Object)"Retrieving license inventory...");
                    License[] licenses = LicenseInventoryCache.this._managementEditor.getLicenses(ManagementUtil.SCOPE_CIS_LICENSING, null);
                    LicenseInventoryCache.this._logger.info((Object)String.format("Retrieved %d licenses.", licenses == null ? 0 : licenses.length));
                    LicenseInventoryCache.this._containsLicenseWithAppDefenseFeature.set(LicenseInventoryCache.this.containsLicenseWithAppDefenseFeature(licenses));
                }
                catch (Exception ex) {
                    LicenseInventoryCache.this._logger.error((Object)"Failed to retrieve licenses.", (Throwable)ex);
                }
                finally {
                    SessionUtil.setThreadContext((SessionUtil.ThreadContext)originalThreadCtx);
                }
            }
        });
    }

    protected boolean containsLicenseWithAppDefenseFeature(License[] licenses) {
        if (licenses == null) {
            return false;
        }
        try {
            for (License license : licenses) {
                ProductRestriction[] productRestrictions;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("Checking license " + license.getName()));
                }
                if ((productRestrictions = license.getProductRestrictions()) == null) continue;
                for (ProductRestriction productRestriction : productRestrictions) {
                    Map<String, ProductCapability> versionToProductCapability = productRestriction.getVersionToProductCapability();
                    if (versionToProductCapability == null) continue;
                    for (ProductCapability productCapability : versionToProductCapability.values()) {
                        Feature[] features = productCapability.getFeatures();
                        if (features == null) continue;
                        for (Feature feature : features) {
                            if (feature == null || !APP_DEFENSE_FEATURE_NAME.equals(feature.getId())) continue;
                            this._logger.info((Object)"AppDefense feature found.");
                            return true;
                        }
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            this._logger.error((Object)"Error scanning license inventory.", (Throwable)ex);
        }
        this._logger.debug((Object)"AppDefense feature not found.");
        return false;
    }
}

