/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cluster.adapter;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.util.ExceptionUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.fault.NotFoundFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterLicensingPropertyProviderAdapterImpl
implements PropertyProviderAdapter {
    private static final String PROPERTY_NAME_IS_LICENSED = "isLicensed";
    private static final String MO_TYPE_CLUSTER = "ClusterComputeResource";
    private final DataServiceExtensionRegistry _dsExtensionRegistry;
    private final VpxManagementEditor _vpxManagementEditor;
    private final Log _logger = LogFactory.getLog(ClusterLicensingPropertyProviderAdapterImpl.class);

    public ClusterLicensingPropertyProviderAdapterImpl(DataServiceExtensionRegistry dsExtensionRegistry, VpxManagementEditor vpxManagementEditor) {
        this._dsExtensionRegistry = dsExtensionRegistry;
        this._vpxManagementEditor = vpxManagementEditor;
    }

    public void init() {
        TypeInfo providedTypeInfo = new TypeInfo();
        providedTypeInfo.type = MO_TYPE_CLUSTER;
        providedTypeInfo.properties = new String[]{PROPERTY_NAME_IS_LICENSED};
        TypeInfo[] providedTypesInfo = new TypeInfo[]{providedTypeInfo};
        this._dsExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, providedTypesInfo);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Asset resultClusterAsset;
        ManagedObjectReference clusterMoRef;
        ResultSet resultSet;
        block6: {
            ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
            resultSet = new ResultSet();
            Object[] requestedObjectsRefs = propertyRequest.objects;
            if (ArrayUtil.isNullOrEmpty((Object[])requestedObjectsRefs) || requestedObjectsRefs.length != 1) {
                int length = requestedObjectsRefs == null ? 0 : requestedObjectsRefs.length;
                this._logger.warn((Object)("Unable to provide isLicensed property. Requested objects refs length: " + length));
                return resultSet;
            }
            Object requestedObjectRef = requestedObjectsRefs[0];
            if (!(requestedObjectRef instanceof ManagedObjectReference) || !MO_TYPE_CLUSTER.equals(((ManagedObjectReference)requestedObjectRef).getType())) {
                this._logger.warn((Object)("Unable to provide isLicensed property. The request is for non-cluster object: " + requestedObjectRef));
                return resultSet;
            }
            Set<String> requestedPropertiesNames = ClusterLicensingPropertyProviderAdapterImpl.getPropertyNames(propertyRequest.properties);
            if (!requestedPropertiesNames.contains(PROPERTY_NAME_IS_LICENSED)) {
                this._logger.warn((Object)"Unable to provide isLicensed property. The property is not requested");
                return resultSet;
            }
            clusterMoRef = (ManagedObjectReference)requestedObjectRef;
            resultClusterAsset = null;
            try {
                LicenseScope scope = LicenseScopeUtil.getLicenseScopeByMoRef(clusterMoRef);
                Asset[] assets = this._vpxManagementEditor.getAssetsByMoRefs(new ManagedObjectReference[]{clusterMoRef}, scope);
                if (ArrayUtil.isNullOrEmpty((Object[])assets)) {
                    throw new IllegalStateException("Null or 0 assets returned for a single managed object reference.");
                }
                resultClusterAsset = assets[0];
            }
            catch (ManagementException e) {
                if (e.getCause() instanceof NotFoundFault) break block6;
                this._logger.error((Object)"Unable to provide isLicensed property. LS call failed.", (Throwable)e);
                resultSet.error = ExceptionUtil.createLocalizedException(e);
            }
        }
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = clusterMoRef;
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = clusterMoRef;
        propertyValue.propertyName = PROPERTY_NAME_IS_LICENSED;
        propertyValue.value = ClusterLicensingPropertyProviderAdapterImpl.isAssetLicensed(resultClusterAsset);
        resultItem.properties = new PropertyValue[]{propertyValue};
        resultSet.items = new ResultItem[]{resultItem};
        return resultSet;
    }

    private static Set<String> getPropertyNames(PropertySpec[] propertySpecs) {
        HashSet<String> resultPropertyNames = new HashSet<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])propertySpecs)) {
            return resultPropertyNames;
        }
        for (PropertySpec propertySpec : propertySpecs) {
            Object[] propertyNames;
            if (propertySpec == null || ArrayUtil.isNullOrEmpty((Object[])(propertyNames = propertySpec.propertyNames))) continue;
            for (Object propertyName : propertyNames) {
                resultPropertyNames.add((String)propertyName);
            }
        }
        return resultPropertyNames;
    }

    private static boolean isAssetLicensed(Asset asset) {
        return asset != null && AssetLicenseState.LICENSED.equals((Object)asset.getLicenseState());
    }
}

