/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenseScopeUtil {
    public static LicenseScope getLicenseScopeByMoRef(ManagedObjectReference moRef) {
        if (moRef == null) {
            return null;
        }
        String vcId = moRef.getServerGuid();
        return new LicenseScope(vcId);
    }

    public static LicenseScope getLicenseScopeByUiScope(LicenseUiScope licenseUiScope) {
        if (licenseUiScope == null || licenseUiScope.getId() == null) {
            return null;
        }
        return new LicenseScope(licenseUiScope.getId());
    }

    public static LicenseScope getLicenseScopeByUiObjectUri(URI uiObjectUri) {
        if (uiObjectUri == null) {
            return null;
        }
        String scopeId = UriUtil.getLicenseScopeId(uiObjectUri);
        if (scopeId != null && scopeId.isEmpty()) {
            return ManagementUtil.SCOPE_CIS_LICENSING;
        }
        return new LicenseScope(scopeId);
    }

    public static Map<LicenseScope, List<URI>> groupUiObjectsUrisByScope(URI[] uiObjectsUris) {
        HashMap<LicenseScope, List<URI>> scopeToUiObjectsUris = new HashMap<LicenseScope, List<URI>>();
        if (ArrayUtil.isNullOrEmpty((Object[])uiObjectsUris)) {
            return scopeToUiObjectsUris;
        }
        for (URI uiObjectUri : uiObjectsUris) {
            LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uiObjectUri);
            if (scope == null) continue;
            List<URI> scopeUiObjectsUris = scopeToUiObjectsUris.get(scope);
            if (scopeUiObjectsUris == null) {
                scopeUiObjectsUris = new ArrayList<URI>();
                scopeToUiObjectsUris.put(scope, scopeUiObjectsUris);
            }
            scopeUiObjectsUris.add(uiObjectUri);
        }
        return scopeToUiObjectsUris;
    }

    public static LicenseReportScope getLicenseReportScopeByUiObjectUri(URI uiObjectUri) {
        if (uiObjectUri == null) {
            return null;
        }
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uiObjectUri);
        if (licenseScope == null) {
            return null;
        }
        Date startDate = UriUtil.getStartDate(uiObjectUri);
        Date endDate = UriUtil.getEndDate(uiObjectUri);
        return new LicenseReportScope(licenseScope, startDate, endDate);
    }

    public static Map<LicenseReportScope, List<URI>> groupUiObjectsUrisByReportScope(URI[] uiObjectsUris) {
        HashMap<LicenseReportScope, List<URI>> reportScopeToUiObjectsUris = new HashMap<LicenseReportScope, List<URI>>();
        if (ArrayUtil.isNullOrEmpty((Object[])uiObjectsUris)) {
            return reportScopeToUiObjectsUris;
        }
        for (URI uiObjectUri : uiObjectsUris) {
            LicenseReportScope reportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(uiObjectUri);
            if (reportScope == null) continue;
            List<URI> reportScopeUiObjectsUris = reportScopeToUiObjectsUris.get(uiObjectsUris);
            if (reportScopeUiObjectsUris == null) {
                reportScopeUiObjectsUris = new ArrayList<URI>();
                reportScopeToUiObjectsUris.put(reportScope, reportScopeUiObjectsUris);
            }
            reportScopeUiObjectsUris.add(uiObjectUri);
        }
        return reportScopeToUiObjectsUris;
    }

    public static boolean doAssetsHaveSameScope(ManagedObjectReference[] assetRefs) {
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByMoRef(assetRefs[0]);
        for (int i = 1; i < assetRefs.length; ++i) {
            LicenseScope assetScope = LicenseScopeUtil.getLicenseScopeByMoRef(assetRefs[i]);
            if (scope.equals(assetScope)) continue;
            return false;
        }
        return true;
    }
}

