/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.util.LicensingMethodFault;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.util.ArrayUtil;

public class ExceptionUtil {
    public static Exception createLocalizedException(Throwable error) {
        if (error == null) {
            return null;
        }
        Throwable mostInnerCause = ExceptionUtil.getMostInnerCause(error);
        String localizedMessage = ExceptionUtil.getLocalizedMessage(mostInnerCause);
        return new LicensingMethodFault(mostInnerCause, localizedMessage);
    }

    public static Throwable getMostInnerCause(Throwable error) {
        if (error == null || error.getCause() == null) {
            return error;
        }
        return ExceptionUtil.getMostInnerCause(error.getCause());
    }

    private static String getLocalizedMessage(Throwable t) {
        LocalizableMessage[] localizableMessages = ExceptionUtil.getLocalizableMessages(t);
        String localizedMessage = ExceptionUtil.getLocalizedMessage(localizableMessages);
        return localizedMessage != null ? localizedMessage : t.getLocalizedMessage();
    }

    private static LocalizableMessage[] getLocalizableMessages(Throwable t) {
        if (t instanceof RuntimeFault) {
            RuntimeFault fault = (RuntimeFault)t;
            return fault.getFaultMessage();
        }
        if (t instanceof MethodFault) {
            MethodFault fault = (MethodFault)t;
            return fault.getFaultMessage();
        }
        return null;
    }

    private static String getLocalizedMessage(LocalizableMessage[] localizableMessages) {
        if (ArrayUtil.isNullOrEmpty((Object[])localizableMessages)) {
            return null;
        }
        LocalizableMessage localizableMessage = localizableMessages[0];
        if (localizableMessage == null) {
            return null;
        }
        String localizableMessageKey = localizableMessage.getKey();
        String result = ManagementUtil.getCatalogLocalizedString(localizableMessageKey, localizableMessage.getArg());
        if (result == null) {
            result = localizableMessage.getMessage();
        }
        return result;
    }
}

