/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.BaseReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import com.vmware.license.client.cis.reports.impl.CostUnitReportFactory;
import com.vmware.vim.binding.cis.license.report.ReportAssetUtilization;
import com.vmware.vim.binding.cis.license.report.ReportLicenseInfo;
import com.vmware.vim.binding.cis.license.report.ReportLicenseUtilization;
import com.vmware.vim.binding.cis.license.report.ReportProduct;
import com.vmware.vim.binding.cis.license.report.ReportProductUtilization;
import com.vmware.vim.binding.cis.license.report.SerialKeyReportLicenseInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;

public class ReportUtil {
    private static final CostUnitFactory COST_UNIT_FACTORY = CostUnitReportFactory.INSTANCE;

    public static ProductReport[] createProductReports(ReportProductUtilization[] reportProductUtilizations, LicenseReportScope licenseReportScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])reportProductUtilizations)) {
            return new ProductReport[0];
        }
        ProductReport[] productReports = new ProductReport[reportProductUtilizations.length];
        for (int i = 0; i < reportProductUtilizations.length; ++i) {
            productReports[i] = ReportUtil.createProductReport(reportProductUtilizations[i], licenseReportScope);
        }
        return productReports;
    }

    public static LicenseReport[] createLicenseReports(ReportLicenseUtilization[] reportLicenseUtilizations, LicenseReportScope licenseReportScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])reportLicenseUtilizations)) {
            return new LicenseReport[0];
        }
        LicenseReport[] licenseReports = new LicenseReport[reportLicenseUtilizations.length];
        for (int i = 0; i < reportLicenseUtilizations.length; ++i) {
            licenseReports[i] = ReportUtil.createLicenseReport(reportLicenseUtilizations[i], licenseReportScope);
        }
        return licenseReports;
    }

    public static AssetReport[] createAssetReports(ReportAssetUtilization[] reportAssetUtilizations, LicenseReportScope licenseReportScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])reportAssetUtilizations)) {
            return new AssetReport[0];
        }
        AssetReport[] assetReports = new AssetReport[reportAssetUtilizations.length];
        for (int i = 0; i < reportAssetUtilizations.length; ++i) {
            assetReports[i] = ReportUtil.createAssetReport(reportAssetUtilizations[i], licenseReportScope);
        }
        return assetReports;
    }

    public static LicensingDataDumpReport createLicensingDataDumpReport(byte[] licenseUsageDump, LicenseReportScope licenseReportScope) {
        LicensingDataDumpReport licensingDataDumpReport = new LicensingDataDumpReport();
        licensingDataDumpReport.setLicenseUsageDump(licenseUsageDump);
        URI licensingDataDumpReportUri = UriUtil.buildLicensingDataDumpReportUri(licenseReportScope);
        ReportUtil.populateReportProperties(licensingDataDumpReport, licensingDataDumpReportUri, null);
        return licensingDataDumpReport;
    }

    private static ProductReport createProductReport(ReportProductUtilization reportProductUtilization, LicenseReportScope licenseReportScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reportProductUtilization});
        ProductReport productReport = new ProductReport();
        CostUnit[] costUnits = COST_UNIT_FACTORY.createCostUnits(reportProductUtilization.getAggregatedCostUnitsUsage(), reportProductUtilization.getAggregatedCostUnitsLimit());
        productReport.setCostUnits(costUnits);
        productReport.setTreatZeroLimitAsNoCapacity(reportProductUtilization.getTreatZeroLimitAsNoCapacity());
        ReportProduct reportProduct = reportProductUtilization.getProduct();
        URI productReportUri = UriUtil.buildProductReportUri(reportProduct.getId(), licenseReportScope);
        ReportUtil.populateReportProperties(productReport, productReportUri, reportProduct.getName());
        return productReport;
    }

    private static void populateReportProperties(BaseReport report, URI uri, String name) {
        report.setUri(uri);
        report.setName(name);
    }

    private static LicenseReport createLicenseReport(ReportLicenseUtilization reportLicenseUtilization, LicenseReportScope licenseReportScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reportLicenseUtilization});
        LicenseReport licenseReport = new LicenseReport();
        ProductReport[] productReports = ReportUtil.createProductReports(reportLicenseUtilization.getAggregatedProductsUtilization(), licenseReportScope);
        licenseReport.setProductReports(productReports);
        ReportLicenseInfo reportLicenseInfo = reportLicenseUtilization.getLicense().getInfo();
        if (reportLicenseInfo instanceof SerialKeyReportLicenseInfo) {
            licenseReport.setSerialKeys(((SerialKeyReportLicenseInfo)reportLicenseInfo).getSerialKeys());
        }
        URI licenseReportUri = UriUtil.buildLicenseReportUri(reportLicenseUtilization.getLicense().getId(), licenseReportScope);
        ReportUtil.populateReportProperties(licenseReport, licenseReportUri, reportLicenseInfo.getName());
        return licenseReport;
    }

    private static AssetReport createAssetReport(ReportAssetUtilization reportAssetUtilization, LicenseReportScope licenseReportScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reportAssetUtilization});
        AssetReport assetReport = new AssetReport();
        CostUnit[] costUnitUsage = COST_UNIT_FACTORY.createCostUnits(reportAssetUtilization.getAggregatedCostUnitsUsage(), null);
        assetReport.setCostUnitUsage(costUnitUsage);
        URI assetReportUri = UriUtil.buildAssetReportUri(reportAssetUtilization.getAsset().getId(), licenseReportScope);
        ReportUtil.populateReportProperties(assetReport, assetReportUri, reportAssetUtilization.getAsset().getAssetInfo().getName());
        return assetReport;
    }
}

