/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.reports.ReportObjectsFormatter;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import com.vmware.vise.util.ArrayUtil;

public class ReportObjectsFormatterImpl
implements ReportObjectsFormatter {
    @Override
    public void formatProductReports(ProductReport[] productReports) {
        if (ArrayUtil.isNullOrEmpty((Object[])productReports)) {
            return;
        }
        for (ProductReport productReport : productReports) {
            CostUnit[] costUnits = productReport.getCostUnits();
            CostUnitUtil.formatCostUnits(costUnits);
            String formattedName = ProductUtil.getFormattedName(productReport.getName(), costUnits);
            productReport.setName(formattedName);
        }
    }

    @Override
    public void formatLicenseReports(LicenseReport[] licenseReports) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseReports)) {
            return;
        }
        for (LicenseReport licenseReport : licenseReports) {
            this.formatProductReports(licenseReport.getProductReports());
        }
    }

    @Override
    public void formatAssetReports(AssetReport[] assetReports) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetReports)) {
            return;
        }
        for (AssetReport assetReport : assetReports) {
            CostUnitUtil.formatCostUnits(assetReport.getCostUnitUsage());
        }
    }

    @Override
    public void formatLicensingDataDumpReports(LicensingDataDumpReport[] licensingDataDumpReports) {
    }
}

