/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.adapter;

import com.vmware.license.client.cis.adapter.BaseLicensingObjectsDataProviderAdapterImpl;
import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class BaseReportDataProviderAdapterImpl<T>
extends BaseLicensingObjectsDataProviderAdapterImpl<T> {
    private static final String START_DATE_PROPERTY_NAME = "startDate";
    private static final String END_DATE_PROPERTY_NAME = "endDate";

    @Override
    protected T[] getObjectsByCompositeConstraint(CompositeConstraint cc) {
        Constraint[] constraints;
        LicenseUiScope licenseUiScope = null;
        Date startDate = null;
        Date endDate = null;
        for (Constraint constraint : constraints = cc.nestedConstraints) {
            if (!(constraint instanceof PropertyConstraint)) continue;
            PropertyConstraint pc = (PropertyConstraint)constraint;
            if ("scope".equals(pc.propertyName)) {
                licenseUiScope = (LicenseUiScope)((Object)pc.comparableValue);
                continue;
            }
            if (START_DATE_PROPERTY_NAME.equals(pc.propertyName)) {
                startDate = (Date)pc.comparableValue;
                continue;
            }
            if (!END_DATE_PROPERTY_NAME.equals(pc.propertyName)) continue;
            endDate = (Date)pc.comparableValue;
        }
        if (licenseUiScope == null || startDate == null || endDate == null) {
            return super.getObjectsByCompositeConstraint(cc);
        }
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        LicenseReportScope licenseReportScope = new LicenseReportScope(scope, startDate, endDate);
        return this.getObjectsByReportScope(licenseReportScope);
    }

    @Override
    protected T[] getObjectsByUris(URI[] objectUris) {
        if (ArrayUtil.isNullOrEmpty((Object[])objectUris)) {
            return super.getObjectsByUris(objectUris);
        }
        Map<LicenseReportScope, List<URI>> reportScopeToUris = LicenseScopeUtil.groupUiObjectsUrisByReportScope(objectUris);
        if (reportScopeToUris.size() == 1) {
            LicenseReportScope reportScope = reportScopeToUris.keySet().iterator().next();
            return this.getObjectsByUrisAndReportScope(objectUris, reportScope);
        }
        ArrayList result = new ArrayList();
        Object[] objects = null;
        for (Map.Entry<LicenseReportScope, List<URI>> entry : reportScopeToUris.entrySet()) {
            URI[] uris = entry.getValue().toArray(new URI[entry.getValue().size()]);
            LicenseReportScope reportScope = entry.getKey();
            objects = this.getObjectsByUrisAndReportScope(uris, reportScope);
            ArrayUtil.append(result, (Object[])objects);
        }
        return result.toArray(objects);
    }

    protected T[] getObjectsByReportScope(LicenseReportScope licenseReportScope) {
        return null;
    }

    protected T[] getObjectsByUrisAndReportScope(URI[] objectUris, LicenseReportScope licenseReportScope) {
        return null;
    }
}

