/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.adapter;

import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.reports.ReportEditor;
import com.vmware.license.client.cis.reports.adapter.AssetReportPropertyProviderBean;
import com.vmware.license.client.cis.reports.adapter.BaseReportDataProviderAdapterImpl;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.type;
import java.net.URI;

@type(value="AssetReport")
public class AssetReportDataProviderAdapterImpl
extends BaseReportDataProviderAdapterImpl<AssetReport> {
    private static final String PROPERTY_NAME_LICENSE_REPORT_URI = "licenseReportUri";
    private static final String PROPERTY_NAME_COST_UNIT_ID = "costUnitId";
    private static final String RELATION_ASSET_REPORTS = "assetReports";
    private final ReportEditor _reportEditor;

    public AssetReportDataProviderAdapterImpl(ReportEditor reportEditor) {
        this._reportEditor = reportEditor;
    }

    @Override
    protected BasePropertyProviderBean<AssetReport> getPropertyProvider() {
        return new AssetReportPropertyProviderBean();
    }

    @Override
    protected String getProvidedType() {
        return "AssetReport";
    }

    @Override
    protected URI getUri(AssetReport assetReprot) {
        return assetReprot.getUri();
    }

    protected AssetReport[] getObjectsByRelationalConstraint(RelationalConstraint rc) {
        String relation = rc.relation;
        if (!RELATION_ASSET_REPORTS.equals(relation) || !(rc.constraintOnRelatedObject instanceof CompositeConstraint)) {
            return (AssetReport[])super.getObjectsByRelationalConstraint(rc);
        }
        CompositeConstraint cc = (CompositeConstraint)rc.constraintOnRelatedObject;
        String costUnitId = null;
        URI licenseReportUri = null;
        URI productReportUri = null;
        for (Constraint constraint : cc.nestedConstraints) {
            if (constraint instanceof PropertyConstraint) {
                PropertyConstraint pc = (PropertyConstraint)constraint;
                if (PROPERTY_NAME_COST_UNIT_ID.equals(pc.propertyName)) {
                    costUnitId = (String)pc.comparableValue;
                    continue;
                }
                if (!PROPERTY_NAME_LICENSE_REPORT_URI.equals(pc.propertyName)) continue;
                licenseReportUri = (URI)pc.comparableValue;
                continue;
            }
            if (!(constraint instanceof ObjectIdentityConstraint)) continue;
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            if (!(oic.target instanceof URI)) continue;
            productReportUri = (URI)oic.target;
        }
        if (licenseReportUri == null || productReportUri == null) {
            return (AssetReport[])super.getObjectsByRelationalConstraint(rc);
        }
        return this._reportEditor.getAssetReports(productReportUri, licenseReportUri, costUnitId);
    }
}

