/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncException;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationMyVMwareSyncEditorWrapperImpl
implements MyVMwareSyncEditor {
    private final MyVMwareSyncEditor _myVMwareSyncEditor;
    private final AuthorizationManager _authorizationManager;
    private final Log _logger = LogFactory.getLog(AuthorizationMyVMwareSyncEditorWrapperImpl.class);

    public AuthorizationMyVMwareSyncEditorWrapperImpl(MyVMwareSyncEditor myVMwareSyncEditor, AuthorizationManager authorizationManager) {
        this._myVMwareSyncEditor = myVMwareSyncEditor;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public MyVMwareSyncPreviewResult previewSyncFromMyVMware(MyVMwareSyncPreviewSpec syncPreviewSpec, LicenseScope scope) {
        this.validateLicensingPrivilegeGranted(scope);
        MyVMwareSyncPreviewResult result = this._myVMwareSyncEditor.previewSyncFromMyVMware(syncPreviewSpec, scope);
        return result;
    }

    @Override
    public void commitSyncFromMyVMware(MyVMwareSyncCommitSpec syncCommitSpec, LicenseScope scope) {
        this.validateLicensingPrivilegeGranted(scope);
        this._myVMwareSyncEditor.commitSyncFromMyVMware(syncCommitSpec, scope);
    }

    @Override
    public MyVMwareSyncInfo getSyncInfo(LicenseScope scope) throws MyVMwareSyncException {
        this.validateLicensingPrivilegeGranted(scope);
        return this._myVMwareSyncEditor.getSyncInfo(scope);
    }

    private void validateLicensingPrivilegeGranted(LicenseScope scope) {
        boolean licensingPrivilegeGranted;
        ValidationUtil.paramsNotNull((Object[])new Object[]{scope});
        try {
            licensingPrivilegeGranted = this._authorizationManager.isLicensingAdminPrivilegeGranted(scope);
        }
        catch (Exception e) {
            this._logger.warn((Object)"Unable to retrieve licensing privileges information. Assuming access is not granted.", (Throwable)e);
            licensingPrivilegeGranted = false;
        }
        if (!licensingPrivilegeGranted) {
            throw new MyVMwareSyncException(ManagementUtil.getLocalizedString("error.lsPrivilegeNotGranted"));
        }
    }
}

