/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.adapter;

import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCheckReportGenerationStatusResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCredentialsResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncFoldersResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncInitiateReportGenerationResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCheckReportGenerationStatusSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCredentialsSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncFoldersSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncInitiateReportGenerationSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncPreviewSpec;
import com.vmware.license.client.cis.myvmwaresync.util.MyVMwareApiExceptionUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareOnlineSyncMutationProvider
implements MutationProvider {
    private final Log _logger = LogFactory.getLog(MyVMwareOnlineSyncMutationProvider.class);
    private final MyVMwareOnlineSyncEditor _myVMwareOnlineSyncEditor;

    public MyVMwareOnlineSyncMutationProvider(MyVMwareOnlineSyncEditor myVMwareOnlineSyncEditor) {
        this._myVMwareOnlineSyncEditor = myVMwareOnlineSyncEditor;
    }

    public ValidationResult validate(MyVMwareOnlineSyncCredentialsSpec credentialsSpec) {
        try {
            MyVMwareOnlineSyncCredentialsResult credentialsResult = this._myVMwareOnlineSyncEditor.getUserEntitlementAccounts(credentialsSpec);
            return MutationUtil.createValidationResult((Object)credentialsResult);
        }
        catch (Exception e) {
            this.logError(e);
            return this.createExceptionValidationResult(e);
        }
    }

    public ValidationResult validate(MyVMwareOnlineSyncFoldersSpec foldersSpec) {
        try {
            MyVMwareOnlineSyncFoldersResult foldersResult = this._myVMwareOnlineSyncEditor.getEntitlementAccountFolders(foldersSpec);
            return MutationUtil.createValidationResult((Object)foldersResult);
        }
        catch (Exception e) {
            this.logError(e);
            return this.createExceptionValidationResult(e);
        }
    }

    public ValidationResult validate(MyVMwareOnlineSyncInitiateReportGenerationSpec initiateReportGenerationSpec) {
        try {
            MyVMwareOnlineSyncInitiateReportGenerationResult initiateReportGenerationResult = this._myVMwareOnlineSyncEditor.initiateReportGeneration(initiateReportGenerationSpec);
            return MutationUtil.createValidationResult((Object)initiateReportGenerationResult);
        }
        catch (Exception e) {
            this.logError(e);
            return this.createExceptionValidationResult(e);
        }
    }

    public ValidationResult validate(MyVMwareOnlineSyncCheckReportGenerationStatusSpec checkReportStatusSpec) {
        try {
            MyVMwareOnlineSyncCheckReportGenerationStatusResult checkReportStatusResult = this._myVMwareOnlineSyncEditor.checkReportGenerationStatus(checkReportStatusSpec);
            return MutationUtil.createValidationResult((Object)checkReportStatusResult);
        }
        catch (Exception e) {
            this.logError(e);
            return this.createExceptionValidationResult(e);
        }
    }

    public ValidationResult validate(MyVMwareOnlineSyncPreviewSpec onlineSyncPreviewSpec) {
        try {
            MyVMwareOnlineSyncPreviewResult onlineSyncPreviewResult = this._myVMwareOnlineSyncEditor.previewOnlineSync(onlineSyncPreviewSpec);
            return MutationUtil.createValidationResult((Object)onlineSyncPreviewResult);
        }
        catch (Exception e) {
            this.logError(e);
            return this.createExceptionValidationResult(e);
        }
    }

    private ValidationResult createExceptionValidationResult(Throwable exception) {
        Exception localizedException = MyVMwareApiExceptionUtil.convertToLocalizedException(exception);
        ValidationResult validationResult = new ValidationResult();
        validationResult.error = localizedException;
        return validationResult;
    }

    private void logError(Throwable t) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute My VMware online sync mutation operation: ", t);
        }
    }
}

