/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.web.util.UriUtils;

public class UriUtil {
    public static final String LICENSING_GLOBAL_DATA_TYPE = "LicensingGlobalData";
    public static final String PRODUCT_TYPE = "Product";
    public static final String LICENSE_TYPE = "License";
    public static final String ASSET_TYPE = "Asset";
    public static final String PRODUCT_REPORT_TYPE = "ProductReport";
    public static final String LICENSE_REPORT_TYPE = "CisLicenseReport";
    public static final String ASSET_REPORT_TYPE = "AssetReport";
    public static final String LICENSING_DATA_DUMP_REPORT_TYPE = "LicensingDataDumpReport";
    public static final String SYNC_INFO_OBJECT_TYPE = "MyVMwareSyncInfo";
    public static final LicenseScope EXTERNAL_SCOPE = new LicenseScope("ExternalScope");
    private static final String EXTERNAL_STRING_ID = "ExternalId";
    private static final URI EXTERNAL_URI_ID = DefaultUriSchemeUtil.createUri((String)"ExternalObject", (String)"id");
    private static final int URI_ID_INDEX = 0;
    private static final int URI_SCOPE_ID_INDEX = 1;
    private static final int URI_START_DATE_INDEX = 2;
    private static final int URI_END_DATE_INDEX = 3;
    private static final String CHARACTER_ENCODING = "UTF-8";

    public static boolean containsSingleUriWithType(Object[] objects, String type2) {
        if (ArrayUtil.isNullOrEmpty((Object[])objects) || objects.length != 1) {
            return false;
        }
        Object object = objects[0];
        if (!(object instanceof URI)) {
            return false;
        }
        return UriUtil.isUriOfType((URI)object, type2);
    }

    public static Date getStartDate(URI reportUri) {
        String startDate = UriUtil.getUriValueSegment(reportUri, 2);
        return new Date(Long.parseLong(startDate));
    }

    public static Date getEndDate(URI reportUri) {
        String endDate = UriUtil.getUriValueSegment(reportUri, 3);
        return new Date(Long.parseLong(endDate));
    }

    public static String getLicenseScopeId(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriType = DefaultUriSchemeUtil.getType((URI)uri);
        String scopeId = LICENSING_GLOBAL_DATA_TYPE.equals(uriType) ? DefaultUriSchemeUtil.getId((URI)uri) : UriUtil.getUriValueSegment(uri, 1);
        return scopeId;
    }

    public static URI[] extractObjectIdsAsUris(URI[] objectUris) {
        if (objectUris == null) {
            return null;
        }
        ArrayList<URI> objectIds = new ArrayList<URI>();
        for (int i = 0; i < objectUris.length; ++i) {
            objectIds.add(UriUtil.extractObjectIdAsUri(objectUris[i]));
        }
        return objectIds.toArray(new URI[objectIds.size()]);
    }

    public static String[] extractObjectIdsAsStrings(URI[] objectUris) {
        if (objectUris == null) {
            return null;
        }
        ArrayList<String> objectIds = new ArrayList<String>();
        for (int i = 0; i < objectUris.length; ++i) {
            objectIds.add(UriUtil.extractObjectIdAsString(objectUris[i]));
        }
        return objectIds.toArray(new String[objectIds.size()]);
    }

    public static String extractObjectIdAsString(URI objectUri) {
        String idValue = UriUtil.getUriValueSegment(objectUri, 0);
        try {
            return UriUtils.decode((String)idValue, (String)CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI extractObjectIdAsUri(URI objectUri) {
        try {
            return new URI(UriUtil.extractObjectIdAsString(objectUri));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("objectUri is not a valid URI");
        }
    }

    public static URI buildLicenseUri(URI licenseId, LicenseScope scope) {
        return UriUtil.buildScopeUri(LICENSE_TYPE, licenseId, scope);
    }

    public static URI buildExternalLicenseUri() {
        return UriUtil.buildLicenseUri(EXTERNAL_URI_ID, EXTERNAL_SCOPE);
    }

    public static URI buildProductUri(String productId, LicenseScope scope) {
        return UriUtil.buildScopeUri(PRODUCT_TYPE, productId, scope);
    }

    public static URI buildExternalProductUri() {
        return UriUtil.buildProductUri(EXTERNAL_STRING_ID, EXTERNAL_SCOPE);
    }

    public static URI buildAssetUri(URI assetId, LicenseScope scope) {
        return UriUtil.buildScopeUri(ASSET_TYPE, assetId, scope);
    }

    public static URI buildExternalAssetUri() {
        return UriUtil.buildAssetUri(EXTERNAL_URI_ID, EXTERNAL_SCOPE);
    }

    public static URI buildProductReportUri(String productId, LicenseReportScope licenseReportScope) {
        URI objectUri = DefaultUriSchemeUtil.createUri((String)PRODUCT_REPORT_TYPE, (String[])UriUtil.buildIdSegments(UriUtil.getEncodedId(productId), licenseReportScope));
        return objectUri;
    }

    public static URI buildLicenseReportUri(URI licenseId, LicenseReportScope licenseReportScope) {
        URI objectUri = DefaultUriSchemeUtil.createUri((String)LICENSE_REPORT_TYPE, (String[])UriUtil.buildIdSegments(licenseId, licenseReportScope));
        return objectUri;
    }

    public static URI buildAssetReportUri(URI assetId, LicenseReportScope licenseReportScope) {
        URI objectUri = DefaultUriSchemeUtil.createUri((String)ASSET_REPORT_TYPE, (String[])UriUtil.buildIdSegments(assetId, licenseReportScope));
        return objectUri;
    }

    public static URI buildLicensingDataDumpReportUri(LicenseReportScope licenseReportScope) {
        return DefaultUriSchemeUtil.createUri((String)LICENSING_DATA_DUMP_REPORT_TYPE, (String[])UriUtil.buildIdSegments("", licenseReportScope));
    }

    public static void validateLicenseUri(URI uri) {
        UriUtil.validateUri(uri, LICENSE_TYPE);
    }

    public static void validateProductUri(URI uri) {
        UriUtil.validateUri(uri, PRODUCT_TYPE);
    }

    public static void validateAssetUri(URI uri) {
        UriUtil.validateUri(uri, ASSET_TYPE);
    }

    public static void validateProductReportUri(URI uri) {
        UriUtil.validateUri(uri, PRODUCT_REPORT_TYPE);
    }

    public static void validateUri(URI uri, String type2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{uri, type2});
        UriUtil.validateUris(new URI[]{uri}, type2);
    }

    public static void validateUris(URI[] uris, String type2) {
        if (type2 == null) {
            throw new IllegalArgumentException("type should not be null.");
        }
        if (ArrayUtil.isNullOrEmpty((Object[])uris)) {
            return;
        }
        for (URI uri : uris) {
            if (type2.equals(DefaultUriSchemeUtil.getType((URI)uri))) continue;
            String errorMessage = String.format("Wrong type for URI [%1$S]. Expected type [%2$S]", uri, type2);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void validateLicenseUris(URI[] uris) {
        UriUtil.validateUris(uris, LICENSE_TYPE);
    }

    public static void validateProductUris(URI[] uris) {
        UriUtil.validateUris(uris, PRODUCT_TYPE);
    }

    public static void validateAssetUris(URI[] uris) {
        UriUtil.validateUris(uris, ASSET_TYPE);
    }

    public static void validateProductReportUris(URI[] uris) {
        UriUtil.validateUris(uris, PRODUCT_REPORT_TYPE);
    }

    public static boolean isLicenseUri(URI uri) {
        return UriUtil.isUriOfType(uri, LICENSE_TYPE);
    }

    public static boolean isProductUri(URI uri) {
        return UriUtil.isUriOfType(uri, PRODUCT_TYPE);
    }

    public static boolean isAssetUri(URI uri) {
        return UriUtil.isUriOfType(uri, ASSET_TYPE);
    }

    public static boolean isProductReportUri(URI uri) {
        return UriUtil.isUriOfType(uri, PRODUCT_REPORT_TYPE);
    }

    public static boolean isUriOfType(URI uri, String type2) {
        String uriType = DefaultUriSchemeUtil.getType((URI)uri);
        return type2.equals(uriType);
    }

    private static URI buildScopeUri(String uriType, URI id, LicenseScope scope) {
        return UriUtil.buildScopeUri(uriType, id.toString(), scope);
    }

    private static String[] buildIdSegments(String id, LicenseReportScope licenseReportScope) {
        return new String[]{id, licenseReportScope.getLicenseScope().getId(), Long.toString(licenseReportScope.getStartDate().getTime()), Long.toString(licenseReportScope.getEndDate().getTime())};
    }

    private static String[] buildIdSegments(URI uri, LicenseReportScope licenseReportScope) {
        return UriUtil.buildIdSegments(UriUtil.getEncodedId(uri.toString()), licenseReportScope);
    }

    private static URI buildScopeUri(String uriType, String id, LicenseScope scope) {
        String encodedId = UriUtil.getEncodedId(id);
        String[] idSegments = new String[]{encodedId, scope.getId()};
        return DefaultUriSchemeUtil.createUri((String)uriType, (String[])idSegments);
    }

    private static String getEncodedId(String id) {
        String idEncoded;
        try {
            idEncoded = UriUtils.encodeScheme((String)id, (String)CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return idEncoded;
    }

    private static String getUriValueSegment(URI uri, int index) {
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)uri);
        return segments.length > index ? segments[index] : "";
    }
}

