/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;

public class FeatureUtil {
    private static final char FEATURE_ID_DELIM = ':';
    private static final char FEATURE_LOCALIZATION_TOKEN_DELIM = '.';
    private static final String VC_FEATURE_LOCALIZATION_KEY_FORMAT = "com.vmware.vim.license.Feature.%s.summary";
    private static final String LS_FEATURE_LOCALIZATION_KEY_FORMAT = "%s";
    private static final String[] FEATURE_LOCALIZATION_KEY_FORMATS = new String[]{"%s", "com.vmware.vim.license.Feature.%s.summary"};

    public static Feature createFeature(String id) {
        Feature feature = new Feature();
        feature.setId(id);
        return feature;
    }

    public static Feature[] createFeatures(com.vmware.vim.binding.cis.license.Feature[] serviceFeatures) {
        if (ArrayUtil.isNullOrEmpty((Object[])serviceFeatures)) {
            return new Feature[0];
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (com.vmware.vim.binding.cis.license.Feature serviceFeature : serviceFeatures) {
            Feature feature = FeatureUtil.createFeature(serviceFeature.getId());
            features.add(feature);
        }
        return features.toArray(new Feature[features.size()]);
    }

    public static String getFeatureFormattedId(String featureId) {
        if (featureId == null) {
            return null;
        }
        String featureIdLocalizationToken = FeatureUtil.getFeatureIdLocalizationToken(featureId);
        for (String featureLocalizationKeyFormat : FEATURE_LOCALIZATION_KEY_FORMATS) {
            String featureLocalizationKey = String.format(featureLocalizationKeyFormat, featureIdLocalizationToken);
            String featureFormattedId = ManagementUtil.getCatalogLocalizedString(featureLocalizationKey);
            if (featureFormattedId == null) continue;
            return featureFormattedId;
        }
        return featureId;
    }

    private static String getFeatureIdLocalizationToken(String featureId) {
        return featureId.replace(':', '.');
    }
}

