/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.ds.SubscriptionEntitlementAccount;
import com.vmware.license.client.cis.management.ds.SubscriptionInfo;
import com.vmware.license.client.cis.management.ds.SubscriptionLicenseInfo;
import com.vmware.license.client.cis.management.ds.SubscriptionService;
import com.vmware.license.client.cis.management.ds.SubscriptionServiceStatus;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.FeatureUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.SubscriptionLicensingUtil;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareFormattedContractDetails;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareFormattedCustomLabel;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareFormattedOrderDetails;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSerialKeyInfo;
import com.vmware.license.client.cis.util.DateUtil;
import com.vmware.license.myvmware.client.sync.MyVMwareUtil;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagementObjectsFormatterImpl
implements ManagementObjectsFormatter {
    private static final int FAILED_NUMBER_PARSE_ERROR_CODE = -1;
    private static final String SUBSCRIPTION_METADATA_PROP_STATUS = "status";
    private static final String SUBSCRIPTION_METADATA_PROP_SUBSCRIPTION_TERM = "subscriptionTerm";
    private static final String SUBSCRIPTION_METADATA_PROP_SUBSCRIPTION_EXP_DATE = "subscriptionExpDate";
    private static final String SUBSCRIPTION_METADATA_PROP_PRODUCT_FAMILY_DESC = "productFamilyDescription";
    private static final String SUBSCRIPTION_METADATA_PROP_BASE_SKU_DESC = "baseSkuDesc";
    private static final long MS_IN_DAY = 86400000L;
    private final Log _logger = LogFactory.getLog(ManagementObjectsFormatterImpl.class);

    @Override
    public void formatLicenses(License[] licenses) {
        this.formatLicenses(licenses, true);
    }

    @Override
    public void formatLicenses(License[] licenses, boolean stripMyVMwarePlainData) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenses)) {
            return;
        }
        for (License license : licenses) {
            this.formatLicense(license, stripMyVMwarePlainData);
        }
    }

    @Override
    public void formatProductAggregations(ProductAggregation[] productAggregations) {
        if (ArrayUtil.isNullOrEmpty((Object[])productAggregations)) {
            return;
        }
        for (ProductAggregation productAggregation : productAggregations) {
            License[] licenses = productAggregation.getLicenses();
            boolean isSubscriptionProduct = ArrayUtil.isNullOrEmpty((Object[])licenses) ? false : SubscriptionLicensingUtil.isSubscriptionLicense(licenses[0]);
            this.formatProduct(productAggregation.getProduct(), isSubscriptionProduct);
            this.formatLicenses(licenses);
        }
    }

    @Override
    public void formatAssets(Asset[] assets) {
        if (ArrayUtil.isNullOrEmpty((Object[])assets)) {
            return;
        }
        for (Asset asset : assets) {
            this.formatFeatures(asset.getFeaturesInUse());
            this.formatLicense(asset.getEvaluationLicense());
            this.formatAssetLicense(asset);
            this.formatAssetProductName(asset);
            this.formatAssetCostUnits(asset);
        }
    }

    @Override
    public void formatSubscriptionInfos(SubscriptionInfo[] subscriptionInfos) {
        if (ArrayUtil.isNullOrEmpty((Object[])subscriptionInfos)) {
            return;
        }
        for (SubscriptionInfo subscriptionInfo : subscriptionInfos) {
            this.formatSubscriptionEntitlementAccount(subscriptionInfo.entitlementAccount);
            this.formatSubscriptionService(subscriptionInfo.service);
        }
    }

    private void formatLicense(License license) {
        this.formatLicense(license, true);
    }

    private void formatLicense(License license, boolean stripMyVMwarePlainData) {
        if (license == null) {
            return;
        }
        if (license.getIsEvaluation()) {
            license.setName(ManagementObjectsFormatterImpl.getEvaluationLicenseName());
        }
        String formattedExpirationDate = LicenseUtil.getLicenseFormattedExpirationDate(license.getExpirationDate(), license.getExpirationTime());
        license.setFormattedExpirationDate(formattedExpirationDate);
        this.formatLicenseProductRestrictions(license);
        this.formatSubscriptionLicenseInfo(license.getSubscriptionInfo());
        this.formatMyVMwareLicenseInfo(license.getMyVMwareInfo(), stripMyVMwarePlainData);
    }

    private void formatLicenseProductRestrictions(License license) {
        ProductRestriction[] productRestrictions = license.getProductRestrictions();
        if (ArrayUtil.isNullOrEmpty((Object[])productRestrictions)) {
            return;
        }
        boolean isSubscriptionLicense = SubscriptionLicensingUtil.isSubscriptionLicense(license);
        for (ProductRestriction productRestriction : productRestrictions) {
            this.formatProduct(productRestriction.getProduct(), isSubscriptionLicense);
            Collection<ProductCapability> productCapabilities = productRestriction.getVersionToProductCapability().values();
            for (ProductCapability productCapability : productCapabilities) {
                productCapability.setProperties(null);
                this.formatFeatures(productCapability.getFeatures());
            }
        }
    }

    private void formatProduct(Product product, boolean isSubscriptionProduct) {
        String productName = product.getName();
        CostUnit[] productCostUnits = product.getCostUnits();
        String resultProductFormattedName = null;
        CostUnit[] resultProductCostUnits = null;
        if (isSubscriptionProduct) {
            resultProductFormattedName = productName;
            resultProductCostUnits = this.filterSubscriptionCostUnits(productCostUnits);
        } else {
            resultProductCostUnits = productCostUnits;
            resultProductFormattedName = ProductUtil.getFormattedName(productName, resultProductCostUnits);
        }
        CostUnitUtil.formatCostUnits(resultProductCostUnits);
        product.setFormattedName(resultProductFormattedName);
        product.setCostUnits(resultProductCostUnits);
    }

    private void formatFeatures(Feature[] features) {
        if (ArrayUtil.isNullOrEmpty((Object[])features)) {
            return;
        }
        for (Feature feature : features) {
            if (feature == null || feature.getId() == null) continue;
            String formattedId = FeatureUtil.getFeatureFormattedId(feature.getId());
            feature.setFormattedId(formattedId);
        }
    }

    private void formatSubscriptionLicenseInfo(SubscriptionLicenseInfo subscriptionInfo) {
        if (subscriptionInfo == null) {
            return;
        }
        this.formatSubscriptionEntitlementAccount(subscriptionInfo.getEntitlementAccount());
        this.formatSubscriptionService(subscriptionInfo.getService());
        subscriptionInfo.setFormattedUserName(subscriptionInfo.getUserName());
    }

    private void formatSubscriptionEntitlementAccount(SubscriptionEntitlementAccount entitlementAccount) {
        if (entitlementAccount == null) {
            return;
        }
        entitlementAccount.setFormattedName(entitlementAccount.getName());
        entitlementAccount.setFormattedNumber(entitlementAccount.getNumber());
    }

    private void formatSubscriptionService(SubscriptionService service) {
        if (service == null) {
            return;
        }
        service.setFormattedServiceId(service.getServiceId());
        SubscriptionServiceProperties subscriptionProperties = this.extractSubscriptionServiceProperties(service.getProperties());
        Calendar subscriptionTermEndCalendar = this.parseIsoDateAsCalendar(subscriptionProperties.subscriptionExpDate);
        String subscriptionRemainingTerm = this.getFormattedSubscriptionRemainingTerm(subscriptionTermEndCalendar);
        Calendar subscriptionTermStartCalendar = this.getFormattedSubscriptionTermStart(subscriptionTermEndCalendar, subscriptionProperties.subscriptionTerm);
        service.setFormattedProductFamilyDescription(subscriptionProperties.productFamilyDescription);
        service.setFormattedRemainingTerm(subscriptionRemainingTerm);
        service.setStatus(this.extractServiceStatus(subscriptionProperties.status));
        service.setFormattedStatus(subscriptionProperties.status);
        service.setTermEnd(subscriptionTermEndCalendar.getTime());
        service.setTermStart(subscriptionTermStartCalendar.getTime());
        service.setFormattedBaseSkuDescription(subscriptionProperties.baseSkuDescription);
    }

    private SubscriptionServiceProperties extractSubscriptionServiceProperties(KeyAnyValue[] subscriptionProperties) {
        SubscriptionServiceProperties resultProperties = new SubscriptionServiceProperties();
        for (KeyAnyValue keyAnyValue : subscriptionProperties) {
            if (SUBSCRIPTION_METADATA_PROP_STATUS.equals(keyAnyValue.getKey())) {
                resultProperties.status = (String)keyAnyValue.getValue();
                continue;
            }
            if (SUBSCRIPTION_METADATA_PROP_SUBSCRIPTION_TERM.equals(keyAnyValue.getKey())) {
                resultProperties.subscriptionTerm = (String)keyAnyValue.getValue();
                continue;
            }
            if (SUBSCRIPTION_METADATA_PROP_SUBSCRIPTION_EXP_DATE.equals(keyAnyValue.getKey())) {
                resultProperties.subscriptionExpDate = (String)keyAnyValue.getValue();
                continue;
            }
            if (SUBSCRIPTION_METADATA_PROP_PRODUCT_FAMILY_DESC.equals(keyAnyValue.getKey())) {
                resultProperties.productFamilyDescription = (String)keyAnyValue.getValue();
                continue;
            }
            if (!SUBSCRIPTION_METADATA_PROP_BASE_SKU_DESC.equals(keyAnyValue.getKey())) continue;
            resultProperties.baseSkuDescription = (String)keyAnyValue.getValue();
        }
        return resultProperties;
    }

    private Calendar getFormattedSubscriptionTermStart(Calendar termEnd, String subscriptionTerm) {
        int subscriptionTermInMonths;
        if (termEnd == null) {
            return null;
        }
        try {
            subscriptionTermInMonths = Integer.parseInt(subscriptionTerm);
        }
        catch (NumberFormatException e) {
            this._logger.warn((Object)("Could not parse subscription term to int: " + subscriptionTerm), (Throwable)e);
            return null;
        }
        if (subscriptionTermInMonths < 0) {
            this._logger.warn((Object)("Subscription term is negative: " + subscriptionTerm));
            return null;
        }
        GregorianCalendar termStart = new GregorianCalendar();
        termStart.setTime(termEnd.getTime());
        ((Calendar)termStart).roll(1, -subscriptionTermInMonths / 12);
        ((Calendar)termStart).roll(2, -subscriptionTermInMonths % 12);
        return termStart;
    }

    private String getFormattedSubscriptionRemainingTerm(Calendar termEnd) {
        if (termEnd == null) {
            return null;
        }
        long reamainingTermInMs = termEnd.getTimeInMillis() - System.currentTimeMillis();
        return "" + reamainingTermInMs / 86400000L + " days";
    }

    private SubscriptionServiceStatus extractServiceStatus(String status) {
        if (status == null) {
            return SubscriptionServiceStatus.UNKNOWN;
        }
        for (SubscriptionServiceStatus subscriptionServiceStatus : SubscriptionServiceStatus.values()) {
            if (!status.equals(subscriptionServiceStatus.toString())) continue;
            return subscriptionServiceStatus;
        }
        return SubscriptionServiceStatus.UNKNOWN;
    }

    private void formatMyVMwareLicenseInfo(MyVMwareLicenseInfo myVMwareLicenseInfo, boolean stripMyVMwarePlainData) {
        if (myVMwareLicenseInfo == null) {
            return;
        }
        MyVMwareSerialKeyInfo[] myVMwareSerialKeysInfo = myVMwareLicenseInfo.getSerialKeysInfo();
        if (myVMwareSerialKeysInfo == null) {
            return;
        }
        for (MyVMwareSerialKeyInfo myVMwareSerialKeyInfo : myVMwareSerialKeysInfo) {
            this.formatMyVMwareSerialKeyInfo(myVMwareSerialKeyInfo, stripMyVMwarePlainData);
        }
    }

    private void formatMyVMwareSerialKeyInfo(MyVMwareSerialKeyInfo myVMwareSerialKeyInfo, boolean stripMyVMwarePlainData) {
        if (myVMwareSerialKeyInfo == null) {
            return;
        }
        if (myVMwareSerialKeyInfo.getData() == null || myVMwareSerialKeyInfo.getVersion() == null) {
            return;
        }
        LicenseKeyDetails licenseKeyDetails = LicenseKeyDetailsDecoder.decodeLicenseKeyDetails(myVMwareSerialKeyInfo.getData(), myVMwareSerialKeyInfo.getVersion());
        if (licenseKeyDetails == null) {
            this._logger.warn((Object)"Unable to decode license metadata.");
            return;
        }
        myVMwareSerialKeyInfo.setHasActiveSupport(licenseKeyDetails.hasActiveSupport);
        myVMwareSerialKeyInfo.setFormattedAccountName(this.getFormattedAccountName(licenseKeyDetails.accountName, licenseKeyDetails.accountNumber));
        myVMwareSerialKeyInfo.setFormattedNotes(licenseKeyDetails.licenseKeyNotes);
        myVMwareSerialKeyInfo.setFormattedCustomLabels(this.getFormattedCustomLabels(licenseKeyDetails.customLabels));
        myVMwareSerialKeyInfo.setFormattedFolderLocation(licenseKeyDetails.folderLocation);
        myVMwareSerialKeyInfo.setFormattedOrdersDetails(this.getFormattedOrdersDetails(licenseKeyDetails.ordersDetails));
        myVMwareSerialKeyInfo.setFormattedContractsDetails(this.getMyVMwareFormattedContractsDetails(licenseKeyDetails.contractsDetails));
        if (stripMyVMwarePlainData) {
            myVMwareSerialKeyInfo.setVersion(null);
            myVMwareSerialKeyInfo.setData(null);
        }
    }

    private String getFormattedAccountName(String accountName, String accountNumber) {
        if (StringUtil.isNullOrEmpty((String)accountName)) {
            return accountNumber;
        }
        if (StringUtil.isNullOrEmpty((String)accountNumber)) {
            return accountName;
        }
        return accountNumber + " - " + accountName;
    }

    private MyVMwareFormattedCustomLabel[] getFormattedCustomLabels(KeyAnyValue[] customLabels) {
        if (ArrayUtil.isNullOrEmpty((Object[])customLabels)) {
            return new MyVMwareFormattedCustomLabel[0];
        }
        MyVMwareFormattedCustomLabel[] resultFormattedCustomLabels = new MyVMwareFormattedCustomLabel[customLabels.length];
        for (int i = 0; i < resultFormattedCustomLabels.length; ++i) {
            resultFormattedCustomLabels[i] = this.buildMyVMwareFormattedCustomLabel(customLabels[i]);
        }
        return resultFormattedCustomLabels;
    }

    private MyVMwareFormattedOrderDetails[] getFormattedOrdersDetails(OrderDetails[] ordersDetails) {
        if (ArrayUtil.isNullOrEmpty((Object[])ordersDetails)) {
            return new MyVMwareFormattedOrderDetails[0];
        }
        MyVMwareFormattedOrderDetails[] resultOrdersDetails = new MyVMwareFormattedOrderDetails[ordersDetails.length];
        for (int i = 0; i < resultOrdersDetails.length; ++i) {
            resultOrdersDetails[i] = this.buildMyVMwareFormattedOrderDetails(ordersDetails[i]);
        }
        return resultOrdersDetails;
    }

    private MyVMwareFormattedContractDetails[] getMyVMwareFormattedContractsDetails(ContractDetails[] contractsDetails) {
        if (ArrayUtil.isNullOrEmpty((Object[])contractsDetails)) {
            return new MyVMwareFormattedContractDetails[0];
        }
        MyVMwareFormattedContractDetails[] resultContractsDetails = new MyVMwareFormattedContractDetails[contractsDetails.length];
        for (int i = 0; i < resultContractsDetails.length; ++i) {
            resultContractsDetails[i] = this.buildMyVMwareFormattedContractDetails(contractsDetails[i]);
        }
        return resultContractsDetails;
    }

    private MyVMwareFormattedCustomLabel buildMyVMwareFormattedCustomLabel(KeyAnyValue serviceCustomLabel) {
        MyVMwareFormattedCustomLabel result = new MyVMwareFormattedCustomLabel();
        String key = serviceCustomLabel.getKey();
        Object value = serviceCustomLabel.getValue();
        String formattedKey = key;
        String formattedValue = null;
        String formattedKeyValue = key;
        if (value != null) {
            formattedValue = value.toString();
            formattedKeyValue = formattedKeyValue + ": " + value;
        }
        result.setKey(formattedKey);
        result.setValue(formattedValue);
        result.setKeyValue(formattedKeyValue);
        return result;
    }

    private MyVMwareFormattedOrderDetails buildMyVMwareFormattedOrderDetails(OrderDetails orderDetails) {
        MyVMwareFormattedOrderDetails result = new MyVMwareFormattedOrderDetails();
        Date formattedDate = DateUtil.getDate(orderDetails.date);
        String formattedQuantity = this.getFormattedLongValue(orderDetails.quantity);
        result.setNumber(orderDetails.number);
        result.setDate(formattedDate);
        result.setQuantity(formattedQuantity);
        result.setPoNumber(orderDetails.poNumber);
        return result;
    }

    private MyVMwareFormattedContractDetails buildMyVMwareFormattedContractDetails(ContractDetails contractDetails) {
        MyVMwareFormattedContractDetails result = new MyVMwareFormattedContractDetails();
        Date formattedStartDate = DateUtil.getDate(contractDetails.startDate);
        Date formattedEndDate = DateUtil.getDate(contractDetails.endDate);
        result.setSupportLevel(contractDetails.supportLevel);
        result.setStartDate(formattedStartDate);
        result.setEndDate(formattedEndDate);
        result.setNumber(contractDetails.number);
        result.setElaFlag(contractDetails.elaFlag);
        return result;
    }

    private String getFormattedLongValue(long value) {
        if (value == -1L) {
            return null;
        }
        return Long.toString(value);
    }

    private void formatAssetLicense(Asset asset) {
        License assetLicense = asset.getLicense();
        this.formatLicense(assetLicense);
        AssetLicenseState assetLicenseState = asset.getLicenseState();
        if (AssetLicenseState.EVALUATION.equals((Object)assetLicenseState)) {
            assetLicense.setName(ManagementObjectsFormatterImpl.getEvaluationLicenseName());
        } else if (AssetLicenseState.UNLICENSED.equals((Object)assetLicenseState)) {
            License license = new License();
            license.setName(ManagementUtil.getLocalizedString("asset.unlicensed.license.name"));
            asset.setLicense(license);
        }
    }

    private void formatAssetProductName(Asset asset) {
        AssetLicenseState assetLicenseState = asset.getLicenseState();
        String formattedProductName = null;
        if (AssetLicenseState.LICENSED.equals((Object)assetLicenseState)) {
            ProductRestriction assetProductRestriction = AssetUtil.getAssetProductRestriction(asset);
            formattedProductName = assetProductRestriction.getProduct().getFormattedName();
        } else {
            formattedProductName = AssetLicenseState.EVALUATION.equals((Object)assetLicenseState) ? ManagementUtil.getLocalizedString("product.evaluation.name") : ManagementUtil.getLocalizedString("asset.unlicensed.product.name");
        }
        asset.setFormattedProductName(formattedProductName);
    }

    private void formatAssetCostUnits(Asset asset) {
        CostUnit[] resultCostUnitsUsage = null;
        resultCostUnitsUsage = AssetLicenseState.UNLICENSED.equals((Object)asset.getLicenseState()) ? new CostUnit[]{} : (SubscriptionLicensingUtil.isSubscriptionLicense(asset.getLicense()) ? this.filterSubscriptionCostUnits(asset.getCostUnitUsage()) : this.getAssetLicenseCostUnitsUsage(asset));
        CostUnitUtil.formatCostUnits(resultCostUnitsUsage);
        asset.setCostUnitUsage(resultCostUnitsUsage);
    }

    private static String getEvaluationLicenseName() {
        return ManagementUtil.getLocalizedString("license.evaluation.name");
    }

    private CostUnit[] filterSubscriptionCostUnits(CostUnit[] costUnits) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnits)) {
            return costUnits;
        }
        ArrayList<CostUnit> resultCostUnits = new ArrayList<CostUnit>();
        for (CostUnit costUnit : costUnits) {
            String costUnitId = costUnit.getId();
            if (!costUnitId.contains("vm.") && !costUnitId.contains("address.")) continue;
            resultCostUnits.add(costUnit);
        }
        return resultCostUnits.toArray(new CostUnit[resultCostUnits.size()]);
    }

    private CostUnit[] getAssetLicenseCostUnitsUsage(Asset asset) {
        ArrayList<CostUnit> costUnitsUsages = new ArrayList<CostUnit>();
        ProductRestriction assetProductRestriction = AssetUtil.getAssetProductRestriction(asset);
        Set<String> licensedCostUnitsIds = CostUnitUtil.getCostUnitIds(assetProductRestriction.getProduct().getCostUnits());
        for (CostUnit costUnitUsage : asset.getCostUnitUsage()) {
            if (!licensedCostUnitsIds.contains(costUnitUsage.getId())) continue;
            costUnitsUsages.add(costUnitUsage);
        }
        CostUnit[] resultCostUnitsUsages = costUnitsUsages.toArray(new CostUnit[costUnitsUsages.size()]);
        return resultCostUnitsUsages;
    }

    private Calendar parseIsoDateAsCalendar(String dateStr) {
        if (dateStr != null) {
            dateStr = dateStr.trim();
        }
        if (StringUtil.isNullOrEmpty((String)dateStr)) {
            return null;
        }
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date parsedDate = isoDateFormat.parse(dateStr);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(parsedDate);
            return calendar;
        }
        catch (ParseException e) {
            this._logger.warn((Object)("Failed to parse date: " + dateStr), (Throwable)e);
            return null;
        }
    }

    private static class SubscriptionServiceProperties {
        String status;
        String subscriptionTerm;
        String subscriptionExpDate;
        String productFamilyDescription;
        String baseSkuDescription;

        private SubscriptionServiceProperties() {
        }
    }

    private static class ContractDetails {
        public String number;
        public Calendar startDate;
        public Calendar endDate;
        public String supportLevel;
        public String elaFlag;

        private ContractDetails() {
        }
    }

    private static class OrderDetails {
        public String number;
        public Calendar date;
        public long quantity;
        private String poNumber;

        private OrderDetails() {
        }
    }

    private static class LicenseKeyDetails {
        public String accountName;
        public String accountNumber;
        public String folderLocation;
        public String licenseKeyNotes;
        public KeyAnyValue[] customLabels;
        public OrderDetails[] ordersDetails;
        public ContractDetails[] contractsDetails;
        public boolean hasActiveSupport;

        private LicenseKeyDetails() {
        }
    }

    private static class LicenseKeyDetailsDecoder {
        private static final String LICENSE_METADATA_PROP_NOTES = "licenseKeyNotes";
        private static final String LICENSE_METADATA_PROP_CUSTOM_LABELS = "customLabels";
        private static final String LICENSE_METADATA_PROP_ACCOUNT_NAME = "accountName";
        private static final String LICENSE_METADATA_PROP_ACCOUNT_NUMBER = "accountNumber";
        private static final String LICENSE_METADATA_RPOP_FOLDER_LOCATION = "folderLocation";
        private static final String LICENSE_METADATA_PROP_ORDER_DETAILS = "orderDetails";
        private static final String LICENSE_METADATA_PROP_ORDER_NUMBER = "number";
        private static final String LICENSE_METADATA_PROP_ORDER_QUANTITY = "orderQuantity";
        private static final String LICENSE_METADATA_PROP_ORDER_DATE = "orderDate";
        private static final String LICENSE_METADATA_PROP_ORDER_PO_NUMBER = "poNumber";
        private static final String LICENSE_METADATA_PROP_CONTRACT_DETAILS = "contractDetails";
        private static final String LICENSE_METADATA_PROP_CONTRACT_NUMBER = "number";
        private static final String LICENSE_METADATA_PROP_CONTRACT_COVARAGE_START_DATE = "licenseCoverageStartDate";
        private static final String LICENSE_METADATA_PROP_CONTRACT_COVARAGE_END_DATE = "licenseCoverageEndDate";
        private static final String LICENSE_METADATA_PROP_CONTRACT_SUPPORT_LEVEL = "supportLevel";
        private static final String LICENSE_METADATA_PROP_CONTRACT_ELA_FLAG = "ELAFlag";

        private LicenseKeyDetailsDecoder() {
        }

        private static LicenseKeyDetails decodeLicenseKeyDetails(byte[] data2, String version) {
            Object[] myVMwareProperties = MyVMwareUtil.decodeLicenseMetadata((byte[])data2, (String)version);
            if (ArrayUtil.isNullOrEmpty((Object[])myVMwareProperties)) {
                return null;
            }
            LicenseKeyDetails result = new LicenseKeyDetails();
            result.hasActiveSupport = MyVMwareUtil.isLicenseWithActiveSupport((KeyAnyValue[])myVMwareProperties);
            ArrayList<OrderDetails> ordersDetails = new ArrayList<OrderDetails>();
            ArrayList<ContractDetails> contractsDetails = new ArrayList<ContractDetails>();
            for (Object myVMwareProperty : myVMwareProperties) {
                String propertyKey = myVMwareProperty.getKey();
                if (LICENSE_METADATA_PROP_ACCOUNT_NAME.equals(propertyKey)) {
                    result.accountName = (String)myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ACCOUNT_NUMBER.equals(propertyKey)) {
                    result.accountNumber = (String)myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_RPOP_FOLDER_LOCATION.equals(propertyKey)) {
                    result.folderLocation = (String)myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_NOTES.equals(propertyKey)) {
                    result.licenseKeyNotes = (String)myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CUSTOM_LABELS.equals(propertyKey)) {
                    result.customLabels = (KeyAnyValue[])myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_DETAILS.equals(propertyKey)) {
                    KeyAnyValue[] orderProperties = (KeyAnyValue[])myVMwareProperty.getValue();
                    OrderDetails orderDetails = LicenseKeyDetailsDecoder.buildUiOrderDetails(orderProperties);
                    ordersDetails.add(orderDetails);
                    continue;
                }
                if (!LICENSE_METADATA_PROP_CONTRACT_DETAILS.equals(propertyKey)) continue;
                KeyAnyValue[] contractProperties = (KeyAnyValue[])myVMwareProperty.getValue();
                ContractDetails contractDetails = LicenseKeyDetailsDecoder.buildUiContractDetails(contractProperties);
                contractsDetails.add(contractDetails);
            }
            result.ordersDetails = ordersDetails.toArray(new OrderDetails[ordersDetails.size()]);
            result.contractsDetails = contractsDetails.toArray(new ContractDetails[contractsDetails.size()]);
            return result;
        }

        private static OrderDetails buildUiOrderDetails(KeyAnyValue[] serviceOrderProperties) {
            OrderDetails orderDetails = new OrderDetails();
            for (KeyAnyValue orderProperty : serviceOrderProperties) {
                String propKey = orderProperty.getKey();
                if ("number".equals(propKey)) {
                    orderDetails.number = (String)orderProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_QUANTITY.equals(propKey)) {
                    orderDetails.quantity = (Long)orderProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_DATE.equals(propKey)) {
                    orderDetails.date = (Calendar)orderProperty.getValue();
                    continue;
                }
                if (!LICENSE_METADATA_PROP_ORDER_PO_NUMBER.equals(propKey)) continue;
                orderDetails.poNumber = (String)orderProperty.getValue();
            }
            return orderDetails;
        }

        private static ContractDetails buildUiContractDetails(KeyAnyValue[] serviceContractProperties) {
            ContractDetails contractDetails = new ContractDetails();
            for (KeyAnyValue contractProperty : serviceContractProperties) {
                String propKey = contractProperty.getKey();
                if ("number".equals(propKey)) {
                    contractDetails.number = (String)contractProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_COVARAGE_START_DATE.equals(propKey)) {
                    contractDetails.startDate = (Calendar)contractProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_COVARAGE_END_DATE.equals(propKey)) {
                    contractDetails.endDate = (Calendar)contractProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_SUPPORT_LEVEL.equals(propKey)) {
                    contractDetails.supportLevel = (String)contractProperty.getValue();
                    continue;
                }
                if (!LICENSE_METADATA_PROP_CONTRACT_ELA_FLAG.equals(propKey)) continue;
                contractDetails.elaFlag = (String)contractProperty.getValue();
            }
            return contractDetails;
        }
    }
}

