/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.AssetUpdateNewLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.ds.LicenseType;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.BaseLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.SubscriptionLicensingUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.ProductUtilization;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpec;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpecByLicenseState;
import com.vmware.vim.binding.cis.license.management.LicenseAddSpec;
import com.vmware.vim.binding.cis.license.management.LicenseSearchSpec;
import com.vmware.vim.binding.cis.license.management.ProductSearchSpec;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByLicenseIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByLicenseStateImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByProductFamilyNamesImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByProductIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetUpdateLicenseSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.LicenseSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.LicenseSearchSpecByProductIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.ProductSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.ProductSearchSpecByLicenseIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.SerialKeyLicenseAddSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.SerialKeyLicenseUpdateSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.SubscriptionLicenseAddSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.SubscriptionLicensePreviewSpecImpl;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManagementEditorImpl
implements ManagementEditor {
    private static final int SERVICE_ASSETS_PAGE_SIZE = 200;
    private final LicenseClientProvider _licenseClientProvider;

    private static LicenseUtilization[] filterLicenseUtilizationsBySearchProperties(LicenseUtilization[] licenseUtilizations, LicenseSearchProperties properties) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseUtilizations) || properties == null) {
            return licenseUtilizations;
        }
        LicenseType expectedLicenseType = properties.getLicenseType();
        Boolean expectedLicenesAssigned = properties.isLicenseAssigned();
        if (expectedLicenseType == null && expectedLicenesAssigned == null) {
            return licenseUtilizations;
        }
        ArrayList<LicenseUtilization> resultLicenseUtilizations = new ArrayList<LicenseUtilization>();
        for (LicenseUtilization licenseUtilization : licenseUtilizations) {
            boolean isLicenseAssigned;
            LicenseType licenseType;
            if (expectedLicenseType != null && !expectedLicenseType.equals((Object)(licenseType = ManagementEditorImpl.getLicenseType(licenseUtilization))) || expectedLicenesAssigned != null && !expectedLicenesAssigned.equals(isLicenseAssigned = licenseUtilization.isIsLicenseAssigned())) continue;
            resultLicenseUtilizations.add(licenseUtilization);
        }
        return resultLicenseUtilizations.toArray(new LicenseUtilization[resultLicenseUtilizations.size()]);
    }

    private static LicenseType getLicenseType(LicenseUtilization licenseUtilization) {
        LicenseType resultLicenseType = null;
        resultLicenseType = SubscriptionLicensingUtil.isSubscriptionLicenseUtilization(licenseUtilization) ? LicenseType.SUBSCRIPTION : LicenseType.SERIAL_KEY;
        return resultLicenseType;
    }

    private static AssetSearchSpec createAssetSearchSpecByProductFamilyNames(AssetSearchProperties properties) {
        AssetSearchSpecByProductFamilyNamesImpl searchSpec = new AssetSearchSpecByProductFamilyNamesImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)searchSpec, properties);
        String productFamilyName = ProductUtil.getProductFamilyName(properties.getType());
        if (productFamilyName != null) {
            String[] productFamilyNames = new String[]{productFamilyName};
            searchSpec.setProductFamilyNames(productFamilyNames);
        } else {
            String[] productFamilyNames = new String[]{"VMware ESX Server", "VMware VirtualCenter Server", "VMware VSAN"};
            searchSpec.setProductFamilyNames(productFamilyNames);
            searchSpec.setInverseSearch(Boolean.valueOf(true));
        }
        return searchSpec;
    }

    private static void updateAssetSearchSpecByProperties(AssetSearchSpec assetSearchSpec, AssetSearchProperties properties) {
        String scopeId = properties.getScopeId();
        Integer maxResults = properties.getMaxResultObjects();
        assetSearchSpec.setScopeId(scopeId);
        assetSearchSpec.setMaxResults(maxResults);
    }

    private static AssetSearchSpec createAssetSearchSpecByProductId(String productId, AssetSearchProperties properties) {
        AssetSearchSpecByProductIdImpl searchSpec = new AssetSearchSpecByProductIdImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)searchSpec, properties);
        searchSpec.setProductId(productId);
        return searchSpec;
    }

    private static AssetSearchSpec createAssetSearchSpecByLicenseState(AssetSearchSpecByLicenseState.LicenseState licenseState, AssetSearchProperties properties) {
        AssetSearchSpecByLicenseStateImpl searchSpec = new AssetSearchSpecByLicenseStateImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)searchSpec, properties);
        searchSpec.setLicenseState(licenseState.name());
        return searchSpec;
    }

    private static AssetSearchSpec createAssetSearchSpecByLicenseId(URI licenseId, String productFamilyName, AssetSearchProperties properties) {
        AssetSearchSpecByLicenseIdImpl searchSpec = new AssetSearchSpecByLicenseIdImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)searchSpec, properties);
        searchSpec.setLicenseId(licenseId);
        searchSpec.setProductFamilyName(productFamilyName);
        return searchSpec;
    }

    private static Asset[] filterAssetsByLicenseId(Asset[] assets, URI licenseId) {
        if (ArrayUtil.isNullOrEmpty((Object[])assets)) {
            return new Asset[0];
        }
        ArrayList<Asset> resultAssets = new ArrayList<Asset>();
        for (Asset asset : assets) {
            URI assetLicenseId;
            License assetLicense = asset.getInfo().getLicense();
            if (assetLicense == null || !(assetLicenseId = assetLicense.getId()).equals(licenseId)) continue;
            resultAssets.add(asset);
        }
        return resultAssets.toArray(new Asset[resultAssets.size()]);
    }

    private static ProductAggregation[] createProductAggregations(ProductUtilization[] productUtilizations, LicenseUtilization[] licenseUtilizations, LicenseScope scope) {
        if (ArrayUtil.isNullOrEmpty((Object[])productUtilizations)) {
            return new ProductAggregation[0];
        }
        com.vmware.license.client.cis.management.ds.License[] licenses = LicenseUtil.createLicenses(licenseUtilizations, scope);
        Map<URI, List<com.vmware.license.client.cis.management.ds.License>> licensesByProductUri = ManagementEditorImpl.getLicensesByProductUri(licenses);
        ArrayList<ProductAggregation> productAggregations = new ArrayList<ProductAggregation>();
        for (int i = 0; i < productUtilizations.length; ++i) {
            ProductUtilization productUtilization = productUtilizations[i];
            com.vmware.vim.binding.cis.license.Product cisProduct = productUtilization.getProduct();
            Product product = ProductUtil.createProduct(cisProduct, productUtilization.getCostUnitsUsage(), productUtilization.getCostUnitsLimit(), scope);
            if (product == null) continue;
            ProductAggregation productAggregation = new ProductAggregation();
            productAggregation.setProduct(product);
            List<com.vmware.license.client.cis.management.ds.License> productLicenses = licensesByProductUri.get(product.getUri());
            productAggregation.setLicenses(productLicenses.toArray(new com.vmware.license.client.cis.management.ds.License[productLicenses.size()]));
            productAggregations.add(productAggregation);
        }
        return productAggregations.toArray(new ProductAggregation[productAggregations.size()]);
    }

    private static Map<URI, List<com.vmware.license.client.cis.management.ds.License>> getLicensesByProductUri(com.vmware.license.client.cis.management.ds.License[] licenses) {
        HashMap<URI, List<com.vmware.license.client.cis.management.ds.License>> result = new HashMap<URI, List<com.vmware.license.client.cis.management.ds.License>>();
        for (com.vmware.license.client.cis.management.ds.License license : licenses) {
            for (ProductRestriction productRestriction : license.getProductRestrictions()) {
                URI productUri = productRestriction.getProduct().getUri();
                ArrayList<com.vmware.license.client.cis.management.ds.License> productLicenses = (ArrayList<com.vmware.license.client.cis.management.ds.License>)result.get(productUri);
                if (productLicenses == null) {
                    productLicenses = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
                    result.put(productUri, productLicenses);
                }
                productLicenses.add(license);
            }
        }
        return result;
    }

    private static LicenseAddSpec[] createLicenseAddSpecs(BaseLicenseSpec[] clientSpecs) {
        LicenseAddSpec[] result = new LicenseAddSpec[clientSpecs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new SerialKeyLicenseAddSpecImpl(clientSpecs[i].name, clientSpecs[i].serialKeys);
        }
        return result;
    }

    private static LicenseAddSpec buildSubscriptionLicenseAddSpec(AddSubscriptionLicenseSpec clientSpec) {
        SubscriptionLicenseAddSpecImpl resultSpec = new SubscriptionLicenseAddSpecImpl();
        resultSpec.setUsername(clientSpec.userName);
        resultSpec.setPassword(clientSpec.password);
        resultSpec.setEntitlementAccountNumber(clientSpec.entitlementAccount);
        resultSpec.setSubscriptionServiceId(clientSpec.serviceId);
        resultSpec.setName(clientSpec.licenseName);
        return resultSpec;
    }

    private static LicenseAddSpec buildSubscriptionLicensePreviewSpec(AddSubscriptionLicensePreviewSpec clientSpec) {
        SubscriptionLicensePreviewSpecImpl resultSpec = new SubscriptionLicensePreviewSpecImpl();
        resultSpec.setUsername(clientSpec.userName);
        resultSpec.setPassword(clientSpec.password);
        resultSpec.setName(clientSpec.licenseName);
        return resultSpec;
    }

    private static com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] createServiceLicenseUpdateSpecs(LicenseUpdateSpec[] clientSpecs) {
        com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] result = new com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[clientSpecs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new SerialKeyLicenseUpdateSpecImpl(UriUtil.extractObjectIdAsUri(clientSpecs[i].uri), clientSpecs[i].name, clientSpecs[i].serialKeys);
        }
        return result;
    }

    private static com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] createAssetUpdateLicenseSpecs(AssetUpdateLicenseSpec[] specs) {
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] serviceSpecs = new com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            UriUtil.validateAssetUri(specs[i].getAssetRef());
            URI licenseId = null;
            if (specs[i].getLicenseRef() != null && !specs[i].isPlaceInEvaluation()) {
                UriUtil.validateLicenseUri(specs[i].getLicenseRef());
                licenseId = UriUtil.extractObjectIdAsUri(specs[i].getLicenseRef());
            }
            URI assetId = UriUtil.extractObjectIdAsUri(specs[i].getAssetRef());
            serviceSpecs[i] = new AssetUpdateLicenseSpecImpl(assetId, licenseId, null, specs[i].isPlaceInEvaluation());
        }
        return serviceSpecs;
    }

    private static com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] createAssetUpdateLicenseSpecs(AssetUpdateNewLicenseSpec[] specs) {
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] serviceSpecs = new com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            UriUtil.validateAssetUri(specs[i].assetUri);
            SerialKeyLicenseAddSpecImpl licenseAddSpec = new SerialKeyLicenseAddSpecImpl(specs[i].newLicenseName, specs[i].serialKeys);
            AssetUpdateLicenseSpecImpl serviceSpec = new AssetUpdateLicenseSpecImpl();
            serviceSpec.setLicenseAddSpec((LicenseAddSpec)licenseAddSpec);
            serviceSpec.setAssetId(UriUtil.extractObjectIdAsUri(specs[i].assetUri));
            serviceSpec.setPlaceInEval(false);
            serviceSpecs[i] = serviceSpec;
        }
        return serviceSpecs;
    }

    public ManagementEditorImpl(LicenseClientProvider licenseClientProvider) {
        this._licenseClientProvider = licenseClientProvider;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicenses(URI[] licenseUris, LicenseScope scope) {
        UriUtil.validateLicenseUris(licenseUris);
        URI[] licenseUrisWithoutEvaluationLicense = this.excludeEvaluationLicenseUri(licenseUris);
        LicenseUtilization[] licenseUtilizations = null;
        if (licenseUrisWithoutEvaluationLicense.length > 0) {
            Object[] licenseIds = UriUtil.extractObjectIdsAsUris(licenseUrisWithoutEvaluationLicense);
            LicenseSearchSpecByIdsImpl searchSpec = null;
            if (!ArrayUtil.isNullOrEmpty((Object[])licenseIds)) {
                searchSpec = new LicenseSearchSpecByIdsImpl((URI[])licenseIds);
            }
            licenseUtilizations = this.searchLicenseUtilizations((LicenseSearchSpec)searchSpec, scope);
        }
        ArrayList<com.vmware.license.client.cis.management.ds.License> licensesResult = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
        if (licenseUris.length > licenseUrisWithoutEvaluationLicense.length) {
            licensesResult.add(LicenseUtil.createEvaluationLicense(0L));
        }
        Collections.addAll(licensesResult, LicenseUtil.createLicenses(licenseUtilizations, scope));
        return licensesResult.toArray(new com.vmware.license.client.cis.management.ds.License[0]);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicenses(LicenseScope scope, LicenseSearchProperties properties) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{scope});
        LicenseUtilization[] licenseUtilizations = this.searchLicenseUtilizations(null, scope);
        licenseUtilizations = ManagementEditorImpl.filterLicenseUtilizationsBySearchProperties(licenseUtilizations, properties);
        com.vmware.license.client.cis.management.ds.License[] resultLicenses = LicenseUtil.createLicenses(licenseUtilizations, scope);
        return resultLicenses;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicensesForProduct(URI productUri, LicenseSearchProperties properties) {
        UriUtil.validateProductUri(productUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(productUri);
        String productId = UriUtil.extractObjectIdAsString(productUri);
        LicenseSearchSpecByProductIdImpl searchSpec = new LicenseSearchSpecByProductIdImpl(productId);
        LicenseUtilization[] licenseUtilizations = this.searchLicenseUtilizations((LicenseSearchSpec)searchSpec, scope);
        licenseUtilizations = ManagementEditorImpl.filterLicenseUtilizationsBySearchProperties(licenseUtilizations, properties);
        return LicenseUtil.createLicenses(licenseUtilizations, scope);
    }

    @Override
    public ProductAggregation[] getProductAggregations(URI[] productUris, LicenseScope scope) {
        UriUtil.validateProductUris(productUris);
        ProductSearchSpecByIdsImpl searchSpec = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])productUris)) {
            String[] productIds = UriUtil.extractObjectIdsAsStrings(productUris);
            searchSpec = new ProductSearchSpecByIdsImpl(productIds);
        }
        ProductUtilization[] productUtilizations = this.searchProductUtilizations((ProductSearchSpec)searchSpec, scope);
        LicenseUtilization[] licenseUtilizations = this.searchLicenseUtilizations(null, scope);
        return ManagementEditorImpl.createProductAggregations(productUtilizations, licenseUtilizations, scope);
    }

    @Override
    public ProductAggregation[] getProductAggregationsForLicense(URI licenseUri) {
        UriUtil.validateLicenseUri(licenseUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
        URI licenseId = UriUtil.extractObjectIdAsUri(licenseUri);
        ProductSearchSpecByLicenseIdImpl searchSpec = new ProductSearchSpecByLicenseIdImpl(licenseId);
        ProductUtilization[] productUtilizations = this.searchProductUtilizations((ProductSearchSpec)searchSpec, scope);
        LicenseUtilization[] licenseUtilizations = this.searchLicenseUtilizations(null, scope);
        return ManagementEditorImpl.createProductAggregations(productUtilizations, licenseUtilizations, scope);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssets(URI[] assetUris, LicenseScope scope) {
        UriUtil.validateAssetUris(assetUris);
        Object[] assetIds = UriUtil.extractObjectIdsAsUris(assetUris);
        AssetSearchSpecByIdsImpl searchSpec = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])assetIds)) {
            searchSpec = new AssetSearchSpecByIdsImpl();
            searchSpec.setAssetIds((URI[])assetIds);
        }
        Asset[] assets = this.searchAssets((AssetSearchSpec)searchSpec, scope);
        return this.createAssets(assets, scope);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssets(LicenseScope scope, AssetSearchProperties properties) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{properties});
        ValidationUtil.paramsNotNull((Object[])new Object[]{scope});
        AssetSearchSpec searchSpec = ManagementEditorImpl.createAssetSearchSpecByProductFamilyNames(properties);
        Asset[] serviceAssets = this.searchAssets(searchSpec, scope);
        com.vmware.license.client.cis.management.ds.Asset[] assets = this.createAssets(serviceAssets, scope);
        return assets;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsByLicenseState(AssetSearchProperties properties, AssetSearchSpecByLicenseState.LicenseState licenseState) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseState});
        ValidationUtil.paramsNotNull((Object[])new Object[]{properties});
        AssetSearchSpec searchSpec = ManagementEditorImpl.createAssetSearchSpecByLicenseState(licenseState, properties);
        Asset[] serviceAssets = this.searchAssets(searchSpec, ManagementUtil.SCOPE_CIS_LICENSING);
        com.vmware.license.client.cis.management.ds.Asset[] assets = this.createAssets(serviceAssets, ManagementUtil.SCOPE_CIS_LICENSING);
        return assets;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsForProduct(URI productUri, AssetSearchProperties properties) {
        UriUtil.validateProductUri(productUri);
        ValidationUtil.paramsNotNull((Object[])new Object[]{properties});
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(productUri);
        String productId = UriUtil.extractObjectIdAsString(productUri);
        AssetSearchSpec searchSpec = ManagementEditorImpl.createAssetSearchSpecByProductId(productId, properties);
        Asset[] serviceAssets = this.searchAssets(searchSpec, scope);
        com.vmware.license.client.cis.management.ds.Asset[] assets = this.createAssets(serviceAssets, scope);
        return assets;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsForLicense(URI licenseUri, AssetSearchProperties properties) {
        AssetSearchSpec searchSpec;
        UriUtil.validateLicenseUri(licenseUri);
        ValidationUtil.paramsNotNull((Object[])new Object[]{properties});
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
        URI licenseId = UriUtil.extractObjectIdAsUri(licenseUri);
        Asset[] serviceAssetsForLicense = null;
        String productFamilyName = ProductUtil.getProductFamilyName(properties.getType());
        if (productFamilyName != null) {
            searchSpec = ManagementEditorImpl.createAssetSearchSpecByLicenseId(licenseId, productFamilyName, properties);
            serviceAssetsForLicense = this.searchAssets(searchSpec, scope);
        } else {
            searchSpec = ManagementEditorImpl.createAssetSearchSpecByProductFamilyNames(properties);
            Asset[] serviceAssets = this.searchAssets(searchSpec, scope);
            serviceAssetsForLicense = ManagementEditorImpl.filterAssetsByLicenseId(serviceAssets, licenseId);
        }
        com.vmware.license.client.cis.management.ds.Asset[] assets = this.createAssets(serviceAssetsForLicense, scope);
        return assets;
    }

    @Override
    public URI[] addLicenses(LicenseCreateSpec[] createSpecs) {
        ValidationUtil.paramsNotNull((Object[])((Object[])createSpecs));
        LicenseUiScope licenseUiScope = createSpecs[0].scope;
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        SystemManagementService sms = this.getSystemManagementService(scope);
        LicenseAddSpec[] licenseAddSpecs = ManagementEditorImpl.createLicenseAddSpecs(createSpecs);
        License[] licenses = null;
        try {
            licenses = sms.addLicenses(licenseAddSpecs);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
        return LicenseUtil.getLicenseUris(licenses, scope);
    }

    @Override
    public URI addSubscriptionLicense(AddSubscriptionLicenseSpec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{spec});
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(spec.scope);
        SystemManagementService sms = this.getSystemManagementService(scope);
        LicenseAddSpec licenseAddSpec = ManagementEditorImpl.buildSubscriptionLicenseAddSpec(spec);
        License[] licenses = null;
        try {
            licenses = sms.addLicenses(new LicenseAddSpec[]{licenseAddSpec});
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
        return LicenseUtil.getLicenseUris(licenses, scope)[0];
    }

    @Override
    public void updateLicenses(LicenseUpdateSpec[] updateSpecs) {
        ValidationUtil.paramsNotNull((Object[])((Object[])updateSpecs));
        for (LicenseUpdateSpec updateSpec : updateSpecs) {
            UriUtil.validateLicenseUri(updateSpec.uri);
        }
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(updateSpecs[0].uri);
        SystemManagementService sms = this.getSystemManagementService(scope);
        com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] serviceUpdateSpecs = ManagementEditorImpl.createServiceLicenseUpdateSpecs(updateSpecs);
        try {
            sms.updateLicenses(serviceUpdateSpecs);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    @Override
    public void removeLicenses(URI[] licenseUris) {
        ValidationUtil.paramsNotNull((Object[])licenseUris);
        UriUtil.validateLicenseUris(licenseUris);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUris[0]);
        SystemManagementService sms = this.getSystemManagementService(scope);
        URI[] licenseIds = UriUtil.extractObjectIdsAsUris(licenseUris);
        try {
            sms.removeLicenses(licenseIds);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] previewLicenses(LicensePreviewSpec[] previewSpecs) {
        ValidationUtil.paramsNotNull((Object[])((Object[])previewSpecs));
        LicenseUiScope licenseUiScope = previewSpecs[0].scope;
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        SystemManagementService sms = this.getSystemManagementService(scope);
        LicenseAddSpec[] licenseAddSpecs = ManagementEditorImpl.createLicenseAddSpecs(previewSpecs);
        LicenseInfo[] licenseInfos = sms.previewLicenses(licenseAddSpecs);
        return LicenseUtil.createLicenses(licenseInfos, scope);
    }

    @Override
    public AddSubscriptionLicensePreviewResult previewSubscriptionLicense(AddSubscriptionLicensePreviewSpec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{spec});
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(spec.scope);
        SystemManagementService sms = this.getSystemManagementService(scope);
        LicenseAddSpec licenseAddSpec = ManagementEditorImpl.buildSubscriptionLicensePreviewSpec(spec);
        LicenseInfo[] licenseInfos = sms.previewLicenses(new LicenseAddSpec[]{licenseAddSpec});
        AddSubscriptionLicensePreviewResult result = SubscriptionLicensingUtil.buildAddSubscriptionLicensePreviewResult(licenseInfos);
        return result;
    }

    @Override
    public void updateAssetsLicense(AssetUpdateLicenseSpec[] updateSpecs) {
        ValidationUtil.paramsNotNull((Object[])updateSpecs);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(updateSpecs[0].getAssetRef());
        SystemManagementService sms = this.getSystemManagementService(scope);
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] serviceSpecs = ManagementEditorImpl.createAssetUpdateLicenseSpecs(updateSpecs);
        try {
            sms.updateAssetsLicense(serviceSpecs);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    @Override
    public void updateAssetsWithNewLicense(AssetUpdateNewLicenseSpec[] assetUpdateNewLicenseSpecs) {
        ValidationUtil.paramsNotNull((Object[])assetUpdateNewLicenseSpecs);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUpdateNewLicenseSpecs[0].assetUri);
        SystemManagementService sms = this.getSystemManagementService(scope);
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] serviceSpecs = ManagementEditorImpl.createAssetUpdateLicenseSpecs(assetUpdateNewLicenseSpecs);
        try {
            sms.updateAssetsLicense(serviceSpecs);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    @Override
    public void unregisterAssets(URI[] assetUris) {
        ValidationUtil.paramsNotNull((Object[])assetUris);
        UriUtil.validateAssetUris(assetUris);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUris[0]);
        SystemManagementService sms = this.getSystemManagementService(scope);
        URI[] assetIds = UriUtil.extractObjectIdsAsUris(assetUris);
        try {
            sms.unregisterAssets(assetIds);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    protected Asset[] searchAssets(AssetSearchSpec searchSpec, LicenseScope scope) {
        SystemManagementService sms = this.getSystemManagementService(scope);
        Asset[] serviceAssets = null;
        if (searchSpec == null) {
            try {
                serviceAssets = sms.searchAssets(null);
            }
            catch (MethodFault fault) {
                throw new ManagementException(fault);
            }
        } else {
            serviceAssets = this.searchAssetsInt(searchSpec, sms, 200);
        }
        return serviceAssets;
    }

    Asset[] searchAssetsInt(AssetSearchSpec searchSpec, SystemManagementService sms, int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size cannot be zero or less!");
        }
        Integer maxResults = searchSpec.getMaxResults();
        maxResults = maxResults != null && maxResults > 0 ? maxResults : Integer.MAX_VALUE;
        Integer offset = searchSpec.getOffset();
        offset = offset != null && offset > 0 ? offset : 0;
        ArrayList<Asset> resultAssets = new ArrayList<Asset>();
        boolean hasMoreAssets = true;
        while (hasMoreAssets && resultAssets.size() < maxResults) {
            searchSpec.setMaxResults(Integer.valueOf(pageSize));
            searchSpec.setOffset(offset);
            Asset[] pagedAssets = null;
            try {
                pagedAssets = sms.searchAssets(searchSpec);
            }
            catch (MethodFault fault) {
                throw new ManagementException(fault);
            }
            if (pagedAssets == null) {
                hasMoreAssets = false;
                continue;
            }
            if (pagedAssets.length < pageSize) {
                hasMoreAssets = false;
            }
            if (resultAssets.size() + pagedAssets.length > maxResults) {
                pagedAssets = Arrays.copyOfRange(pagedAssets, 0, maxResults - resultAssets.size());
            }
            resultAssets.addAll(Arrays.asList(pagedAssets));
            offset = offset + pagedAssets.length;
        }
        return (Asset[])ArrayUtil.toArray(resultAssets, Asset.class);
    }

    protected com.vmware.license.client.cis.management.ds.Asset[] createAssets(Asset[] serviceAssets, LicenseScope scope) {
        if (ArrayUtil.isNullOrEmpty((Object[])serviceAssets)) {
            return new com.vmware.license.client.cis.management.ds.Asset[0];
        }
        com.vmware.license.client.cis.management.ds.Asset[] assets = new com.vmware.license.client.cis.management.ds.Asset[serviceAssets.length];
        for (int i = 0; i < assets.length; ++i) {
            assets[i] = AssetUtil.createAsset(serviceAssets[i], scope);
        }
        return assets;
    }

    private LicenseUtilization[] searchLicenseUtilizations(LicenseSearchSpec searchSpec, LicenseScope scope) {
        LicenseUtilization[] licenseUtilizations;
        SystemManagementService sms = this.getSystemManagementService(scope);
        try {
            licenseUtilizations = sms.searchLicenseUtilizations(searchSpec);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
        return licenseUtilizations;
    }

    private SystemManagementService getSystemManagementService(LicenseScope scope) {
        LicenseClient client = this.getLicenseClient(scope);
        return client.getSystemManagementService();
    }

    private LicenseClient getLicenseClient(LicenseScope scope) {
        try {
            return this._licenseClientProvider.getLicenseClient(scope);
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    private ProductUtilization[] searchProductUtilizations(ProductSearchSpec searchSpec, LicenseScope scope) {
        ProductUtilization[] productUtilizations;
        SystemManagementService sms = this.getSystemManagementService(scope);
        try {
            productUtilizations = sms.searchProductUtilizations(searchSpec);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
        return productUtilizations;
    }

    private URI[] excludeEvaluationLicenseUri(URI[] licenseUris) {
        ArrayList<URI> licenseUrisWithoutEvaluationLicense = new ArrayList<URI>();
        for (URI licenseUri : licenseUris) {
            if (LicenseUtil.EVALUATION_LICENSE_URI.equals(licenseUri)) continue;
            licenseUrisWithoutEvaluationLicense.add(licenseUri);
        }
        return licenseUrisWithoutEvaluationLicense.toArray(new URI[0]);
    }
}

