/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.AssetUpdateNewLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpecByLicenseState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationVpxManagementEditorWrapperImpl
implements VpxManagementEditor {
    private static final int SERIAL_KEY_MASK_START_INDEX = 6;
    private static final int SERIAL_KEY_MASK_END_INDEX = 22;
    private static final String SERIAL_KEY_MASK_PATTERN = "XXXXX-XXXXX-XXXXX";
    private final VpxManagementEditor _vpxManagementEditor;
    private final AuthorizationManager _authorizationManager;
    private final Log _logger = LogFactory.getLog(AuthorizationVpxManagementEditorWrapperImpl.class);

    public AuthorizationVpxManagementEditorWrapperImpl(VpxManagementEditor vpxManagementEditor, AuthorizationManager authorizationManager) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public License[] getLicenses(URI[] licenseUris, LicenseScope scope) {
        this.validateLicensingPrivilegeGranted(scope);
        License[] licenses = this._vpxManagementEditor.getLicenses(licenseUris, scope);
        return licenses;
    }

    @Override
    public License[] getLicenses(LicenseScope scope, LicenseSearchProperties properties) {
        this.validateLicensingPrivilegeGranted(scope);
        License[] licenses = this._vpxManagementEditor.getLicenses(scope, properties);
        return licenses;
    }

    @Override
    public License[] getLicensesForProduct(URI productUri, LicenseSearchProperties properties) {
        UriUtil.validateProductUri(productUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(productUri);
        this.validateLicensingPrivilegeGranted(scope);
        License[] licenses = this._vpxManagementEditor.getLicensesForProduct(productUri, properties);
        return licenses;
    }

    @Override
    public ProductAggregation[] getProductAggregations(URI[] productUris, LicenseScope scope) {
        this.validateLicensingPrivilegeGranted(scope);
        ProductAggregation[] productAggregations = this._vpxManagementEditor.getProductAggregations(productUris, scope);
        return productAggregations;
    }

    @Override
    public ProductAggregation[] getProductAggregationsForLicense(URI licenseUri) {
        UriUtil.validateLicenseUri(licenseUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
        this.validateLicensingPrivilegeGranted(scope);
        ProductAggregation[] productAggregations = this._vpxManagementEditor.getProductAggregationsForLicense(licenseUri);
        return productAggregations;
    }

    @Override
    public Asset[] getAssets(URI[] assetUris, LicenseScope scope) {
        Asset[] assets = this._vpxManagementEditor.getAssets(assetUris, scope);
        if (!this.isLicensingPrivilegeGranted(scope)) {
            this.maskAssetsSerialKeys(assets);
        }
        return assets;
    }

    @Override
    public Asset[] getAssetsByMoRefs(ManagedObjectReference[] managedObjectReferences, LicenseScope scope) {
        Asset[] assets = this._vpxManagementEditor.getAssetsByMoRefs(managedObjectReferences, scope);
        if (!this.isLicensingPrivilegeGranted(scope)) {
            this.maskAssetsSerialKeys(assets);
        }
        return assets;
    }

    @Override
    public Asset[] getAssets(LicenseScope scope, AssetSearchProperties properties) {
        Asset[] assets = this._vpxManagementEditor.getAssets(scope, properties);
        if (!this.isLicensingPrivilegeGranted(scope)) {
            this.maskAssetsSerialKeys(assets);
        }
        return assets;
    }

    @Override
    public Asset[] getAssetsByLicenseState(AssetSearchProperties properties, AssetSearchSpecByLicenseState.LicenseState licenseState) {
        Asset[] assets = this._vpxManagementEditor.getAssetsByLicenseState(properties, licenseState);
        if (!this.isLicensingPrivilegeGranted(ManagementUtil.SCOPE_CIS_LICENSING)) {
            this.maskAssetsSerialKeys(assets);
        }
        return assets;
    }

    @Override
    public Asset[] getAssetsForProduct(URI productUri, AssetSearchProperties properties) {
        Asset[] assets = this._vpxManagementEditor.getAssetsForProduct(productUri, properties);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(productUri);
        if (!this.isLicensingPrivilegeGranted(scope)) {
            this.maskAssetsSerialKeys(assets);
        }
        return assets;
    }

    @Override
    public Asset[] getAssetsForLicense(URI licenseUri, AssetSearchProperties properties) {
        Asset[] assets = this._vpxManagementEditor.getAssetsForLicense(licenseUri, properties);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
        if (!this.isLicensingPrivilegeGranted(scope)) {
            this.maskAssetsSerialKeys(assets);
        }
        return assets;
    }

    @Override
    public URI[] addLicenses(LicenseCreateSpec[] createSpecs) {
        if (ArrayUtil.isNullOrEmpty((Object[])createSpecs)) {
            throw new IllegalArgumentException("createSpecs should not be null.");
        }
        this.validateLicensingPrivilegeGranted(createSpecs[0].scope);
        return this._vpxManagementEditor.addLicenses(createSpecs);
    }

    @Override
    public URI addSubscriptionLicense(AddSubscriptionLicenseSpec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{spec});
        this.validateLicensingPrivilegeGranted(spec.scope);
        return this._vpxManagementEditor.addSubscriptionLicense(spec);
    }

    @Override
    public void updateLicenses(LicenseUpdateSpec[] updateSpecs) {
        if (ArrayUtil.isNullOrEmpty((Object[])updateSpecs)) {
            throw new IllegalArgumentException("updateSpecs should not be null.");
        }
        URI licenseUri = updateSpecs[0].uri;
        UriUtil.validateLicenseUri(licenseUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
        this.validateLicensingPrivilegeGranted(scope);
        this._vpxManagementEditor.updateLicenses(updateSpecs);
    }

    @Override
    public void removeLicenses(URI[] licenseUris) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseUris)) {
            throw new IllegalArgumentException("licenseUris should not be null.");
        }
        URI licenseUri = licenseUris[0];
        UriUtil.validateLicenseUri(licenseUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
        this.validateLicensingPrivilegeGranted(scope);
        this._vpxManagementEditor.removeLicenses(licenseUris);
    }

    @Override
    public License[] previewLicenses(LicensePreviewSpec[] previewSpecs) {
        if (ArrayUtil.isNullOrEmpty((Object[])previewSpecs)) {
            throw new IllegalArgumentException("previewSpecs should not be null.");
        }
        this.validateLicensingPrivilegeGranted(previewSpecs[0].scope);
        License[] licenses = this._vpxManagementEditor.previewLicenses(previewSpecs);
        return licenses;
    }

    @Override
    public AddSubscriptionLicensePreviewResult previewSubscriptionLicense(AddSubscriptionLicensePreviewSpec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{spec});
        this.validateLicensingPrivilegeGranted(spec.scope);
        AddSubscriptionLicensePreviewResult result = this._vpxManagementEditor.previewSubscriptionLicense(spec);
        return result;
    }

    @Override
    public void updateAssetsLicense(AssetUpdateLicenseSpec[] updateSpecs) {
        if (ArrayUtil.isNullOrEmpty((Object[])updateSpecs)) {
            throw new IllegalArgumentException("updateSpecs should not be null.");
        }
        URI assetUri = updateSpecs[0].getAssetRef();
        UriUtil.validateAssetUri(assetUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUri);
        this.validateLicensingPrivilegeGranted(scope);
        this._vpxManagementEditor.updateAssetsLicense(updateSpecs);
    }

    @Override
    public void updateAssetsWithNewLicense(AssetUpdateNewLicenseSpec[] assetUpdateNewLicenseSpecs) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetUpdateNewLicenseSpecs)) {
            throw new IllegalArgumentException("updateSpecs should not be null.");
        }
        URI assetUri = assetUpdateNewLicenseSpecs[0].assetUri;
        UriUtil.validateAssetUri(assetUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUri);
        this.validateLicensingPrivilegeGranted(scope);
        this._vpxManagementEditor.updateAssetsWithNewLicense(assetUpdateNewLicenseSpecs);
    }

    @Override
    public void unregisterAssets(URI[] assetUris) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetUris)) {
            throw new IllegalArgumentException("assetUris should not be null.");
        }
        URI assetUri = assetUris[0];
        UriUtil.validateAssetUri(assetUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUri);
        this.validateLicensingPrivilegeGranted(scope);
        this._vpxManagementEditor.unregisterAssets(assetUris);
    }

    private void validateLicensingPrivilegeGranted(LicenseUiScope uiScope) {
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(uiScope);
        this.validateLicensingPrivilegeGranted(scope);
    }

    private void validateLicensingPrivilegeGranted(LicenseScope scope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{scope});
        boolean licensingPrivilegeGranted = this.isLicensingPrivilegeGranted(scope);
        if (!licensingPrivilegeGranted) {
            throw new ManagementException(ManagementUtil.getLocalizedString("error.lsPrivilegeNotGranted"), ManagementException.ReasonType.NOT_AUTHORIZED);
        }
    }

    private boolean isLicensingPrivilegeGranted(LicenseScope scope) {
        try {
            return this._authorizationManager.isLicensingAdminPrivilegeGranted(scope);
        }
        catch (Exception e) {
            this._logger.warn((Object)"Unable to retrieve licensing privileges information. Assuming access is not granted.", (Throwable)e);
            return false;
        }
    }

    private void maskAssetsSerialKeys(Asset[] assets) {
        if (ArrayUtil.isNullOrEmpty((Object[])assets)) {
            return;
        }
        for (Asset asset : assets) {
            if (asset == null) continue;
            this.maskLicenseSerialKeys(asset.getLicense());
            this.maskLicenseSerialKeys(asset.getEvaluationLicense());
        }
    }

    private void maskLicenseSerialKeys(License license) {
        if (license == null || ArrayUtil.isNullOrEmpty((Object[])license.getSerialKeys())) {
            return;
        }
        String[] licenseSerialKeys = license.getSerialKeys();
        String[] obfuscatedSerialKeys = new String[licenseSerialKeys.length];
        for (int i = 0; i < licenseSerialKeys.length; ++i) {
            obfuscatedSerialKeys[i] = this.maskSerialKey(licenseSerialKeys[i]);
        }
        license.setSerialKeys(obfuscatedSerialKeys);
    }

    private String maskSerialKey(String serialKey) {
        String result;
        if (serialKey == null) {
            return null;
        }
        if (serialKey.length() > 22) {
            String prefix = serialKey.substring(0, 6);
            String suffix = serialKey.substring(23);
            result = prefix + SERIAL_KEY_MASK_PATTERN + suffix;
        } else {
            result = serialKey;
        }
        return result;
    }
}

