/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.adapter.BaseLicensingObjectsDataProviderAdapterImpl;
import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseManagementDataProviderAdapterImpl<T>
extends BaseLicensingObjectsDataProviderAdapterImpl<T> {
    @Override
    protected T[] getObjectsByPropertyConstraint(PropertyConstraint pc) {
        if (!"scope".equals(pc.propertyName)) {
            return super.getObjectsByPropertyConstraint(pc);
        }
        LicenseUiScope licenseUiScope = null;
        if (pc.comparableValue instanceof String) {
            licenseUiScope = new LicenseUiScope();
            licenseUiScope.setId((String)pc.comparableValue);
        } else if (pc.comparableValue instanceof LicenseUiScope) {
            licenseUiScope = (LicenseUiScope)((Object)pc.comparableValue);
        }
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        T[] objects = this.getObjectsByScope(scope);
        return objects;
    }

    @Override
    protected T[] getObjectsByUris(URI[] objectUris) {
        if (ArrayUtil.isNullOrEmpty((Object[])objectUris)) {
            return super.getObjectsByUris(objectUris);
        }
        Map<LicenseScope, List<URI>> scopeToUris = LicenseScopeUtil.groupUiObjectsUrisByScope(objectUris);
        if (scopeToUris.size() == 1) {
            LicenseScope scope = scopeToUris.keySet().iterator().next();
            return this.getObjectsByUrisAndScope(objectUris, scope);
        }
        ArrayList result = new ArrayList();
        Object[] objects = null;
        for (Map.Entry<LicenseScope, List<URI>> entry : scopeToUris.entrySet()) {
            URI[] uris = entry.getValue().toArray(new URI[entry.getValue().size()]);
            LicenseScope scope = entry.getKey();
            objects = this.getObjectsByUrisAndScope(uris, scope);
            ArrayUtil.append(result, (Object[])objects);
        }
        return result.toArray(objects);
    }

    @Override
    protected T[] getAllObjects() {
        return this.getObjectsByScope(ManagementUtil.SCOPE_CIS_LICENSING);
    }

    protected T[] getObjectsByScope(LicenseScope scope) {
        return null;
    }

    protected T[] getObjectsByUrisAndScope(URI[] objectUris, LicenseScope scope) {
        return null;
    }
}

