/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProviderFactory;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.adapter.AssetPropertyProviderBean;
import com.vmware.license.client.cis.management.adapter.BaseManagementDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpecByLicenseState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@type(value="Asset")
public class AssetDataProviderAdapterImpl
extends BaseManagementDataProviderAdapterImpl<Asset> {
    private static final String RELATION_ASSETS = "assets";
    private static final String RELATION_LICENSING_OBJ_URI = "licensingObjectUri";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_VC_SERVICE_ID = "vcServiceId";
    private static final String PROPERTY_LICENSE_STATE = "licenseState";
    private static final String PROPERTY_MAX_RESULT_OBJECTS = "maxResultObjects";
    private static final int MAX_RESULT_OBJECTS_BY_LICENSE_STATE = 2000;
    private final VpxManagementEditor _vpxManagementEditor;
    private final SsoSpecificTopologyInfoProviderFactory _topologyInfoProviderFactory;

    private static URI getSingleUri(Object[] objectsRefs) {
        return (URI)objectsRefs[0];
    }

    public AssetDataProviderAdapterImpl(VpxManagementEditor vpxManagementEditor, SsoSpecificTopologyInfoProviderFactory topologyInfoProviderFactory) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._topologyInfoProviderFactory = topologyInfoProviderFactory;
    }

    @Override
    protected BasePropertyProviderBean<Asset> getPropertyProvider() {
        return new AssetPropertyProviderBean();
    }

    @Override
    protected String getProvidedType() {
        return "Asset";
    }

    @Override
    protected URI getUri(Asset object) {
        return object.getUri();
    }

    protected Asset[] getObjectsByScope(LicenseScope scope) {
        return this._vpxManagementEditor.getAssets((URI[])null, scope);
    }

    protected Asset[] getObjectsByUrisAndScope(URI[] objectUris, LicenseScope scope) {
        return this._vpxManagementEditor.getAssets(objectUris, scope);
    }

    protected Asset[] getRelatedObjects(Object[] objectsRefs, String relation) {
        if (!RELATION_ASSETS.equals(relation)) {
            return (Asset[])super.getRelatedObjects(objectsRefs, relation);
        }
        ManagedObjectReference[] moRefs = new ManagedObjectReference[objectsRefs.length];
        for (int i = 0; i < objectsRefs.length; ++i) {
            if (!(objectsRefs[i] instanceof ManagedObjectReference)) {
                return (Asset[])super.getRelatedObjects(objectsRefs, relation);
            }
            moRefs[i] = (ManagedObjectReference)objectsRefs[i];
        }
        return this.getAssetsByMoRefs(moRefs);
    }

    protected Asset[] getObjectsByPropertyConstraint(PropertyConstraint pc) {
        if (PROPERTY_LICENSE_STATE.equals(pc.propertyName)) {
            return this.getAssetsInLicenseState(AssetSearchSpecByLicenseState.LicenseState.valueOf((String)((String)pc.comparableValue)), null);
        }
        return (Asset[])super.getObjectsByPropertyConstraint(pc);
    }

    protected Asset[] getObjectsByCompositeConstraint(CompositeConstraint cc) {
        AssetConstraintProperties constraintProperties = this.getAssetConstraintProperties(cc);
        if (constraintProperties == null) {
            return (Asset[])super.getObjectsByCompositeConstraint(cc);
        }
        Asset[] resultAssets = this.getAssetsByConstraintProperties(constraintProperties);
        return resultAssets;
    }

    protected Asset[] getAllObjects() {
        return null;
    }

    private Asset[] getAssetsByMoRefs(ManagedObjectReference[] moRefs) {
        Map<LicenseScope, ArrayList<ManagedObjectReference>> scopeToMoRefs = this.getScopeToMoRefs(moRefs);
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Map.Entry<LicenseScope, ArrayList<ManagedObjectReference>> entry : scopeToMoRefs.entrySet()) {
            Asset[] assets = this._vpxManagementEditor.getAssetsByMoRefs(entry.getValue().toArray(new ManagedObjectReference[entry.getValue().size()]), entry.getKey());
            result.addAll(Arrays.asList(assets));
        }
        return result.toArray(new Asset[result.size()]);
    }

    private Map<LicenseScope, ArrayList<ManagedObjectReference>> getScopeToMoRefs(ManagedObjectReference[] moRefs) {
        HashMap<LicenseScope, ArrayList<ManagedObjectReference>> result = new HashMap<LicenseScope, ArrayList<ManagedObjectReference>>();
        if (ArrayUtil.isNullOrEmpty((Object[])moRefs)) {
            return result;
        }
        for (ManagedObjectReference moRef : moRefs) {
            LicenseScope scope = LicenseScopeUtil.getLicenseScopeByMoRef(moRef);
            ArrayList<Object> scopeMoRefs = result.get(scope);
            if (scopeMoRefs == null) {
                scopeMoRefs = new ArrayList();
                result.put(scope, scopeMoRefs);
            }
            scopeMoRefs.add(moRef);
        }
        return result;
    }

    private AssetConstraintProperties getAssetConstraintProperties(CompositeConstraint cc) {
        if (cc.nestedConstraints.length > 1 && !Conjoiner.AND.equals((Object)cc.conjoiner)) {
            return null;
        }
        AssetConstraintProperties result = new AssetConstraintProperties();
        for (Constraint constraint : cc.nestedConstraints) {
            if (constraint instanceof PropertyConstraint) {
                PropertyConstraint pc = (PropertyConstraint)constraint;
                result = this.getAssetConstraintProperties(result, pc);
                continue;
            }
            if (constraint instanceof RelationalConstraint) {
                RelationalConstraint rc = (RelationalConstraint)constraint;
                result = this.getAssetConstraintProperties(result, rc);
                continue;
            }
            result = null;
            break;
        }
        return result;
    }

    private AssetConstraintProperties getAssetConstraintProperties(AssetConstraintProperties properties, PropertyConstraint pc) {
        AssetConstraintProperties result = new AssetConstraintProperties(properties);
        if ("scope".equals(pc.propertyName)) {
            if (pc.comparableValue instanceof String) {
                result.licenseUiScope = new LicenseUiScope();
                result.licenseUiScope.setId((String)pc.comparableValue);
            } else {
                result.licenseUiScope = (LicenseUiScope)((Object)pc.comparableValue);
            }
        } else if (PROPERTY_TYPE.equals(pc.propertyName)) {
            result.type = pc.comparableValue instanceof String ? AssetType.valueOf((String)pc.comparableValue) : (AssetType)((Object)pc.comparableValue);
        } else if (PROPERTY_VC_SERVICE_ID.equals(pc.propertyName)) {
            result.vcServiceId = (String)pc.comparableValue;
        } else if (PROPERTY_MAX_RESULT_OBJECTS.equals(pc.propertyName)) {
            result.maxResultObjects = (Number)pc.comparableValue;
        } else if (RELATION_LICENSING_OBJ_URI.equals(pc.propertyName) && UriUtil.containsSingleUriWithType(new URI[]{URI.create(pc.comparableValue.toString())}, "Product")) {
            result.productUri = URI.create(pc.comparableValue.toString());
        } else if (RELATION_LICENSING_OBJ_URI.equals(pc.propertyName) && UriUtil.containsSingleUriWithType(new URI[]{URI.create(pc.comparableValue.toString())}, "License")) {
            result.licenseUri = URI.create(pc.comparableValue.toString());
        } else if (PROPERTY_LICENSE_STATE.equals(pc.propertyName)) {
            result.licenseState = pc.comparableValue.toString();
        } else {
            result = null;
        }
        return result;
    }

    private AssetConstraintProperties getAssetConstraintProperties(AssetConstraintProperties properties, RelationalConstraint rc) {
        if (!RELATION_ASSETS.equals(rc.relation)) {
            return null;
        }
        AssetConstraintProperties result = new AssetConstraintProperties(properties);
        Object[] objectsRefs = Utils.getEnumeratedObjects((RelationalConstraint)rc);
        if (UriUtil.containsSingleUriWithType(objectsRefs, "Product")) {
            result.productUri = AssetDataProviderAdapterImpl.getSingleUri(objectsRefs);
        } else if (UriUtil.containsSingleUriWithType(objectsRefs, "License")) {
            result.licenseUri = AssetDataProviderAdapterImpl.getSingleUri(objectsRefs);
        } else {
            result = null;
        }
        return result;
    }

    private Asset[] getAssetsByConstraintProperties(AssetConstraintProperties constraintProperties) {
        AssetSearchSpecByLicenseState.LicenseState licenseState;
        AssetSearchProperties searchProperties = this.getAssetSearchProperties(constraintProperties);
        Asset[] resultAssets = null;
        if (constraintProperties.licenseUiScope != null) {
            LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(constraintProperties.licenseUiScope);
            resultAssets = this._vpxManagementEditor.getAssets(scope, searchProperties);
        } else if (constraintProperties.productUri != null) {
            resultAssets = this._vpxManagementEditor.getAssetsForProduct(constraintProperties.productUri, searchProperties);
        } else if (constraintProperties.licenseUri != null) {
            resultAssets = LicenseUtil.EVALUATION_LICENSE_URI.equals(constraintProperties.licenseUri) ? this.getAssetsInLicenseState(AssetSearchSpecByLicenseState.LicenseState.evaluation, searchProperties) : this._vpxManagementEditor.getAssetsForLicense(constraintProperties.licenseUri, searchProperties);
        } else if (constraintProperties.licenseState != null && (licenseState = AssetSearchSpecByLicenseState.LicenseState.valueOf((String)constraintProperties.licenseState)) != null) {
            resultAssets = this.getAssetsInLicenseState(licenseState, searchProperties);
        }
        return resultAssets;
    }

    private Asset[] getAssetsInLicenseState(AssetSearchSpecByLicenseState.LicenseState licenseState, AssetSearchProperties searchProperties) {
        if (searchProperties == null) {
            searchProperties = AssetUtil.createAssetSearchProperties(null, null, 2000);
        } else if (searchProperties.getMaxResultObjects() == null || 2000 < searchProperties.getMaxResultObjects()) {
            searchProperties.setMaxResultObjects(2000);
        }
        Asset[] assetsWithEvaluationLicense = this._vpxManagementEditor.getAssetsByLicenseState(searchProperties, licenseState);
        ArrayList<Asset> assetsFilteredByType = new ArrayList<Asset>();
        if (assetsWithEvaluationLicense != null) {
            for (Asset asset : assetsWithEvaluationLicense) {
                if (searchProperties.getType() != null && !searchProperties.getType().equals((Object)asset.getType())) continue;
                assetsFilteredByType.add(asset);
            }
        }
        return assetsFilteredByType.toArray(new Asset[0]);
    }

    private AssetSearchProperties getAssetSearchProperties(AssetConstraintProperties constraintProperties) {
        String scopeId = this.getAssetScopeId(constraintProperties.vcServiceId);
        Integer maxResultObjects = constraintProperties.maxResultObjects != null ? Integer.valueOf(constraintProperties.maxResultObjects.intValue()) : null;
        AssetSearchProperties searchProperties = AssetUtil.createAssetSearchProperties(constraintProperties.type, scopeId, maxResultObjects);
        return searchProperties;
    }

    private String getAssetScopeId(String vcServiceId) {
        if (vcServiceId == null) {
            return null;
        }
        ArrayList<String> vcIds = new ArrayList<String>();
        vcIds.add(vcServiceId);
        try {
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getTopologyInfoProviderForVc(vcServiceId);
            String assetScopeId = null;
            if (assetScopeId != null) {
                Map<String, String> vcIdToNodeId = ssoSpecificTopologyInfoProvider.getVcIdToNodeId(vcIds);
                assetScopeId = vcIdToNodeId.get(vcServiceId);
            }
            return assetScopeId;
        }
        catch (TopologyInfoRetrievalException e) {
            throw new RuntimeException(e);
        }
    }

    private static class AssetConstraintProperties {
        public LicenseUiScope licenseUiScope;
        public URI productUri;
        public URI licenseUri;
        public AssetType type;
        public String vcServiceId;
        public String licenseState;
        public Number maxResultObjects;

        public AssetConstraintProperties() {
        }

        public AssetConstraintProperties(AssetConstraintProperties other) {
            this.licenseUiScope = other.licenseUiScope;
            this.productUri = other.productUri;
            this.licenseUri = other.licenseUri;
            this.type = other.type;
            this.vcServiceId = other.vcServiceId;
            this.licenseState = other.licenseState;
            this.maxResultObjects = other.maxResultObjects;
        }
    }
}

