/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.authz.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import java.util.List;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private static final String LS_ADMIN_SSO_GROUP = "LicenseService.Administrators";
    private static final String ADMINISTRATOR_SSO_GROUP = "Administrators";

    private static boolean isGroupInToken(String groupName, String groupDomain, SamlToken token) {
        if (token == null || token.getGroupList() == null) {
            return false;
        }
        boolean result = false;
        List tokenGroups = token.getGroupList();
        for (PrincipalId tokenGroup : tokenGroups) {
            if (!groupName.equals(tokenGroup.getName()) || !groupDomain.equals(tokenGroup.getDomain())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean isLicensingAdminPrivilegeGranted(LicenseScope scope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{scope});
        boolean result = this.isCurrentLoggedInUserLicenseAdmin();
        return result;
    }

    private boolean isCurrentLoggedInUserLicenseAdmin() {
        SamlToken currentLoggedInUserToken = AuthSessionUtil.getSsoToken();
        String systemDomainName = this.getSystemDomainName();
        boolean result = AuthorizationManagerImpl.isGroupInToken(LS_ADMIN_SSO_GROUP, systemDomainName, currentLoggedInUserToken);
        if (!result) {
            result = AuthorizationManagerImpl.isGroupInToken(ADMINISTRATOR_SSO_GROUP, systemDomainName, currentLoggedInUserToken);
        }
        return result;
    }

    private String getSystemDomainName() {
        SsoSolutionUser ngcSolutionUser = SsoUtil.getSolutionUser();
        SamlToken token = ngcSolutionUser.getLoggedInToken(SsoDomain.getLocal());
        return SsoUtil.getDomainName((String)token.getSubjectNameId().getValue());
    }
}

