/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.global.impl;

import com.vmware.license.client.cis.global.LicensingGlobalDataEditor;
import com.vmware.license.client.cis.global.ds.LicensingGlobalData;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationException;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProviderFactory;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicensingGlobalDataEditorImpl
implements LicensingGlobalDataEditor {
    private final Log _logger = LogFactory.getLog(LicensingGlobalDataEditorImpl.class);
    private final SsoSpecificTopologyInfoProviderFactory _topologyInfoProviderFactory;
    private final AuthorizationManager _authorizationManager;

    public LicensingGlobalDataEditorImpl(SsoSpecificTopologyInfoProviderFactory topologyInfoProviderFactory, AuthorizationManager authorizationManager) {
        this._topologyInfoProviderFactory = topologyInfoProviderFactory;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public LicensingGlobalData getLicensingGlobalData(URI licensingGlobalDataUri) {
        if (!UriUtil.isUriOfType(licensingGlobalDataUri, "LicensingGlobalData")) {
            throw new IllegalArgumentException("Invalid URI: " + licensingGlobalDataUri);
        }
        int licenseServicesCount = this.getLicenseServicesCount();
        boolean dataReplicationDelayed = licenseServicesCount > 1;
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licensingGlobalDataUri);
        boolean licensingAdminPrivilegeGranted = this.isLicensingAdminPrivilegeGranted(scope);
        String localVcId = this.getLocalVcId();
        return this.createLicensingGlobalData(licensingGlobalDataUri, dataReplicationDelayed, licensingAdminPrivilegeGranted, localVcId);
    }

    private int getLicenseServicesCount() {
        try {
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getDefaultTopologyInfoProvider();
            return ssoSpecificTopologyInfoProvider.getLicenseServicesCount();
        }
        catch (TopologyInfoRetrievalException e) {
            this._logger.warn((Object)"Could not retrieve license service count. Returning 1 instead.", (Throwable)e);
            return 1;
        }
    }

    private boolean isLicensingAdminPrivilegeGranted(LicenseScope scope) {
        try {
            return this._authorizationManager.isLicensingAdminPrivilegeGranted(scope);
        }
        catch (AuthorizationException e) {
            this._logger.error((Object)"Error when retrieving licensing admin privileges.", (Throwable)e);
            throw new ManagementException(e);
        }
    }

    private String getLocalVcId() {
        try {
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getDefaultTopologyInfoProvider();
            return ssoSpecificTopologyInfoProvider.getLocalVcId();
        }
        catch (TopologyInfoRetrievalException e) {
            this._logger.warn((Object)"Could not retrieve local VC ID. Returning null instad", (Throwable)e);
            return null;
        }
    }

    private LicensingGlobalData createLicensingGlobalData(URI uri, boolean dataReplicationDelayed, boolean licensingAdminPrivilegeGranted, String localVcId) {
        LicensingGlobalData licensingGlobalData = new LicensingGlobalData();
        licensingGlobalData.setUri(uri);
        licensingGlobalData.setDataReplicationDelayed(dataReplicationDelayed);
        licensingGlobalData.setLicensingAdminPrivilegeGranted(licensingAdminPrivilegeGranted);
        licensingGlobalData.setLocalVcId(localVcId);
        return licensingGlobalData;
    }
}

