/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.adapter;

import com.vmware.license.client.cis.util.ExceptionUtil;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseDataProviderAdapterImpl
implements DataProviderAdapter {
    private final Log _logger = LogFactory.getLog(BaseDataProviderAdapterImpl.class);

    public final Response getData(RequestSpec request) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{request});
        QuerySpec[] querySpecs = request.querySpec;
        ResultSet[] resultSets = new ResultSet[querySpecs.length];
        for (int i = 0; i < querySpecs.length; ++i) {
            resultSets[i] = this.processQuery(querySpecs[i]);
        }
        Response response = new Response();
        response.resultSet = resultSets;
        return response;
    }

    protected abstract ResultSet getResultSet(QuerySpec var1);

    private ResultSet processQuery(QuerySpec querySpec) {
        ResultSet resultSet = null;
        try {
            resultSet = this.getResultSet(querySpec);
        }
        catch (Exception e) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Unable to retrieve licensing data: ", (Throwable)e);
            }
            resultSet = ResultUtil.newEmptyResultSet();
            resultSet.error = ExceptionUtil.createLocalizedException(e);
        }
        resultSet.queryName = querySpec.name;
        return resultSet;
    }
}

