/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.util;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.drs.model.IdentifiableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelPropertyRetrievalUtil {
    public static <U, T extends IdentifiableModel> Map<U, T> getObjectProperties(QueryBindingService _queryBindingService, ManagedObjectReference[] objRefs, String objectType, Class<T> modelClass) {
        Map<Object, Object> objPropsByRef;
        List<ManagedObjectReference> homogeneousObjects = ModelPropertyRetrievalUtil.filterObjectsByType(objectType, objRefs);
        if (homogeneousObjects.size() > 0) {
            Collection resultSet = _queryBindingService.prepare(modelClass).fetch(homogeneousObjects);
            objPropsByRef = ModelPropertyRetrievalUtil.getTargetMapByResultSet(resultSet);
        } else {
            objPropsByRef = Collections.emptyMap();
        }
        return objPropsByRef;
    }

    private static <T extends IdentifiableModel> Map<Object, T> getTargetMapByResultSet(Collection<T> resultSet) {
        HashMap<Object, IdentifiableModel> propertiesByObject = new HashMap<Object, IdentifiableModel>();
        for (IdentifiableModel resultItem : resultSet) {
            Object objRef = resultItem.getProvider();
            propertiesByObject.put(objRef, resultItem);
        }
        return propertiesByObject;
    }

    private static List<ManagedObjectReference> filterObjectsByType(String resourceType, ManagedObjectReference[] objects) {
        ArrayList<ManagedObjectReference> filteredObjects = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference object : objects) {
            if (object == null || !object.getType().equals(resourceType)) continue;
            filteredObjects.add(object);
        }
        return filteredObjects;
    }
}

