/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.ActionHistory;
import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vim.storageDrs.HbrDiskMigrationAction;
import com.vmware.vim.binding.vim.storageDrs.StorageMigrationAction;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementAction;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.drs.model.DatastoreMonitorTargetData;
import com.vmware.vsphere.client.drs.model.DrsFaultListItem;
import com.vmware.vsphere.client.drs.model.MonitorTargetData;
import com.vmware.vsphere.client.dscluster.SdrsRecommendationsService;
import com.vmware.vsphere.client.dscluster.model.SdrsRecommendationListItemData;
import com.vmware.vsphere.client.dscluster.model.SdrsVmTargetData;
import com.vmware.vsphere.client.dscluster.model.monitor.history.SdrsActionHistoryListItem;
import com.vmware.vsphere.client.dscluster.util.ModelPropertyRetrievalUtil;
import com.vmware.vsphere.client.dscluster.util.SdrsActionHistoryUtil;
import com.vmware.vsphere.client.dscluster.util.SdrsFaultsUtil;
import com.vmware.vsphere.client.dscluster.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SdrsMonitorPropertyProvider {
    public static final String PROPERTY_RECOMMENDATION = "podStorageDrsEntry/recommendation";
    public static final String PROPERTY_FAULT = "podStorageDrsEntry/drsFault";
    public static final String PROPERTY_ACTION_HISTORY = "podStorageDrsEntry/actionHistory";
    private static final String STORAGE_MIGRATION_ACTION_ICON = "vx-icon-vmDisk";
    private static final String VIRTUAL_MACHINE_ACTION_ICON = "vsphere-icon-vm";
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;
    private final SdrsRecommendationsService _sdrsRecommendationsService;
    private Map<SdrsActionHistoryListItem, int[]> _ahListItemDiskIds = new HashMap<SdrsActionHistoryListItem, int[]>();
    private static final Log _logger = LogFactory.getLog(SdrsMonitorPropertyProvider.class);

    public SdrsMonitorPropertyProvider(QueryService queryService, QueryBindingService queryBindingService, SdrsRecommendationsService sdrsRecommendationsService) {
        this._queryService = queryService;
        this._queryBindingService = queryBindingService;
        this._sdrsRecommendationsService = sdrsRecommendationsService;
    }

    @PropertyProvider(value="StoragePod/computedSdrsRecommendations")
    public List<SdrsRecommendationListItemData[]> getComputedSdrsRecommendations(Collection<ManagedObjectReference> objects) throws Exception {
        ArrayList<SdrsRecommendationListItemData[]> result = new ArrayList<SdrsRecommendationListItemData[]>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_RECOMMENDATION}).from(new String[]{StoragePod.class.getSimpleName()}).where(new PropertyPredicate[]{this.buildIdentityFilter(objects)}).fetch();
        for (ResourceItem resultItem : resultSet.getItems()) {
            Recommendation[] recommendations = (Recommendation[])resultItem.get(PROPERTY_RECOMMENDATION);
            result.add(this._sdrsRecommendationsService.getRecommendationListData(recommendations));
        }
        return result;
    }

    @PropertyProvider(value="StoragePod/computedSdrsFaults")
    public List<DrsFaultListItem[]> getComputedSdrsFaults(Collection<ManagedObjectReference> objects) throws Exception {
        ArrayList<DrsFaultListItem[]> result = new ArrayList<DrsFaultListItem[]>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_FAULT}).from(new String[]{StoragePod.class.getSimpleName()}).where(new PropertyPredicate[]{this.buildIdentityFilter(objects)}).fetch();
        for (ResourceItem resultItem : resultSet.getItems()) {
            DrsFaults[] faults = (DrsFaults[])resultItem.get(PROPERTY_FAULT);
            result.add(SdrsFaultsUtil.getFaultListData(faults, this._queryBindingService));
        }
        return result;
    }

    @PropertyProvider(value="StoragePod/computedActionHistory")
    public Collection<SdrsActionHistoryListItem[]> getComputedActionHistory(Collection<ManagedObjectReference> objects) {
        if (objects == null || objects.size() != 1) {
            throw new IllegalArgumentException("computedActionHistory accepts only a single StoragePod parameter.");
        }
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_ACTION_HISTORY}).from(new String[]{StoragePod.class.getSimpleName()}).where(new PropertyPredicate[]{this.buildIdentityFilter(objects)}).fetch();
        ActionHistory[] actionHistory = (ActionHistory[])((ResourceItem)resultSet.getItems().get(0)).get(PROPERTY_ACTION_HISTORY);
        return Collections.singleton(this.getActionHistoryListData(actionHistory));
    }

    private SdrsActionHistoryListItem[] getActionHistoryListData(ActionHistory[] actionHistories) {
        List<SdrsActionHistoryListItem> result = new ArrayList<SdrsActionHistoryListItem>();
        if (ArrayUtil.isNullOrEmpty((Object[])actionHistories)) {
            return result.toArray(new SdrsActionHistoryListItem[0]);
        }
        HashSet<ManagedObjectReference> targets = new HashSet<ManagedObjectReference>();
        for (ActionHistory actionHistory : actionHistories) {
            SdrsActionHistoryListItem listItem = this.createActionListItem(actionHistory);
            if (listItem == null) continue;
            targets.addAll(Arrays.asList(listItem.targets));
            result.add(listItem);
        }
        Map<Object, MonitorTargetData> objPropsByRef = this.getTargetsMonitorTargetData(targets);
        result = this.specifyListItems(result, objPropsByRef);
        return result.toArray(new SdrsActionHistoryListItem[result.size()]);
    }

    private Map<Object, MonitorTargetData> getTargetsMonitorTargetData(Set<ManagedObjectReference> targets) {
        Map vmPropsByRef = ModelPropertyRetrievalUtil.getObjectProperties(this._queryBindingService, targets.toArray(new ManagedObjectReference[0]), VirtualMachine.class.getSimpleName(), SdrsVmTargetData.class);
        Map datastorePropsByRef = ModelPropertyRetrievalUtil.getObjectProperties(this._queryBindingService, targets.toArray(new ManagedObjectReference[0]), Datastore.class.getSimpleName(), DatastoreMonitorTargetData.class);
        HashMap<Object, MonitorTargetData> objPropsByRef = new HashMap<Object, MonitorTargetData>();
        objPropsByRef.putAll(vmPropsByRef);
        objPropsByRef.putAll(datastorePropsByRef);
        return objPropsByRef;
    }

    private List<SdrsActionHistoryListItem> specifyListItems(List<SdrsActionHistoryListItem> listItems, Map<Object, MonitorTargetData> objPropsByRef) {
        for (SdrsActionHistoryListItem listItem : listItems) {
            String formattedActionText;
            listItem.targetObjects = SdrsActionHistoryUtil.getTargetObjectsData(objPropsByRef, listItem.targets);
            String vmDiskNames = "";
            if (this._ahListItemDiskIds.get(listItem) != null) {
                SdrsVmTargetData vmRef = (SdrsVmTargetData)listItem.targetObjects[0];
                if (vmRef != null) {
                    HashMap<Integer, VirtualDisk> virtualDisks = new HashMap<Integer, VirtualDisk>();
                    VirtualDisk[] vmVirtualDisks = vmRef.getVirtualDisks();
                    if (vmVirtualDisks != null) {
                        for (VirtualDisk virtualDisk : vmRef.getVirtualDisks()) {
                            virtualDisks.put(virtualDisk.key, virtualDisk);
                        }
                    }
                    vmDiskNames = SdrsActionHistoryUtil.getVmDiskNames(this._ahListItemDiskIds.get(listItem), virtualDisks);
                    listItem.image = vmRef.getPrimaryIconId();
                } else {
                    vmDiskNames = Util.getLocalizedString("sdrs.history.missingObjectNameLabel", new String[0]);
                }
                this._ahListItemDiskIds.remove(listItem);
            }
            listItem.text = formattedActionText = SdrsActionHistoryUtil.getFormattedActionText(listItem.text, vmDiskNames);
        }
        return listItems;
    }

    private SdrsActionHistoryListItem createActionListItem(ActionHistory actionHistory) {
        SdrsActionHistoryListItem actionHistoryItem;
        if (actionHistory.getAction() instanceof StorageMigrationAction) {
            StorageMigrationAction migrationAction = (StorageMigrationAction)actionHistory.getAction();
            actionHistoryItem = this.buildActionListItem(new ManagedObjectReference[]{migrationAction.vm, migrationAction.source, migrationAction.destination}, migrationAction.relocateSpec, "sdrs.history.migrateVmConfigFile", "sdrs.history.migrateHardDisks");
        } else if (actionHistory.getAction() instanceof StoragePlacementAction) {
            StoragePlacementAction placementAction = (StoragePlacementAction)actionHistory.getAction();
            actionHistoryItem = this.buildActionListItem(new ManagedObjectReference[]{placementAction.vm, placementAction.destination}, placementAction.relocateSpec, "sdrs.history.placeVmConfigFile", "sdrs.history.placeHardDisks");
        } else if (actionHistory.getAction() instanceof HbrDiskMigrationAction) {
            actionHistoryItem = new SdrsActionHistoryListItem();
            HbrDiskMigrationAction hbrDiskMigAction = (HbrDiskMigrationAction)actionHistory.getAction();
            int numberOfReplicaDisks = hbrDiskMigAction.diskIds.length;
            actionHistoryItem.targets = new ManagedObjectReference[]{hbrDiskMigAction.source, hbrDiskMigAction.destination};
            actionHistoryItem.image = VIRTUAL_MACHINE_ACTION_ICON;
            String[] historyObjectStrings = new String[]{Integer.toString(numberOfReplicaDisks), hbrDiskMigAction.collectionName};
            String partialActionHistoryText = numberOfReplicaDisks > 1 ? Util.getLocalizedString("sdrs.history.migrateHbrReplicaDisks", historyObjectStrings) : Util.getLocalizedString("sdrs.history.migrateHbrReplicaDisk", historyObjectStrings);
            actionHistoryItem.text = partialActionHistoryText.concat(" ").concat(Util.getLocalizedString("sdrs.history.migrateHbrReplicaDiskLocation", new String[0]));
        } else {
            _logger.warn((Object)("Unknown ActionHistory action found - " + actionHistory.action));
            return null;
        }
        actionHistoryItem.time = actionHistory.getTime().getTimeInMillis();
        return actionHistoryItem;
    }

    private SdrsActionHistoryListItem buildActionListItem(ManagedObjectReference[] targets, RelocateSpec relocateSpec, String migrateVmTextKey, String migrateHdTextKey) {
        SdrsActionHistoryListItem actionHistoryItem = new SdrsActionHistoryListItem();
        actionHistoryItem.targets = targets;
        int[] relocateSpecDiskIds = this.getRelocateSpecDiskIds(relocateSpec);
        if (relocateSpecDiskIds == null || relocateSpecDiskIds.length == 0) {
            actionHistoryItem.text = Util.getLocalizedString(migrateVmTextKey, new String[0]);
            actionHistoryItem.image = VIRTUAL_MACHINE_ACTION_ICON;
        } else {
            actionHistoryItem.text = Util.getLocalizedString(migrateHdTextKey, new String[0]);
            actionHistoryItem.image = STORAGE_MIGRATION_ACTION_ICON;
            this._ahListItemDiskIds.put(actionHistoryItem, relocateSpecDiskIds);
        }
        return actionHistoryItem;
    }

    private int[] getRelocateSpecDiskIds(RelocateSpec relocateSpec) {
        if (relocateSpec == null || ArrayUtil.isNullOrEmpty((Object[])relocateSpec.disk)) {
            return null;
        }
        int[] relocateSpecDiskIds = new int[relocateSpec.disk.length];
        for (int i = 0; i < relocateSpec.disk.length; ++i) {
            relocateSpecDiskIds[i] = relocateSpec.disk[i].diskId;
        }
        return relocateSpecDiskIds;
    }

    private PropertyPredicate buildIdentityFilter(Collection<ManagedObjectReference> objects) {
        return new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects);
    }
}

