/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.utils;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagCheckResult;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagChecker;
import com.vmware.vide.vwcsdktools.as.managers.MetadataTagManager;
import com.vmware.vide.vwcsdktools.as.model.MetadataTag;
import com.vmware.vide.vwcsdktools.as.parser.ActionScriptMetadataTag;
import com.vmware.vide.vwcsdktools.as.parser.BufferError;
import com.vmware.vide.vwcsdktools.managers.ReportManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Runners {
    private static ILog logger = Activator.getDefault().getLog();
    private static final String ERR_MSG = "Internal error during checking metadata tags in [%s].";

    public static void runMetadataChecker(IFile file) {
        ActionScriptMetadataTag metadatatag;
        try {
            file.deleteMarkers("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker", false, 0);
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
            return;
        }
        try {
            metadatatag = new ActionScriptMetadataTag(file);
        }
        catch (IOException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", String.format(ERR_MSG, file.getLocation().toOSString()), (Throwable)e));
            return;
        }
        catch (BufferError e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", String.format(ERR_MSG, file.getLocation().toOSString()), (Throwable)e));
            return;
        }
        List<MetadataTag> tags = metadatatag.getMetadataTags();
        if (!metadatatag.getErrors().isEmpty()) {
            ReportManager.INSTANCE.reportMetadataTagParseErrors(file, metadatatag.getErrors());
        }
        ArrayList<MetadataTagCheckResult> results = new ArrayList<MetadataTagCheckResult>();
        for (MetadataTag tag : tags) {
            String tagName = tag.getName();
            if (tagName.isEmpty()) continue;
            List<MetadataTagChecker> checkers = MetadataTagManager.INSTANCE.getCheckers(file, tag);
            for (MetadataTagChecker checker : checkers) {
                results.add(checker.run());
            }
        }
        ReportManager.INSTANCE.reportMetadataTagCheckResults(results);
    }
}

