/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.ui;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.CheckRule;
import com.vmware.vide.vwcsdktools.managers.CheckRuleManager;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.managers.DiagnosticLevel;
import com.vmware.vide.vwcsdktools.managers.ParameterRule;
import com.vmware.vide.vwcsdktools.managers.ProjectDataManager;
import com.vmware.vide.vwcsdktools.model.IPropertyChangedListener;
import com.vmware.vide.vwcsdktools.ui.DiagnosticLevelComboFieldEditor;
import com.vmware.vide.vwcsdktools.ui.FieldEditorOverlayPage;
import com.vmware.vide.vwcsdktools.utils.Names;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AnnotationDiagnosticLevelPage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    Map<String, String> originalValues;
    String originalUse;

    public AnnotationDiagnosticLevelPage() {
        super(1);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    public void init(IWorkbench workbench) {
    }

    @Override
    protected String getOwnerId() {
        return ProjectDataManager.INSTANCE.getOwnerId();
    }

    @Override
    protected boolean getDefaultUseProject() {
        IResource res = this.getResource(this.getElement());
        return ProjectDataManager.INSTANCE.getProjectRulesList(res.getProject()) != null;
    }

    @Override
    protected void createFieldEditors() {
        this.originalValues = new HashMap<String, String>();
        List<CheckRule> rules = null;
        if (this.isPropertyPage()) {
            IResource res = this.getResource(this.getElement());
            if (res == null) {
                throw new MissingResourceException("Bad element was selected.", "AnnotationDiagnosticLevelPage", null);
            }
            IProject project = res.getProject();
            String value = null;
            try {
                value = project.getPersistentProperty(new QualifiedName(this.getOwnerId(), "useproject"));
            }
            catch (CoreException coreException) {}
            if (Boolean.toString(true).equals(value)) {
                rules = ProjectDataManager.INSTANCE.getProjectRulesList(res.getProject());
            }
        }
        if (rules == null) {
            rules = CheckRuleManager.ANNOTATION_INSTANCE.getRules();
        }
        for (CheckRule rule : rules) {
            String annotationName = rule.getName();
            for (ParameterRule parameterRule : rule.getParameterRules()) {
                String parameterName = parameterRule.getName();
                for (CheckTypeRule checkType : parameterRule.getCheckTypes()) {
                    String key = Names.getPrefKeyForDiagnosticLevel(annotationName, parameterName, checkType.getType().name());
                    String[][] entries = new String[][]{{DiagnosticLevel.IGNORE.getName(), DiagnosticLevel.IGNORE.getName()}, {DiagnosticLevel.WARNING.getName(), DiagnosticLevel.WARNING.getName()}, {DiagnosticLevel.ERROR.getName(), DiagnosticLevel.ERROR.getName()}};
                    String label1 = String.valueOf(annotationName) + ':' + parameterName;
                    String label2 = checkType.getType().name();
                    DiagnosticLevelComboFieldEditor combo = new DiagnosticLevelComboFieldEditor(key, label1, label2, entries, this.getFieldEditorParent());
                    this.addField(combo);
                    IProject project = null;
                    if (this.isPropertyPage()) {
                        IResource res = this.getResource(this.getElement());
                        project = res.getProject();
                        try {
                            this.originalUse = project.getPersistentProperty(new QualifiedName(this.getOwnerId(), "useproject"));
                        }
                        catch (CoreException coreException) {}
                        if (this.originalUse == null) {
                            this.originalUse = Boolean.toString(this.getDefaultUseProject());
                        }
                    }
                    DiagnosticLevel level = ProjectDataManager.INSTANCE.getDiagnosticLevel(project, annotationName, parameterName, checkType.getType());
                    this.originalValues.put(key, level.getName());
                }
            }
        }
    }

    @Override
    public boolean performOk() {
        MessageDialog dialog;
        int response;
        super.performOk();
        if (this.hasChanged() && (response = (dialog = new MessageDialog(this.getShell(), "Annotation Parameter Check Diagnostic Level Changed", null, "The annotation parameter check diagnostic levels have changed. A rebuild of the project is required for changes to take effect. Build the project now?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open()) == 0) {
            if (this.isPropertyPage()) {
                CoreUtility.getBuildJob((IProject)((IProject)this.getResource(this.getElement()))).schedule();
            } else {
                CoreUtility.getBuildJob(null).schedule();
            }
        }
        return true;
    }

    private boolean hasChanged() {
        for (FieldEditor editor : this.getFieldEditors()) {
            String originalValue;
            IPreferenceStore store = editor.getPreferenceStore();
            String value = store.getString(editor.getPreferenceName());
            if (value.equals(originalValue = this.originalValues.get(editor.getPreferenceName()))) continue;
            return true;
        }
        if (this.isPropertyPage()) {
            IProject project = this.getResource(this.getElement()).getProject();
            String use = null;
            try {
                use = project.getPersistentProperty(new QualifiedName(this.getOwnerId(), "useproject"));
            }
            catch (CoreException coreException) {}
            if (use == null) {
                use = Boolean.toString(this.getDefaultUseProject());
            }
            if (!this.originalUse.equals(use)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public IPropertyChangedListener getPropertyChangedListener() {
        return ProjectDataManager.INSTANCE.getPropertyChangedListener();
    }
}

