/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.sms.storage.replication.GroupInfo;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.vm.DefinedProfileSpec;
import com.vmware.vim.binding.vim.vm.ProfileSpec;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.replication.ReplicationGroupId;
import com.vmware.vim.binding.vim.vm.replication.ReplicationSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.sms.spec.SourceGroupQuerySpec;
import com.vmware.vsphere.client.h5.vm.model.VmNetworkAdapterNetworkMatch;
import com.vmware.vsphere.client.h5.vm.model.migration.VmMigrationScheduledTaskEditDefaultsData;
import com.vmware.vsphere.client.h5.vm.model.migration.VmMigrationScheduledTaskEditDefaultsValidationSpec;
import com.vmware.vsphere.client.h5.vm.model.provisioning.VmCreateScheduledTaskEditDefaultsData;
import com.vmware.vsphere.client.h5.vm.model.provisioning.VmCreateScheduledTaskEditDefaultsValidationSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VmScheduledTasksValidationProvider
implements MutationProvider {
    private static final String PARENT_PROPERTY = "parent";
    private static final String COMPUTE_RESOURCE_PROPERTY = "computeResource";
    private static final String OWNER_PROPERTY = "owner";
    private static final String OPAQUE_NETWORK_PROPERTY = "summary/opaqueNetworkType";
    private static final String OPAQUE_NETWORK_ID_PROPERTY = "summary/opaqueNetworkId";
    private static final String REPLICATION_GROUP_INFO_PROPERTY = "replicationGroupSourceGroupInfo";
    private static final String SERVER_GUID_PROPERTY = "serverGuid";
    private static final String DVS_UID_PROPERTY = "dvsUuid";
    private static final String NAME_PROPERTY = "name";
    private static final String KEY_PROPERTY = "key";
    private static final String RESOURCE_POOL_PROPERTY = "resourcePool";
    private static final String HOST_PROPERTY = "host";
    private static final String VIRTUAL_DISKS_PROPERTY = "virtualDisks";
    private DataService _dataService;
    private QuerySpecBuilder _querySpecBuilder;

    public VmScheduledTasksValidationProvider(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    public ValidationResult validate(ManagedObjectReference vmRef, VmMigrationScheduledTaskEditDefaultsValidationSpec spec) throws Exception {
        String targetGuid;
        ValidationResult validationResult = new ValidationResult();
        VmMigrationScheduledTaskEditDefaultsData result = new VmMigrationScheduledTaskEditDefaultsData();
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        QuerySpec qs = this.createVmQuerySpec(vmRef);
        if (qs != null) {
            querySpecs.add(qs);
        }
        if ((qs = this.createPoolQuerySpec(spec.spec.pool)) != null) {
            querySpecs.add(qs);
        }
        if ((qs = this.createMatchingNetworkQuerySpec(vmRef, spec.spec.deviceChange, targetGuid = spec.spec.service == null || spec.spec.service.instanceUuid == null ? vmRef.getServerGuid() : spec.spec.service.instanceUuid)) != null) {
            querySpecs.add(qs);
        }
        LinkedHashMap<String, ReplicationGroupId> uniqueReplicationGroupIds = new LinkedHashMap<String, ReplicationGroupId>();
        qs = this.createReplicationGroupInfoQuerySpec(vmRef.getServerGuid(), spec.spec.deviceChange, spec.spec.disk, spec.spec.getProfile(), uniqueReplicationGroupIds);
        if (qs != null) {
            querySpecs.add(qs);
        }
        if ((qs = this.createHostQuerySpec(spec.spec.host)) != null) {
            querySpecs.add(qs);
        }
        Response response = null;
        if (!querySpecs.isEmpty()) {
            RequestSpec rs = new RequestSpec();
            rs.querySpec = querySpecs.toArray(new QuerySpec[0]);
            response = this._dataService.getData(rs);
        }
        result.migrationType = VmScheduledTasksValidationProvider.computeWorkflow(spec.spec);
        result.computeResource = VmScheduledTasksValidationProvider.computeSelectedComputeResource(spec.spec, VmScheduledTasksValidationProvider.getResultItems(response, ".vmQuerySpec"), VmScheduledTasksValidationProvider.getResultItems(response, ".poolQuerySpec"), VmScheduledTasksValidationProvider.getResultItems(response, ".hostQuerySpec"));
        result.networkMatches = VmScheduledTasksValidationProvider.computeNetworkMatches(vmRef, spec.spec.deviceChange, VmScheduledTasksValidationProvider.getResultItems(response, ".matchingNetworkQuerySpec"));
        result.movePriority = spec.movePriority;
        result.replicationGroupsData = VmScheduledTasksValidationProvider.buildReplicationDataData(VmScheduledTasksValidationProvider.getResultItems(response, ".replicationGroupsQuerySpec"), uniqueReplicationGroupIds);
        validationResult.result = result;
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference targetRef, VmCreateScheduledTaskEditDefaultsValidationSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        VmCreateScheduledTaskEditDefaultsData result = new VmCreateScheduledTaskEditDefaultsData();
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        QuerySpec qs = this.createPoolQuerySpecForCreateVm(spec.pool);
        if (qs != null) {
            querySpecs.add(qs);
        }
        if ((qs = this.createHostQuerySpec(spec.host)) != null) {
            querySpecs.add(qs);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])spec.datastoreNames) && (qs = this.createDatastoreQuerySpec(targetRef.getServerGuid(), spec.datastoreNames)) != null) {
            querySpecs.add(qs);
        }
        LinkedHashMap<String, ReplicationGroupId> uniqueReplicationGroupIds = new LinkedHashMap<String, ReplicationGroupId>();
        qs = this.createReplicationGroupInfoQuerySpec(targetRef.getServerGuid(), spec.deviceChange, spec.locators, spec.vmProfile, uniqueReplicationGroupIds);
        if (qs != null) {
            querySpecs.add(qs);
        }
        if (spec.vm != null && (qs = this.createVmQuerySpecForClone(spec.vm)) != null) {
            querySpecs.add(qs);
        }
        Response response = null;
        if (!querySpecs.isEmpty()) {
            RequestSpec rs = new RequestSpec();
            rs.querySpec = querySpecs.toArray(new QuerySpec[0]);
            response = this._dataService.getData(rs);
        }
        result.computeResource = VmScheduledTasksValidationProvider.computeSelectedComputeResource(spec, VmScheduledTasksValidationProvider.getResultItems(response, ".poolQuerySpecForCreateVm"), VmScheduledTasksValidationProvider.getResultItems(response, ".hostQuerySpec"));
        result.datastoreRefs = VmScheduledTasksValidationProvider.buildDatastoresData(VmScheduledTasksValidationProvider.getResultItems(response, ".matchingDatastoresQuerySpec"));
        result.guestOsId = VmScheduledTasksValidationProvider.retrieveGuestOsId(VmScheduledTasksValidationProvider.getResultItems(response, ".vmQuerySpecClone"));
        result.name = VmScheduledTasksValidationProvider.retrieveVmName(VmScheduledTasksValidationProvider.getResultItems(response, ".vmQuerySpecClone"));
        result.replicationGroupsData = VmScheduledTasksValidationProvider.buildReplicationDataData(VmScheduledTasksValidationProvider.getResultItems(response, ".replicationGroupsQuerySpec"), uniqueReplicationGroupIds);
        validationResult.result = result;
        return validationResult;
    }

    private QuerySpec createVmQuerySpec(ManagedObjectReference vm) {
        QuerySpec result = this._querySpecBuilder.buildQuerySpec((Object)vm, new String[]{VIRTUAL_DISKS_PROPERTY, HOST_PROPERTY, RESOURCE_POOL_PROPERTY});
        result.name = this.getClass().getSimpleName() + ".vmQuerySpec";
        return result;
    }

    private QuerySpec createVmQuerySpecForClone(ManagedObjectReference vm) {
        QuerySpec result = this._querySpecBuilder.buildQuerySpec((Object)vm, new String[]{"config.guestId", NAME_PROPERTY});
        result.name = this.getClass().getSimpleName() + ".vmQuerySpecClone";
        return result;
    }

    private QuerySpec createPoolQuerySpec(ManagedObjectReference specPool) {
        if (specPool == null) {
            return null;
        }
        QuerySpec result = this._querySpecBuilder.buildQuerySpec((Object)specPool, new String[]{PARENT_PROPERTY, OWNER_PROPERTY});
        result.name = this.getClass().getSimpleName() + ".poolQuerySpec";
        return result;
    }

    private QuerySpec createMatchingNetworkQuerySpec(ManagedObjectReference vm, VirtualDeviceSpec[] deviceChange, String targetVcServerGuid) {
        if (deviceChange == null) {
            return null;
        }
        Constraint networksConstraint = this.createNetworksConstraint(targetVcServerGuid, deviceChange);
        if (networksConstraint == null) {
            return null;
        }
        QuerySpec result = this._querySpecBuilder.buildQuerySpec(networksConstraint, new String[]{NAME_PROPERTY, KEY_PROPERTY, DVS_UID_PROPERTY, OPAQUE_NETWORK_ID_PROPERTY, OPAQUE_NETWORK_PROPERTY});
        result.name = this.getClass().getSimpleName() + ".matchingNetworkQuerySpec";
        return result;
    }

    private QuerySpec createReplicationGroupInfoQuerySpec(String serverGuid, VirtualDeviceSpec[] deviceChange, RelocateSpec.DiskLocator[] locators, ProfileSpec[] vmProfile, LinkedHashMap<String, ReplicationGroupId> uniqueReplicationGroupIds) {
        ArrayList<ReplicationGroupId> replicationGroupIds = new ArrayList<ReplicationGroupId>();
        this.addReplicationGroupId(vmProfile, replicationGroupIds);
        this.retrieveReplicationGroupIdsFromDeviceChange(deviceChange, replicationGroupIds);
        this.retrieveReplicationGroupIdsFromDiskLocators(locators, replicationGroupIds);
        for (ReplicationGroupId id : replicationGroupIds) {
            String stringId = id == null ? null : id.faultDomainId.id + ":" + id.deviceGroupId.id;
            if (stringId == null || uniqueReplicationGroupIds.containsKey(stringId)) continue;
            uniqueReplicationGroupIds.put(stringId, id);
        }
        if (uniqueReplicationGroupIds.isEmpty()) {
            return null;
        }
        SourceGroupQuerySpec spec = new SourceGroupQuerySpec();
        spec.replicationGroupIds = uniqueReplicationGroupIds.values().toArray(new ReplicationGroupId[0]);
        ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)serverGuid);
        QuerySpec result = this._querySpecBuilder.buildQuerySpec((Object)vcRef, new String[]{REPLICATION_GROUP_INFO_PROPERTY});
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = REPLICATION_GROUP_INFO_PROPERTY;
        paramSpec.parameter = spec;
        result.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{paramSpec};
        result.name = this.getClass().getSimpleName() + ".replicationGroupsQuerySpec";
        return result;
    }

    private void retrieveReplicationGroupIdsFromDeviceChange(VirtualDeviceSpec[] deviceChange, ArrayList<ReplicationGroupId> replicationGroupIds) {
        if (ArrayUtil.isNullOrEmpty((Object[])deviceChange)) {
            return;
        }
        for (VirtualDeviceSpec deviceSpec : deviceChange) {
            VirtualDevice device = deviceSpec.device;
            if (!(device instanceof VirtualDisk)) continue;
            ProfileSpec[] profiles = deviceSpec.getProfile();
            this.addReplicationGroupId(profiles, replicationGroupIds);
        }
    }

    private void retrieveReplicationGroupIdsFromDiskLocators(RelocateSpec.DiskLocator[] locators, ArrayList<ReplicationGroupId> replicationGroupIds) {
        if (ArrayUtil.isNullOrEmpty((Object[])locators)) {
            return;
        }
        for (RelocateSpec.DiskLocator locator : locators) {
            ProfileSpec[] profiles = locator.getProfile();
            this.addReplicationGroupId(profiles, replicationGroupIds);
        }
    }

    private void addReplicationGroupId(ProfileSpec[] profiles, ArrayList<ReplicationGroupId> replicationGroupIds) {
        ReplicationSpec replicationSpec;
        ProfileSpec profile;
        if (!ArrayUtil.isNullOrEmpty((Object[])profiles) && (profile = profiles[0]) instanceof DefinedProfileSpec && (replicationSpec = ((DefinedProfileSpec)profile).getReplicationSpec()) != null) {
            replicationGroupIds.add(replicationSpec.getReplicationGroupId());
        }
    }

    private QuerySpec createPoolQuerySpecForCreateVm(ManagedObjectReference pool) {
        if (pool == null) {
            return null;
        }
        QuerySpec result = this._querySpecBuilder.buildQuerySpec((Object)pool, new String[]{PARENT_PROPERTY, COMPUTE_RESOURCE_PROPERTY});
        result.name = this.getClass().getSimpleName() + ".poolQuerySpecForCreateVm";
        return result;
    }

    private QuerySpec createHostQuerySpec(ManagedObjectReference host) {
        if (host == null) {
            return null;
        }
        QuerySpec result = this._querySpecBuilder.buildQuerySpec((Object)host, new String[]{PARENT_PROPERTY});
        result.name = this.getClass().getSimpleName() + ".hostQuerySpec";
        return result;
    }

    private QuerySpec createDatastoreQuerySpec(String serverGuid, String[] datastoreNames) {
        if (datastoreNames == null) {
            return null;
        }
        ArrayList<CompositeConstraint> allConstraints = new ArrayList<CompositeConstraint>();
        for (String name : datastoreNames) {
            Pattern datastoreRegExp = Pattern.compile("\\[(.*)\\]");
            Matcher matcher = datastoreRegExp.matcher(name);
            String extractedName = null;
            if (matcher.find() && matcher.groupCount() > 0) {
                extractedName = matcher.group(1);
            }
            if (extractedName == null) continue;
            PropertyConstraint nameConstraint = this._querySpecBuilder.createPropertyConstraint(Datastore.class.getSimpleName(), NAME_PROPERTY, Comparator.EQUALS, (Object)extractedName);
            PropertyConstraint instanceConstraint = this._querySpecBuilder.createPropertyConstraint(Datastore.class.getSimpleName(), SERVER_GUID_PROPERTY, Comparator.EQUALS, (Object)serverGuid);
            CompositeConstraint networkConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{nameConstraint, instanceConstraint}, Conjoiner.AND);
            allConstraints.add(networkConstraint);
        }
        if (allConstraints.isEmpty()) {
            return null;
        }
        CompositeConstraint datastreConstraint = this._querySpecBuilder.createCompositeConstraint(allConstraints.toArray(new Constraint[0]), Conjoiner.OR);
        QuerySpec result = this._querySpecBuilder.buildQuerySpec((Constraint)datastreConstraint, new String[]{NAME_PROPERTY});
        result.name = this.getClass().getSimpleName() + ".matchingDatastoresQuerySpec";
        return result;
    }

    private static ResultItem[] getResultItems(Response response, String querySpecNameSuffix) {
        if (response == null || response.resultSet == null) {
            return new ResultItem[0];
        }
        for (ResultSet rs : response.resultSet) {
            if (rs.queryName == null || !rs.queryName.endsWith(querySpecNameSuffix)) continue;
            return rs.items != null ? rs.items : new ResultItem[]{};
        }
        return new ResultItem[0];
    }

    private Constraint createNetworksConstraint(String serverGuid, VirtualDeviceSpec[] deviceChange) {
        if (deviceChange == null) {
            return null;
        }
        ArrayList<CompositeConstraint> allConstraints = new ArrayList<CompositeConstraint>();
        for (VirtualDeviceSpec deviceSpec : deviceChange) {
            PropertyConstraint instanceConstraint;
            VirtualDevice device = deviceSpec.device;
            if (!(device instanceof VirtualEthernetCard)) continue;
            if (device.backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
                VirtualEthernetCard.NetworkBackingInfo networkBacking = (VirtualEthernetCard.NetworkBackingInfo)device.backing;
                PropertyConstraint nameConstraint = this._querySpecBuilder.createPropertyConstraint(Network.class.getSimpleName(), NAME_PROPERTY, Comparator.EQUALS, (Object)networkBacking.deviceName);
                PropertyConstraint instanceConstraint2 = this._querySpecBuilder.createPropertyConstraint(Network.class.getSimpleName(), SERVER_GUID_PROPERTY, Comparator.EQUALS, (Object)serverGuid);
                CompositeConstraint networkConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{nameConstraint, instanceConstraint2}, Conjoiner.AND);
                allConstraints.add(networkConstraint);
            }
            if (device.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
                VirtualEthernetCard.DistributedVirtualPortBackingInfo dvpBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing;
                PropertyConstraint keyConstraint = this._querySpecBuilder.createPropertyConstraint(DistributedVirtualPortgroup.class.getSimpleName(), KEY_PROPERTY, Comparator.EQUALS, (Object)dvpBacking.port.portgroupKey);
                PropertyConstraint switchUuidConstraint = this._querySpecBuilder.createPropertyConstraint(DistributedVirtualPortgroup.class.getSimpleName(), DVS_UID_PROPERTY, Comparator.EQUALS, (Object)dvpBacking.port.switchUuid);
                instanceConstraint = this._querySpecBuilder.createPropertyConstraint(DistributedVirtualPortgroup.class.getSimpleName(), SERVER_GUID_PROPERTY, Comparator.EQUALS, (Object)serverGuid);
                CompositeConstraint dvpgConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{keyConstraint, switchUuidConstraint, instanceConstraint}, Conjoiner.AND);
                allConstraints.add(dvpgConstraint);
            }
            if (!(device.backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo)) continue;
            VirtualEthernetCard.OpaqueNetworkBackingInfo opaqueBacking = (VirtualEthernetCard.OpaqueNetworkBackingInfo)device.backing;
            PropertyConstraint idConstraint = this._querySpecBuilder.createPropertyConstraint(OpaqueNetwork.class.getSimpleName(), OPAQUE_NETWORK_ID_PROPERTY, Comparator.EQUALS, (Object)opaqueBacking.opaqueNetworkId);
            PropertyConstraint typeConstraint = this._querySpecBuilder.createPropertyConstraint(OpaqueNetwork.class.getSimpleName(), OPAQUE_NETWORK_PROPERTY, Comparator.EQUALS, (Object)opaqueBacking.opaqueNetworkType);
            instanceConstraint = this._querySpecBuilder.createPropertyConstraint(OpaqueNetwork.class.getSimpleName(), SERVER_GUID_PROPERTY, Comparator.EQUALS, (Object)serverGuid);
            CompositeConstraint opaqueConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{idConstraint, typeConstraint, instanceConstraint}, Conjoiner.AND);
            allConstraints.add(opaqueConstraint);
        }
        if (allConstraints.isEmpty()) {
            return null;
        }
        return this._querySpecBuilder.createCompositeConstraint(allConstraints.toArray(new Constraint[0]), Conjoiner.OR);
    }

    private static String computeWorkflow(RelocateSpec spec) {
        if (spec.pool == null) {
            return "changeStorageOnly";
        }
        if (spec.datastore == null && spec.disk == null) {
            return "changeResourceOnly";
        }
        return "changeComputeResourceAndStorage";
    }

    private static ManagedObjectReference computeSelectedComputeResource(RelocateSpec spec, ResultItem[] vmData, ResultItem[] poolData, ResultItem[] hostData) {
        ManagedObjectReference vmDataResourcePool = (ManagedObjectReference)VmScheduledTasksValidationProvider.getPropertyValue(vmData, RESOURCE_POOL_PROPERTY);
        ManagedObjectReference poolDataParent = (ManagedObjectReference)VmScheduledTasksValidationProvider.getPropertyValue(poolData, PARENT_PROPERTY);
        ManagedObjectReference hostParent = (ManagedObjectReference)VmScheduledTasksValidationProvider.getPropertyValue(hostData, PARENT_PROPERTY);
        if (spec.pool != null && spec.pool.equals((Object)vmDataResourcePool) || poolDataParent == null) {
            return spec.host;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)poolDataParent, ClusterComputeResource.class)) {
            if (poolDataParent.equals((Object)hostParent)) {
                return spec.host;
            }
            return poolDataParent;
        }
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)poolDataParent, ComputeResource.class)) {
            return spec.pool;
        }
        return spec.host;
    }

    private static List<VmNetworkAdapterNetworkMatch> computeNetworkMatches(ManagedObjectReference vmRef, VirtualDeviceSpec[] deviceChange, ResultItem[] prefetchedNetworkResultItems) {
        if (deviceChange == null) {
            return new ArrayList<VmNetworkAdapterNetworkMatch>();
        }
        ArrayList<VmNetworkAdapterNetworkMatch> networkMatches = new ArrayList<VmNetworkAdapterNetworkMatch>();
        for (VirtualDeviceSpec deviceSpec : deviceChange) {
            Pair<ManagedObjectReference, String> value;
            VirtualDevice device = deviceSpec.device;
            if (!(device instanceof VirtualEthernetCard)) continue;
            boolean destinationNetworkExists = false;
            VmNetworkAdapterNetworkMatch networkMatch = new VmNetworkAdapterNetworkMatch();
            networkMatch.sourceAdapter = (VirtualEthernetCard)deviceSpec.device;
            networkMatch.sourceVm = vmRef;
            if (device.backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
                VirtualEthernetCard.NetworkBackingInfo networkBacking = (VirtualEthernetCard.NetworkBackingInfo)device.backing;
                value = VmScheduledTasksValidationProvider.findNetworkReferenceForStdNetwork(networkBacking.deviceName, prefetchedNetworkResultItems);
                boolean bl = destinationNetworkExists = value != null;
                if (destinationNetworkExists) {
                    networkMatch.destinationNetwork = (ManagedObjectReference)value.first;
                    networkMatch.destinationNetworkName = (String)value.second;
                }
            }
            if (device.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
                VirtualEthernetCard.DistributedVirtualPortBackingInfo dvpBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing;
                value = VmScheduledTasksValidationProvider.findNetworkReferenceForDvpg(dvpBacking.port.switchUuid, prefetchedNetworkResultItems);
                boolean bl = destinationNetworkExists = value != null;
                if (destinationNetworkExists) {
                    networkMatch.destinationPortgroupKey = dvpBacking.port.portgroupKey;
                    networkMatch.destinationSwitchUuid = dvpBacking.port.switchUuid;
                    networkMatch.destinationNetwork = (ManagedObjectReference)value.first;
                    networkMatch.destinationNetworkName = (String)value.second;
                }
            }
            if (device.backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo) {
                VirtualEthernetCard.OpaqueNetworkBackingInfo opaqueBacking = (VirtualEthernetCard.OpaqueNetworkBackingInfo)device.backing;
                value = VmScheduledTasksValidationProvider.findNetworkReferenceForOpaqueNetwork(opaqueBacking.opaqueNetworkId, opaqueBacking.opaqueNetworkType, prefetchedNetworkResultItems);
                boolean bl = destinationNetworkExists = value != null;
                if (destinationNetworkExists) {
                    networkMatch.destinationOpaqueId = opaqueBacking.opaqueNetworkId;
                    networkMatch.destinationOpaqueType = opaqueBacking.opaqueNetworkType;
                    networkMatch.destinationNetwork = (ManagedObjectReference)value.first;
                    networkMatch.destinationNetworkName = (String)value.second;
                }
            }
            if (!destinationNetworkExists) continue;
            networkMatches.add(networkMatch);
        }
        return networkMatches;
    }

    private static Pair<ManagedObjectReference, String> findNetworkReferenceForStdNetwork(String name, ResultItem[] prefetchedNetworkResultItems) {
        if (name == null || prefetchedNetworkResultItems == null) {
            return null;
        }
        for (ResultItem resultItem : prefetchedNetworkResultItems) {
            if (!name.equals(VmScheduledTasksValidationProvider.getPropertyValue(resultItem, NAME_PROPERTY))) continue;
            return new Pair((Object)((ManagedObjectReference)resultItem.resourceObject), (Object)((String)VmScheduledTasksValidationProvider.getPropertyValue(resultItem, NAME_PROPERTY)));
        }
        return null;
    }

    private static Pair<ManagedObjectReference, String> findNetworkReferenceForDvpg(String switchUuid, ResultItem[] prefetchedNetworkResultItems) {
        if (prefetchedNetworkResultItems == null) {
            return null;
        }
        for (ResultItem resultItem : prefetchedNetworkResultItems) {
            if (!switchUuid.equals(VmScheduledTasksValidationProvider.getPropertyValue(resultItem, DVS_UID_PROPERTY))) continue;
            return new Pair((Object)((ManagedObjectReference)resultItem.resourceObject), (Object)((String)VmScheduledTasksValidationProvider.getPropertyValue(resultItem, NAME_PROPERTY)));
        }
        return null;
    }

    private static Pair<ManagedObjectReference, String> findNetworkReferenceForOpaqueNetwork(String opaqueNetworkId, String opaqueNetworkType, ResultItem[] prefetchedNetworkResultItems) {
        if (prefetchedNetworkResultItems == null) {
            return null;
        }
        for (ResultItem resultItem : prefetchedNetworkResultItems) {
            if (!opaqueNetworkId.equals(VmScheduledTasksValidationProvider.getPropertyValue(resultItem, OPAQUE_NETWORK_ID_PROPERTY)) || !opaqueNetworkType.equals(VmScheduledTasksValidationProvider.getPropertyValue(resultItem, OPAQUE_NETWORK_PROPERTY))) continue;
            return new Pair((Object)((ManagedObjectReference)resultItem.resourceObject), (Object)((String)VmScheduledTasksValidationProvider.getPropertyValue(resultItem, NAME_PROPERTY)));
        }
        return null;
    }

    private static ManagedObjectReference computeSelectedComputeResource(VmCreateScheduledTaskEditDefaultsValidationSpec spec, ResultItem[] poolData, ResultItem[] hostData) {
        ManagedObjectReference rsPoolParent = (ManagedObjectReference)VmScheduledTasksValidationProvider.getPropertyValue(poolData, PARENT_PROPERTY);
        ManagedObjectReference rsPoolParentCR = (ManagedObjectReference)VmScheduledTasksValidationProvider.getPropertyValue(poolData, COMPUTE_RESOURCE_PROPERTY);
        ManagedObjectReference hostParent = (ManagedObjectReference)VmScheduledTasksValidationProvider.getPropertyValue(hostData, PARENT_PROPERTY);
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)rsPoolParentCR, ClusterComputeResource.class)) {
            if (hostParent != null && hostParent.equals((Object)rsPoolParent)) {
                return spec.host;
            }
            if (rsPoolParent != null && rsPoolParent.equals((Object)rsPoolParentCR)) {
                return rsPoolParent;
            }
            return spec.pool;
        }
        if (rsPoolParentCR != null && rsPoolParent != null && rsPoolParentCR.equals((Object)rsPoolParent)) {
            return spec.host;
        }
        return spec.pool;
    }

    private static HashMap<String, ManagedObjectReference> buildDatastoresData(ResultItem[] datastoresResultItems) {
        if (datastoresResultItems == null) {
            return null;
        }
        HashMap<String, ManagedObjectReference> datastoreMatches = new HashMap<String, ManagedObjectReference>();
        for (ResultItem resultItem : datastoresResultItems) {
            String name = (String)VmScheduledTasksValidationProvider.getPropertyValue(resultItem, NAME_PROPERTY);
            datastoreMatches.put(name, (ManagedObjectReference)resultItem.resourceObject);
        }
        return datastoreMatches;
    }

    private static String retrieveGuestOsId(ResultItem[] vmResultItems) {
        if (ArrayUtil.isNullOrEmpty((Object[])vmResultItems)) {
            return null;
        }
        return (String)VmScheduledTasksValidationProvider.getPropertyValue(vmResultItems[0], "config.guestId");
    }

    private static String retrieveVmName(ResultItem[] vmResultItems) {
        if (ArrayUtil.isNullOrEmpty((Object[])vmResultItems)) {
            return null;
        }
        return (String)VmScheduledTasksValidationProvider.getPropertyValue(vmResultItems[0], NAME_PROPERTY);
    }

    private static <T> T getPropertyValue(ResultItem[] items, String propertyName) {
        if (items == null || items.length == 0) {
            return null;
        }
        for (ResultItem ri : items) {
            T r = VmScheduledTasksValidationProvider.getPropertyValue(ri, propertyName);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static <T> T getPropertyValue(ResultItem ri, String propertyName) {
        if (ri.properties == null) {
            return null;
        }
        for (PropertyValue pv : ri.properties) {
            if (!propertyName.equals(pv.propertyName)) continue;
            return (T)pv.value;
        }
        return null;
    }

    private static HashMap<String, GroupInfo> buildReplicationDataData(ResultItem[] replicationGroupItems, LinkedHashMap<String, ReplicationGroupId> uniqueReplicationGroupIds) {
        if (ArrayUtil.isNullOrEmpty((Object[])replicationGroupItems)) {
            return null;
        }
        if (uniqueReplicationGroupIds.isEmpty()) {
            return null;
        }
        String[] replicationGroupIds = uniqueReplicationGroupIds.keySet().toArray(new String[0]);
        HashMap<String, GroupInfo> replicationGroupMatches = new HashMap<String, GroupInfo>();
        GroupInfo[] groupInfo = (GroupInfo[])VmScheduledTasksValidationProvider.getPropertyValue(replicationGroupItems[0], REPLICATION_GROUP_INFO_PROPERTY);
        int i = 0;
        for (String id : replicationGroupIds) {
            if (i >= groupInfo.length) continue;
            replicationGroupMatches.put(id, groupInfo[i]);
            ++i;
        }
        return replicationGroupMatches;
    }
}

