/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.impl.VmNetworkSelectorMatcherService;
import com.vmware.vsphere.client.h5.vm.model.VmNetworkAdapterNetworkMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmNetworkSelectorPropertyProvider
implements PropertyProviderBean {
    private static final int CHUNK_SIZE = 4096;
    static final String NAME_PROPERTY = "name";
    static final String OPAQUE_NETWORK_TYPE_PROPERTY = "summary[@type='OpaqueNetworkSummary'].opaqueNetworkType";
    static final String OPAQUE_NETWORK_ID_PROPERTY = "summary[@type='OpaqueNetworkSummary'].opaqueNetworkId";
    static final String IS_UPLINK_PORT_GROUP_PROPERTY = "isUplinkPortgroup";
    static final String DVPG_KEY_PROPERTY = "key";
    static final String DVPG_DVS_UUID_PROPERTY = "dvsUuid";
    static final String VM_DEVICES_PROPERTY = "config.hardware.device";
    private static final String[] STD_NETWORK_PROPERTIES = new String[]{"name"};
    private static final String[] OPAQUE_NETWORK_PROPERTIES = new String[]{"name", "summary[@type='OpaqueNetworkSummary'].opaqueNetworkType", "summary[@type='OpaqueNetworkSummary'].opaqueNetworkId"};
    private static final String[] DVPG_SOURCE_NETWORK_PROPERTIES = new String[]{"name", "key"};
    private static final String[] DVPG_DESTINATION_NETWORK_PROPERTIES = new String[]{"name", "key", "dvsUuid"};
    private static final String VM_NETWORK_RELATION = "allNetwork";
    private static final String ANY_NETWORK_TYPE = "AnyNetwork";
    private static Log _logger = LogFactory.getLog(VmNetworkSelectorPropertyProvider.class);
    private final DataService _dataService;
    private final VmNetworkSelectorMatcherService _networkSelectorMatcherService;

    public VmNetworkSelectorPropertyProvider(DataService dataService, VmNetworkSelectorMatcherService networkSelectorMatcherService) {
        this._dataService = dataService;
        this._networkSelectorMatcherService = networkSelectorMatcherService;
    }

    @type(value="HostSystem,ClusterComputeResource")
    public VmNetworkAdapterNetworkMatch[] getDestinationNetworksForMigrateVms(ManagedObjectReference destination, Object[] vms) throws Exception {
        Object[] vmRefs = (ManagedObjectReference[])ArrayUtil.getTypedArray((Object[])vms, ManagedObjectReference.class);
        if (ArrayUtil.isNullOrEmpty((Object[])vmRefs)) {
            return new VmNetworkAdapterNetworkMatch[0];
        }
        HashMap<String, ManagedObjectReference> networksByKey = new HashMap<String, ManagedObjectReference>();
        ArrayList<Object> sourceNetworks = new ArrayList<Object>();
        QuerySpec sourceNetworksQuerySpec = this.getSourceNetworkDataQuerySpec((ManagedObjectReference[])vmRefs);
        QuerySpec adaptersDataForVmsQuerySpec = this.getAdaptersDataForVmsQuerySpec((ManagedObjectReference[])vmRefs);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{sourceNetworksQuerySpec, adaptersDataForVmsQuerySpec};
        Response response = new Response();
        response = this._dataService.getData(requestSpec);
        ResultSet[] retVal = response.resultSet;
        if (retVal == null || retVal.length == 0 || retVal[0] == null) {
            throw new Exception(Utils.getLocalizedString((String)"error.emptyResult"));
        }
        this.populateSourceNetworkData(retVal[0], networksByKey, sourceNetworks);
        List<VmNetworkAdapterNetworkMatch> matches = this.getAdaptersDataForVms(retVal[1], networksByKey);
        List<NetworkData> sourceNetworksData = this.getNetworkSelectorFilteredNetworksByRefs(sourceNetworks.toArray(new Object[sourceNetworks.size()]), true);
        List<String> sourceNetworkNames = VmNetworkSelectorPropertyProvider.getNetworkNames(sourceNetworksData);
        Object[] matchedDestinationNetworks = this._networkSelectorMatcherService.getMatchingNetworks(destination, sourceNetworkNames);
        List<NetworkData> destinationNetworksData = this.getNetworkSelectorFilteredNetworksByRefs(matchedDestinationNetworks, false);
        if (matchedDestinationNetworks.length != sourceNetworkNames.size()) {
            ArrayList<String> destNetworksNames = new ArrayList<String>();
            for (NetworkData network : destinationNetworksData) {
                destNetworksNames.add(network.name);
            }
            _logger.info((Object)String.format("Cannot match all source networks!\n--> computeResource = %s,\n--> sourceNetworkNames = %s,\n--> machingDestinationNetworks = %s,\n--> matchingDestinationNetworkNames = %s", destination.toString(), ObjectUtil.prettyPrint(sourceNetworkNames), ObjectUtil.prettyPrint((Object)matchedDestinationNetworks), ObjectUtil.prettyPrint(destNetworksNames)));
        }
        NetworkMatchFactory networkMatchFactory = new NetworkMatchFactory(destinationNetworksData);
        NetworkMatch[] networkMatches = new NetworkMatch[sourceNetworksData.size()];
        for (int index = 0; index < networkMatches.length; ++index) {
            networkMatches[index] = networkMatchFactory.newNetworkMatch(sourceNetworksData.get(index));
        }
        HashMap<ManagedObjectReference, ManagedObjectReference> destinationNetworkBySource = new HashMap<ManagedObjectReference, ManagedObjectReference>(networkMatches.length);
        for (NetworkMatch networkMatch : networkMatches) {
            destinationNetworkBySource.put(networkMatch.source, networkMatch.destination);
        }
        this.populateDestinationNetworkData(matches, destinationNetworkBySource, sourceNetworksData, destinationNetworksData);
        return matches.toArray(new VmNetworkAdapterNetworkMatch[matches.size()]);
    }

    private String getNetworkKey(ManagedObjectReference networkMor, PropertyValue[] properties) {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)networkMor, DistributedVirtualPortgroup.class)) {
            for (PropertyValue pv : properties) {
                if (!DVPG_KEY_PROPERTY.equals(pv.propertyName)) continue;
                return (String)pv.value;
            }
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)networkMor, OpaqueNetwork.class)) {
            String opaqueNetworkId = null;
            String opaqueNetworkType = null;
            for (PropertyValue pv : properties) {
                if (OPAQUE_NETWORK_ID_PROPERTY.equals(pv.propertyName)) {
                    opaqueNetworkId = (String)pv.value;
                    continue;
                }
                if (!OPAQUE_NETWORK_TYPE_PROPERTY.equals(pv.propertyName)) continue;
                opaqueNetworkType = (String)pv.value;
            }
            return VmNetworkSelectorPropertyProvider.getOpaqueNetworkKey(opaqueNetworkId, opaqueNetworkType);
        }
        return null;
    }

    private QuerySpec getSourceNetworkDataQuerySpec(ManagedObjectReference[] vmRefs) {
        CompositeConstraint sourceNetworksConstraint = new CompositeConstraint();
        sourceNetworksConstraint.conjoiner = Conjoiner.OR;
        sourceNetworksConstraint.targetType = ANY_NETWORK_TYPE;
        sourceNetworksConstraint.nestedConstraints = new Constraint[vmRefs.length];
        for (int i = 0; i < vmRefs.length; ++i) {
            Constraint networkRelation;
            ManagedObjectReference vmRef = vmRefs[i];
            sourceNetworksConstraint.nestedConstraints[i] = networkRelation = QueryUtil.createConstraintForRelationship((Object)vmRef, (String)VM_NETWORK_RELATION, (String)ANY_NETWORK_TYPE);
        }
        QuerySpec sourceNetworksQuerySpec = QueryUtil.buildQuerySpec((Constraint)sourceNetworksConstraint, (String[])new String[]{DVPG_KEY_PROPERTY, OPAQUE_NETWORK_ID_PROPERTY, OPAQUE_NETWORK_TYPE_PROPERTY});
        return sourceNetworksQuerySpec;
    }

    private void populateSourceNetworkData(ResultSet sourceNetworksResultSet, Map<String, ManagedObjectReference> networksByPortgroupKey, List<Object> sourceNetworks) {
        for (ResultItem sourceNetworkItem : sourceNetworksResultSet.items) {
            ManagedObjectReference mor;
            String networkKey;
            sourceNetworks.add(sourceNetworkItem.resourceObject);
            if (!(sourceNetworkItem.resourceObject instanceof ManagedObjectReference) || (networkKey = this.getNetworkKey(mor = (ManagedObjectReference)sourceNetworkItem.resourceObject, sourceNetworkItem.properties)) == null) continue;
            networksByPortgroupKey.put(networkKey, mor);
        }
    }

    private QuerySpec getAdaptersDataForVmsQuerySpec(ManagedObjectReference[] vmRefs) {
        QuerySpec sourceAdaptersQuerySpec = QueryUtil.buildQuerySpec((Object[])vmRefs, (String[])new String[]{VM_DEVICES_PROPERTY});
        return sourceAdaptersQuerySpec;
    }

    private List<VmNetworkAdapterNetworkMatch> getAdaptersDataForVms(ResultSet sourceAdaptersResultSet, Map<String, ManagedObjectReference> networksByPortgroupKey) {
        ArrayList<VmNetworkAdapterNetworkMatch> matches = new ArrayList<VmNetworkAdapterNetworkMatch>();
        for (ResultItem vmItem : sourceAdaptersResultSet.items) {
            VirtualDevice[] virtualDevices;
            if (ArrayUtil.isNullOrEmpty((Object[])vmItem.properties) || vmItem.properties[0] == null || !(vmItem.properties[0].value instanceof VirtualDevice[])) continue;
            for (VirtualDevice vmDevice : virtualDevices = (VirtualDevice[])vmItem.properties[0].value) {
                if (!(vmDevice instanceof VirtualEthernetCard)) continue;
                VmNetworkAdapterNetworkMatch match = new VmNetworkAdapterNetworkMatch();
                match.sourceAdapter = (VirtualEthernetCard)vmDevice;
                match.sourceVm = (ManagedObjectReference)vmItem.resourceObject;
                VirtualDevice.BackingInfo backing = vmDevice.backing;
                if (backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
                    match.sourceNetwork = ((VirtualEthernetCard.NetworkBackingInfo)backing).network;
                } else if (backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo) {
                    String opaqueNetKey = VmNetworkSelectorPropertyProvider.getOpaqueNetworkKey((VirtualEthernetCard.OpaqueNetworkBackingInfo)backing);
                    match.sourceNetwork = networksByPortgroupKey.get(opaqueNetKey);
                } else if (backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
                    String portgroupKey = ((VirtualEthernetCard.DistributedVirtualPortBackingInfo)backing).port.portgroupKey;
                    match.sourceNetwork = networksByPortgroupKey.get(portgroupKey);
                }
                matches.add(match);
            }
        }
        return matches;
    }

    private void populateDestinationNetworkData(List<VmNetworkAdapterNetworkMatch> matches, Map<ManagedObjectReference, ManagedObjectReference> destinationNetworkBySource, List<NetworkData> sourceNetworksData, List<NetworkData> destinationNetworksData) {
        HashMap<ManagedObjectReference, NetworkData> destinationNetworksDataByRef = new HashMap<ManagedObjectReference, NetworkData>(sourceNetworksData.size() + destinationNetworksData.size());
        for (NetworkData networkData : sourceNetworksData) {
            destinationNetworksDataByRef.put(networkData.network, networkData);
        }
        for (NetworkData networkData : destinationNetworksData) {
            destinationNetworksDataByRef.put(networkData.network, networkData);
        }
        for (VmNetworkAdapterNetworkMatch match : matches) {
            ManagedObjectReference destinationNetwork = destinationNetworkBySource.get(match.sourceNetwork);
            NetworkData networkData = null;
            if (destinationNetwork != null) {
                match.destinationNetwork = destinationNetwork;
                networkData = (NetworkData)destinationNetworksDataByRef.get(destinationNetwork);
            }
            if (networkData == null) continue;
            match.destinationNetworkName = networkData.name;
            match.destinationPortgroupKey = networkData.key;
            match.destinationSwitchUuid = networkData.dvsUuid;
            match.destinationOpaqueId = networkData.opaqueNetworkId;
            match.destinationOpaqueType = networkData.opaqueNetworkType;
        }
    }

    private List<NetworkData> getNetworkSelectorFilteredNetworksByRefs(Object[] networkRefs, boolean isSourceNetwork) {
        ManagedObjectReference[] standardNetworkRefs = VmNetworkSelectorPropertyProvider.getMorsOfType(networkRefs, Network.class.getSimpleName());
        ManagedObjectReference[] opaqueNetworkRefs = VmNetworkSelectorPropertyProvider.getMorsOfType(networkRefs, OpaqueNetwork.class.getSimpleName());
        ManagedObjectReference[] distributedPortGroupRefs = VmNetworkSelectorPropertyProvider.getMorsOfType(networkRefs, DistributedVirtualPortgroup.class.getSimpleName());
        Collection<NetworkData> standardNetworks = this.retrieveStandardNetworkProperties(standardNetworkRefs);
        Collection<NetworkData> opaqueNetworks = this.retrieveOpaqueNetworkProperties(opaqueNetworkRefs);
        Collection<NetworkData> distributedPortGroups = this.retrieveDistributedPortGroupPropertiesInChunks(distributedPortGroupRefs, 4096, isSourceNetwork);
        ArrayList<NetworkData> result = new ArrayList<NetworkData>(standardNetworks.size() + opaqueNetworks.size() + distributedPortGroups.size());
        result.addAll(standardNetworks);
        result.addAll(opaqueNetworks);
        result.addAll(distributedPortGroups);
        return result;
    }

    private Collection<NetworkData> retrieveDistributedPortGroupPropertiesInChunks(ManagedObjectReference[] portgroups, int chunkSize, boolean isSourceNetwork) {
        if (ArrayUtil.isNullOrEmpty((Object[])portgroups) || chunkSize <= 0) {
            return Collections.emptyList();
        }
        HashMap<ManagedObjectReference, NetworkData> portGroupsMap = new HashMap<ManagedObjectReference, NetworkData>();
        int numberOfChunks = (int)Math.ceil((double)portgroups.length / (double)chunkSize);
        for (int i = 0; i < numberOfChunks; ++i) {
            Object[] mors = i < numberOfChunks - 1 ? Arrays.copyOfRange(portgroups, chunkSize * i, chunkSize * i + chunkSize) : Arrays.copyOfRange(portgroups, chunkSize * i, portgroups.length);
            PropertyValue[] propertyValues = null;
            String[] propertiesToRetrieve = isSourceNetwork ? DVPG_SOURCE_NETWORK_PROPERTIES : DVPG_DESTINATION_NETWORK_PROPERTIES;
            try {
                propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])mors, (String[])propertiesToRetrieve);
            }
            catch (Exception e) {
                _logger.error((Object)"Retrieval of distributed network properties failed.", (Throwable)e);
            }
            this.updatePortGroupsMap(propertyValues, portGroupsMap);
        }
        return portGroupsMap.values();
    }

    private void updatePortGroupsMap(PropertyValue[] properties, Map<ManagedObjectReference, NetworkData> portGroupsMap) {
        if (!ArrayUtil.isNullOrEmpty((Object[])properties)) {
            for (PropertyValue pv : properties) {
                ManagedObjectReference pgRef = (ManagedObjectReference)pv.resourceObject;
                NetworkData networkData = portGroupsMap.get(pgRef);
                if (networkData == null) {
                    networkData = new NetworkData();
                    networkData.network = pgRef;
                    portGroupsMap.put(pgRef, networkData);
                }
                if (pv.propertyName.equals(NAME_PROPERTY) && pv.value instanceof String) {
                    networkData.name = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(DVPG_DVS_UUID_PROPERTY) && pv.value instanceof String) {
                    networkData.dvsUuid = (String)pv.value;
                    continue;
                }
                if (!DVPG_KEY_PROPERTY.equals(pv.propertyName) || !(pv.value instanceof String)) continue;
                networkData.key = (String)pv.value;
            }
        }
    }

    private Collection<NetworkData> retrieveStandardNetworkProperties(ManagedObjectReference[] networks) {
        if (ArrayUtil.isNullOrEmpty((Object[])networks)) {
            return Collections.emptyList();
        }
        Object[] propertyValues = null;
        try {
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])networks, (String[])STD_NETWORK_PROPERTIES);
        }
        catch (Exception e) {
            _logger.error((Object)"Retrieval of standard network properties failed.", (Throwable)e);
        }
        HashMap<String, NetworkData> standardNetworksData = new HashMap<String, NetworkData>();
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValues)) {
            return standardNetworksData.values();
        }
        for (Object pv : propertyValues) {
            if (((PropertyValue)pv).resourceObject == null || !(((PropertyValue)pv).resourceObject instanceof ManagedObjectReference)) continue;
            NetworkData networkData = (NetworkData)standardNetworksData.get(((PropertyValue)pv).resourceObject.toString());
            if (networkData == null) {
                networkData = new NetworkData();
                networkData.network = (ManagedObjectReference)((PropertyValue)pv).resourceObject;
                standardNetworksData.put(((PropertyValue)pv).resourceObject.toString(), networkData);
            }
            if (!NAME_PROPERTY.equals(((PropertyValue)pv).propertyName) || !(((PropertyValue)pv).value instanceof String)) continue;
            networkData.name = (String)((PropertyValue)pv).value;
        }
        return standardNetworksData.values();
    }

    private Collection<NetworkData> retrieveOpaqueNetworkProperties(ManagedObjectReference[] opaqueNetworks) {
        if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworks)) {
            return Collections.emptyList();
        }
        Object[] propertyValues = null;
        try {
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])opaqueNetworks, (String[])OPAQUE_NETWORK_PROPERTIES);
        }
        catch (Exception e) {
            _logger.error((Object)("Retrieval of opaque network properties failed:" + e.getLocalizedMessage()), (Throwable)e);
        }
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValues)) {
            return Collections.emptyList();
        }
        HashMap<String, NetworkData> opaqueNetworksData = new HashMap<String, NetworkData>();
        for (Object pv : propertyValues) {
            if (((PropertyValue)pv).resourceObject == null || !(((PropertyValue)pv).resourceObject instanceof ManagedObjectReference)) continue;
            NetworkData networkData = (NetworkData)opaqueNetworksData.get(((PropertyValue)pv).resourceObject.toString());
            if (networkData == null) {
                networkData = new NetworkData();
                networkData.network = (ManagedObjectReference)((PropertyValue)pv).resourceObject;
                opaqueNetworksData.put(((PropertyValue)pv).resourceObject.toString(), networkData);
            }
            networkData.initializeAsOpaqueNetwork((PropertyValue)pv);
        }
        return opaqueNetworksData.values();
    }

    private static ManagedObjectReference[] getMorsOfType(Object[] mors, String type2) {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        if (ArrayUtil.isNullOrEmpty((Object[])mors)) {
            return new ManagedObjectReference[0];
        }
        for (Object obj : mors) {
            ManagedObjectReference mor;
            if (!(obj instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)(mor = (ManagedObjectReference)obj), (String)type2)) continue;
            result.add(mor);
        }
        return result.toArray(new ManagedObjectReference[result.size()]);
    }

    private static String getOpaqueNetworkKey(String opaqueNetworkId, String opaqueNetworkType) {
        if (StringUtil.isNullOrEmpty((String)opaqueNetworkId) || StringUtil.isNullOrEmpty((String)opaqueNetworkType)) {
            throw new IllegalArgumentException("Empty opaque network id/type detected.");
        }
        return opaqueNetworkType + "/" + opaqueNetworkId;
    }

    private static String getOpaqueNetworkKey(VirtualEthernetCard.OpaqueNetworkBackingInfo info) {
        return VmNetworkSelectorPropertyProvider.getOpaqueNetworkKey(info.opaqueNetworkId, info.opaqueNetworkType);
    }

    private static List<String> getNetworkNames(List<NetworkData> networksData) {
        ArrayList<String> networkNames = new ArrayList<String>(networksData.size());
        for (NetworkData networkData : networksData) {
            networkNames.add(networkData.name);
        }
        return networkNames;
    }

    private static class NetworkMatchFactory {
        private final HashMap<String, List<ManagedObjectReference>> networksByName = new HashMap();

        public NetworkMatchFactory(List<NetworkData> networks) {
            this.initializeNetworksMap(networks);
        }

        private void initializeNetworksMap(List<NetworkData> networks) {
            for (NetworkData networkData : networks) {
                List<ManagedObjectReference> networkMorefs = this.networksByName.get(networkData.name);
                if (networkMorefs == null) {
                    networkMorefs = new ArrayList<ManagedObjectReference>();
                    this.networksByName.put(networkData.name, networkMorefs);
                }
                networkMorefs.add(networkData.network);
            }
        }

        public NetworkMatch newNetworkMatch(NetworkData networkData) {
            List<ManagedObjectReference> destinationNetworks = this.networksByName.get(networkData.name);
            if (destinationNetworks == null) {
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)networkData.network, Network.class)) {
                    return new NetworkMatch(networkData.network, networkData.network);
                }
                if (this.networksByName.size() == 1 && this.networksByName.values().iterator().next().size() == 1) {
                    return new NetworkMatch(networkData.network, this.networksByName.values().iterator().next().get(0));
                }
                return new NetworkMatch(networkData.network, null);
            }
            ManagedObjectReference destinationNetworkMoref = null;
            for (ManagedObjectReference mor : destinationNetworks) {
                if (!mor.equals((Object)networkData.network)) continue;
                destinationNetworkMoref = mor;
                break;
            }
            if (destinationNetworkMoref != null) {
                return new NetworkMatch(networkData.network, destinationNetworkMoref);
            }
            return new NetworkMatch(networkData.network, destinationNetworks.get(0));
        }
    }

    private static class NetworkMatch {
        private static final long serialVersionUID = 1L;
        public ManagedObjectReference source;
        public ManagedObjectReference destination;

        public NetworkMatch(ManagedObjectReference sourceNetwork, ManagedObjectReference destinationNetwork) {
            this.source = sourceNetwork;
            this.destination = destinationNetwork;
        }
    }

    private static class NetworkData {
        public ManagedObjectReference network;
        public String name;
        public String key;
        public String dvsUuid;
        public String opaqueNetworkId;
        public String opaqueNetworkType;

        private NetworkData() {
        }

        void initializeAsOpaqueNetwork(PropertyValue pv) {
            if (VmNetworkSelectorPropertyProvider.NAME_PROPERTY.equals(pv.propertyName)) {
                this.name = (String)pv.value;
            } else if (VmNetworkSelectorPropertyProvider.OPAQUE_NETWORK_ID_PROPERTY.equals(pv.propertyName)) {
                this.opaqueNetworkId = (String)pv.value;
            } else if (VmNetworkSelectorPropertyProvider.OPAQUE_NETWORK_TYPE_PROPERTY.equals(pv.propertyName)) {
                this.opaqueNetworkType = (String)pv.value;
            }
        }
    }
}

