/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.GuestOsDescriptor;
import com.vmware.vim.binding.vim.vm.NetworkInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceOption;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.data.VmConfigEnvironmentData;
import com.vmware.vsphere.client.h5.vm.model.provisioning.VmConfigEnvironmentPerPoolParams;
import com.vmware.vsphere.client.ippool.util.IpPoolUtil;
import com.vmware.vsphere.client.ippool.vapp.VAppIpPoolData;
import java.util.ArrayList;

public class VmConfigEnvironmentForPoolPropertyProvider
implements PropertyProviderBean {
    private static final String OWNER_PROP = "owner";
    private static final String ENV_BROWSER_PROP = "environmentBrowser";
    private static final String HOST_CPU_MHZ_PROPERTY = "summary.hardware.cpuMhz";
    private QueryService _queryService;
    private final DataService _dataService;

    public VmConfigEnvironmentForPoolPropertyProvider(QueryServiceFactory queryServiceFactory, DataService dataService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._dataService = dataService;
    }

    @type(value="ResourcePool,VirtualApp")
    public VmConfigEnvironmentData getVmConfigEnvironmentPerPool(ManagedObjectReference objRef, VmConfigEnvironmentPerPoolParams params) throws Exception {
        ResultSet res = this._queryService.select(new String[]{OWNER_PROP}).from(new String[]{objRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef)}).fetch();
        ManagedObjectReference crRef = (ManagedObjectReference)((ResourceItem)res.getItems().get(0)).get(OWNER_PROP);
        res = this._queryService.select(new String[]{ENV_BROWSER_PROP}).from(new String[]{crRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)crRef)}).fetch();
        ManagedObjectReference envBrowserRef = (ManagedObjectReference)((ResourceItem)res.getItems().get(0)).get(ENV_BROWSER_PROP);
        VmConfigEnvironmentData configEnvironment = this.getVmConfigEnvironment(envBrowserRef, params);
        configEnvironment.envBrowserRef = envBrowserRef;
        configEnvironment.configOption.hardwareOptions.setVirtualDeviceOption(this.filterDeprecated(configEnvironment.configOption.hardwareOptions.virtualDeviceOption));
        return configEnvironment;
    }

    @type(value="EnvironmentBrowser")
    public GuestOsDescriptor getVmConfigGuestOsDescriptor(ManagedObjectReference browserRef, VmConfigEnvironmentPerPoolParams params) throws Exception {
        EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)browserRef);
        EnvironmentBrowser.ConfigOptionQuerySpec spec = new EnvironmentBrowser.ConfigOptionQuerySpec();
        spec.setKey(params.key);
        spec.setHost(params.hostRef);
        if (params.gosId != null) {
            spec.setGuestId(new String[]{params.gosId});
        }
        ConfigOption configOption = browser.queryConfigOptionEx(spec);
        GuestOsDescriptor descriptor = null;
        if (configOption.getGuestOSDescriptor().length > 0) {
            descriptor = configOption.getGuestOSDescriptor()[0];
        }
        return descriptor;
    }

    public VmConfigEnvironmentData getVmConfigEnvironment(ManagedObjectReference browserRef, VmConfigEnvironmentPerPoolParams params) throws Exception {
        assert (browserRef != null);
        EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)browserRef);
        assert (browser != null);
        ClientFutureImpl configOptionFuture = new ClientFutureImpl();
        EnvironmentBrowser.ConfigOptionQuerySpec spec = new EnvironmentBrowser.ConfigOptionQuerySpec();
        spec.setKey(params.key);
        spec.setHost(params.hostRef);
        spec.setGuestId(new String[]{params.gosId});
        browser.queryConfigOptionEx(spec, (Future)configOptionFuture);
        ClientFutureImpl configTargetFuture = new ClientFutureImpl();
        browser.queryConfigTarget(params.hostRef, (Future)configTargetFuture);
        ClientFutureImpl capabilityFuture = new ClientFutureImpl();
        browser.queryTargetCapabilities(params.hostRef, (Future)capabilityFuture);
        ClientFutureImpl dsBrowserFuture = new ClientFutureImpl();
        browser.getDatastoreBrowser((Future)dsBrowserFuture);
        Number hostCpuMhz = null;
        if (params.hostRef != null) {
            hostCpuMhz = (Number)QueryUtil.getProperty((DataService)this._dataService, (Object)params.hostRef, (String)HOST_CPU_MHZ_PROPERTY);
        }
        VmConfigEnvironmentData env = new VmConfigEnvironmentData();
        env.configTarget = (ConfigTarget)configTargetFuture.get();
        env.configOption = (ConfigOption)configOptionFuture.get();
        env.hostCapability = (Capability)capabilityFuture.get();
        env.datastoreBrowser = (ManagedObjectReference)dsBrowserFuture.get();
        env.powerState = VirtualMachine.PowerState.poweredOff;
        env.parentVApp = null;
        env.ipPoolData = this.getIpPoolData(env.configTarget, env.configOption);
        env.isInCluster = null;
        env.hostCpuMhz = hostCpuMhz;
        return env;
    }

    private VirtualDeviceOption[] filterDeprecated(VirtualDeviceOption[] unfilteredDevices) {
        ArrayList<VirtualDeviceOption> filteredDevices = new ArrayList<VirtualDeviceOption>();
        for (VirtualDeviceOption deviceOption : unfilteredDevices) {
            if (deviceOption.deprecated) continue;
            filteredDevices.add(deviceOption);
        }
        return filteredDevices.toArray(new VirtualDeviceOption[filteredDevices.size()]);
    }

    private VAppIpPoolData getIpPoolData(ConfigTarget target, ConfigOption option) throws Exception {
        if (target == null || option == null) {
            return null;
        }
        return this.getIpPoolData(target.network, option.defaultDevice);
    }

    private VAppIpPoolData getIpPoolData(NetworkInfo[] networkInfos, VirtualDevice[] devices) throws Exception {
        if (networkInfos == null || devices == null) {
            return null;
        }
        ArrayList<ManagedObjectReference> networkList = new ArrayList<ManagedObjectReference>();
        for (NetworkInfo networkInfo : networkInfos) {
            if (!VmConfigEnvironmentForPoolPropertyProvider.hasNetwork(devices, networkInfo)) continue;
            networkList.add(networkInfo.network.network);
        }
        ManagedObjectReference[] networks = networkList.toArray(new ManagedObjectReference[networkList.size()]);
        VAppIpPoolData ipPoolData = IpPoolUtil.getIpPoolData((ManagedObjectReference[])networks, (DataService)this._dataService);
        return ipPoolData;
    }

    private static boolean hasNetwork(VirtualDevice[] devices, NetworkInfo networkInfo) {
        for (VirtualDevice device : devices) {
            if (!(device instanceof VirtualEthernetCard)) continue;
            VirtualEthernetCard card = (VirtualEthernetCard)device;
            if (!(card.backing instanceof VirtualDevice.DeviceBackingInfo)) continue;
            VirtualDevice.DeviceBackingInfo backing = (VirtualDevice.DeviceBackingInfo)card.backing;
            if (!backing.deviceName.equals(networkInfo.name)) continue;
            return true;
        }
        return false;
    }
}

