/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.Util;
import com.vmware.vsphere.client.contentLibrary.ContentLibraryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OvfDeployPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(OvfDeployPropertyProvider.class);
    static final String VAPP_IMPORT_PRIVILEGE_NAME = "VApp.Import";
    private static final String OWNER_RELATIONSHIP = "owner";
    private static final String ENVIRONMENT_BROWSER = "environmentBrowser";
    private final QueryExecutor _queryExecutor;
    private final ContentLibraryUtil _contentLibraryUtil;

    public OvfDeployPropertyProvider(QueryExecutor queryExecutor, ContentLibraryUtil contentLibraryUtil) {
        this._queryExecutor = queryExecutor;
        this._contentLibraryUtil = contentLibraryUtil;
    }

    @type(value="Folder,ClusterComputeResource,ResourcePool,VirtualApp,Datacenter")
    public boolean getIsDeployOvfAvailable(ManagedObjectReference target) {
        try {
            if (target == null) {
                _logger.debug((Object)"getIsDeployOvfAvailable: target is null!");
                throw MixedUtil.getInvalidEntityFault();
            }
            if (!this.isValidContainerType(target)) {
                PropertyValue[] crValues = this.getComputeResourceData(target);
                if (!this.isAtleastOneHostInWorkingState(crValues)) {
                    return false;
                }
                String[] grantedPrivileges = (String[])Util.getProperty((PropertyValue[])crValues, (String)"grantedPrivileges");
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ClusterComputeResource.class) && !AuthorizationUtil.isPrivilegeGranted((String[])new String[]{VAPP_IMPORT_PRIVILEGE_NAME}, (String[])grantedPrivileges)) {
                    return false;
                }
            }
            return this._contentLibraryUtil.getIsDeployOvfSupported(target);
        }
        catch (Exception e) {
            _logger.debug((Object)e.getMessage());
            return false;
        }
    }

    @type(value="VirtualApp,VirtualMachine")
    public boolean getIsExportOvfAvailable(ManagedObjectReference target) {
        return this._contentLibraryUtil.getIsDeployOvfSupported(target);
    }

    private boolean isValidContainerType(ManagedObjectReference target) {
        boolean isValidContainerType = false;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Datacenter.class)) {
            isValidContainerType = true;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Folder.class)) {
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)target)) {
                isValidContainerType = true;
            }
            if (ManagedObjectUtil.isVmFolder((ManagedObjectReference)target)) {
                isValidContainerType = true;
            }
        }
        return isValidContainerType;
    }

    private PropertyValue[] getComputeResourceData(ManagedObjectReference target) throws Exception {
        if (!OvfDeployPropertyProvider.targetIsValidType(target)) {
            _logger.error((Object)"target is of invalid type!");
            throw new IllegalArgumentException("target is of invalid type: " + target.getType() + " !");
        }
        PropertyValue[] values = this.queryProperties(target);
        return values;
    }

    private static boolean targetIsValidType(ManagedObjectReference target) {
        return ManagedObjectUtil.isOfType((ManagedObjectReference)target, ClusterComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class);
    }

    private PropertyValue[] queryProperties(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ClusterComputeResource.class)) {
            values = this.queryPropertiesForCluster(target);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class)) {
            values = this.queryPropertiesForResourcePoolOrVapp(target);
        }
        return values;
    }

    private PropertyValue[] queryPropertiesForCluster(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = this._queryExecutor.getProperties((Object)target, new String[]{"grantedPrivileges", ENVIRONMENT_BROWSER});
        return values;
    }

    private PropertyValue[] queryPropertiesForResourcePoolOrVapp(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = this._queryExecutor.getPropertiesForRelatedObjects((Object)target, OWNER_RELATIONSHIP, ComputeResource.class.getSimpleName(), new String[]{ENVIRONMENT_BROWSER});
        return values;
    }

    private boolean isAtleastOneHostInWorkingState(PropertyValue[] crValues) {
        ManagedObjectReference envBrowser = (ManagedObjectReference)Util.getProperty((PropertyValue[])crValues, (String)ENVIRONMENT_BROWSER);
        return envBrowser != null;
    }
}

