/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.host.CpuPackage;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.vm.model.SupportedEvcMode;
import com.vmware.vsphere.client.h5.vm.model.VmEditEvcData;
import com.vmware.vsphere.client.h5.vm.model.VmEvcData;
import com.vmware.vsphere.client.h5.vm.util.VmStringUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmEvcPropertyProvider {
    private static final Log _logger = LogFactory.getLog(VmEvcPropertyProvider.class);

    @DerivedProperty(value="VirtualMachine/vmEvcEnabled")
    public static boolean getVmEvcEnabled(@SourceProperty(value="VirtualMachine/capability/perVmEvcSupported") Boolean vmEvcSupported, @SourceProperty(value="VirtualMachine/runtime/minRequiredEVCModeKey") String vmMinRequiredEVCModeKey) {
        if (!Boolean.TRUE.equals(vmEvcSupported)) {
            return false;
        }
        return !StringUtil.isNullOrEmpty((String)vmMinRequiredEVCModeKey);
    }

    @DerivedProperty(value="VirtualMachine/vmEvcData")
    public static VmEvcData getVmEvcData(@SourceProperty(value="VirtualMachine/@instanceUuid") String serverGuid, @SourceProperty(value="VirtualMachine/runtime/minRequiredEVCModeKey") String vmMinRequiredEVCModeKey) {
        EVCMode[] supportedEvcModes = VmEvcPropertyProvider.getSupportedEvcModes(serverGuid);
        return VmEvcPropertyProvider.getCurrentEvcMode(vmMinRequiredEVCModeKey, supportedEvcModes);
    }

    @DerivedProperty(value="VirtualMachine/vmEditEvcData")
    public static VmEditEvcData getVmEditEvcData(@SourceProperty(value="VirtualMachine/@instanceUuid") String serverGuid, @SourceProperty(value="VirtualMachine/runtime/minRequiredEVCModeKey") String vmMinRequiredEVCModeKey) {
        EVCMode[] supportedEvcModes = VmEvcPropertyProvider.getSupportedEvcModes(serverGuid);
        return VmEvcPropertyProvider.buildEditEvcData(vmMinRequiredEVCModeKey, supportedEvcModes);
    }

    private static VmEvcData getCurrentEvcMode(String vmMinRequiredEVCModeKey, EVCMode[] supportedEvcModes) {
        VmEvcData evcData = new VmEvcData();
        if (ArrayUtil.isNullOrEmpty((Object[])supportedEvcModes)) {
            evcData.vendor = VmEvcData.VmEvcVendor.NONE;
            evcData.key = VmEvcData.VmEvcVendor.NONE.toString();
            return evcData;
        }
        if (!StringUtil.isNullOrEmpty((String)vmMinRequiredEVCModeKey)) {
            for (EVCMode mode : supportedEvcModes) {
                if (!mode.getKey().equals(vmMinRequiredEVCModeKey)) continue;
                evcData.vendor = VmEvcPropertyProvider.getEvcVendor(mode);
                evcData.key = mode.getKey();
                evcData.label = mode.getLabel();
                evcData.summary = mode.getSummary();
                evcData.guaranteedCPUFeatures = mode.getGuaranteedCPUFeatures();
                return evcData;
            }
        }
        evcData.vendor = VmEvcData.VmEvcVendor.NONE;
        evcData.key = VmEvcData.VmEvcVendor.NONE.toString();
        return evcData;
    }

    private static VmEditEvcData buildEditEvcData(String vmMinRequiredEVCModeKey, EVCMode[] supportedEvcModes) {
        VmEditEvcData editEvcData = new VmEditEvcData();
        editEvcData.evcModesByVendor = new EnumMap<VmEvcData.VmEvcVendor, List<SupportedEvcMode>>(VmEvcData.VmEvcVendor.class);
        SupportedEvcMode disabledEvcMode = new SupportedEvcMode();
        disabledEvcMode.key = VmEvcData.VmEvcVendor.NONE.toString();
        disabledEvcMode.label = VmStringUtil.getString("vmEvc.disableEvc.optionLabel");
        ArrayList<SupportedEvcMode> disabledEvcModes = new ArrayList<SupportedEvcMode>(1);
        disabledEvcModes.add(disabledEvcMode);
        editEvcData.evcModesByVendor.put(VmEvcData.VmEvcVendor.NONE, disabledEvcModes);
        SupportedEvcMode customEvcMode = new SupportedEvcMode();
        customEvcMode.key = VmEvcData.VmEvcVendor.CUSTOM.toString();
        customEvcMode.label = VmStringUtil.getString("vmEvc.customEvc.optionLabel");
        ArrayList<SupportedEvcMode> customEvcModes = new ArrayList<SupportedEvcMode>(1);
        customEvcModes.add(customEvcMode);
        editEvcData.evcModesByVendor.put(VmEvcData.VmEvcVendor.CUSTOM, customEvcModes);
        ArrayList<SupportedEvcMode> amdEvcModes = new ArrayList<SupportedEvcMode>();
        ArrayList<SupportedEvcMode> intelEvcModes = new ArrayList<SupportedEvcMode>();
        editEvcData.evcModesByVendor.put(VmEvcData.VmEvcVendor.AMD, amdEvcModes);
        editEvcData.evcModesByVendor.put(VmEvcData.VmEvcVendor.INTEL, intelEvcModes);
        for (EVCMode mode : supportedEvcModes) {
            SupportedEvcMode supportedMode = new SupportedEvcMode();
            supportedMode.key = mode.getKey();
            supportedMode.label = mode.getLabel();
            supportedMode.summary = mode.getSummary();
            supportedMode.featureMasks = mode.getFeatureMask();
            VmEvcData.VmEvcVendor vendor = VmEvcPropertyProvider.getEvcVendor(mode);
            if (VmEvcData.VmEvcVendor.AMD.equals((Object)vendor)) {
                amdEvcModes.add(supportedMode);
                continue;
            }
            if (!VmEvcData.VmEvcVendor.INTEL.equals((Object)vendor)) continue;
            intelEvcModes.add(supportedMode);
        }
        VmEvcData currentEvcMode = VmEvcPropertyProvider.getCurrentEvcMode(vmMinRequiredEVCModeKey, supportedEvcModes);
        editEvcData.vendor = currentEvcMode.vendor;
        editEvcData.key = currentEvcMode.key;
        return editEvcData;
    }

    private static VmEvcData.VmEvcVendor getEvcVendor(EVCMode mode) {
        if (CpuPackage.Vendor.amd.toString().equals(mode.getVendor())) {
            return VmEvcData.VmEvcVendor.AMD;
        }
        if (CpuPackage.Vendor.intel.toString().equals(mode.getVendor())) {
            return VmEvcData.VmEvcVendor.INTEL;
        }
        return VmEvcData.VmEvcVendor.NONE;
    }

    private static EVCMode[] getSupportedEvcModes(String serverGuid) {
        EVCMode[] supportedEvcModes = null;
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return supportedEvcModes;
        }
        ServiceInstance si = service.getServiceInstance();
        if (si == null) {
            _logger.error((Object)"Could not retrieve service instance");
            return supportedEvcModes;
        }
        Capability caps = si.getCapability();
        if (caps == null) {
            _logger.error((Object)"Could not retrieve service instance capabilities");
            return supportedEvcModes;
        }
        supportedEvcModes = caps.getSupportedEVCMode();
        return supportedEvcModes;
    }
}

