/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.commons.vmomi;

import com.vmware.opsmgmt.client.commons.vmomi.CompletionFuture;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FutureCompletionService<V, C> {
    private int tasks = 0;
    private final BlockingQueue<CompletionFuture<V, C>> completionQueue = new LinkedBlockingQueue<CompletionFuture<V, C>>();

    public CompletionFuture<V, C> create(C context) {
        ++this.tasks;
        return new CompletionFuture<V, C>(context){

            @Override
            protected void done() {
                FutureCompletionService.this.completionQueue.add(this);
            }
        };
    }

    public CompletionFuture<V, ?> create() {
        return this.create(null);
    }

    public CompletionFuture<V, C> next() {
        if (this.hasNext()) {
            --this.tasks;
            try {
                CompletionFuture<V, C> task = this.completionQueue.take();
                return task;
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
        throw new NoSuchElementException("Completion queue has been consumed.");
    }

    public boolean hasNext() {
        return this.tasks > 0;
    }
}

