/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.actionsfw.impl;

import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionMenuItem;
import com.vmware.vise.actionsfw.ActionMenuItemSpec;
import com.vmware.vise.actionsfw.ActionMenuItemType;
import com.vmware.vise.actionsfw.ActionMenusRequestSpec;
import com.vmware.vise.actionsfw.ActionPriorityGroup;
import com.vmware.vise.actionsfw.ActionSpec;
import com.vmware.vise.actionsfw.ActionToolbarRequestSpec;
import com.vmware.vise.actionsfw.ActionsRequestSpec;
import com.vmware.vise.actionsfw.ActionsService;
import com.vmware.vise.actionsfw.RequestPolicy;
import com.vmware.vise.actionsfw.impl.ActionImpl;
import com.vmware.vise.actionsfw.impl.ActionMenuItemImpl;
import com.vmware.vise.actionsfw.impl.ActionsEvaluator;
import com.vmware.vise.actionsfw.impl.ActionsServiceUtil;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.impl.Filterer;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.FeatureUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ActionsServiceImpl
implements ActionsService,
ExtensionListener {
    private final String ACTIONS_EXT_POINT;
    private final List<String> MENU_EXT_POINTS;
    private static final String CONTEXT_OBJECTS_FILTER_PROPERTY = "contextObjects";
    private static final Log _logger = LogFactory.getLog(ActionsServiceImpl.class);
    private final ExtensionService _extensionService;
    private final ActionsEvaluator _actionsEvaluator;
    private final ObjectReferenceService _objRefService;
    private final FeatureStateService _featureStateService;
    private final ServiceRegistry _serviceRegistry;
    private static final String OBJECT_TYPE = "objectType";
    private static final String GLOBAL_LIST_ACTIONS = "vmware.prioritization.listActions";
    private static final String SOLUTION_MENUS_EXTENSION_POINT = "vise.menus.context.solutionMenus";
    private final Map<String, ExtensionInfo> _eiByUid;
    private final Map<String, Set<String>> _actionUidsByType;
    private final Set<String> _globalActionUids;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();

    public ActionsServiceImpl(ExtensionService extensionService, ActionsEvaluator actionsEvaluator, ObjectReferenceService objRefService, FeatureStateService featureStateService, ServiceRegistry serviceRegistry, String actionsExtPt, List<String> menuExtPts) {
        this.ACTIONS_EXT_POINT = actionsExtPt;
        this.MENU_EXT_POINTS = menuExtPts;
        this._extensionService = extensionService;
        this._actionsEvaluator = actionsEvaluator;
        this._objRefService = objRefService;
        this._featureStateService = featureStateService;
        this._serviceRegistry = serviceRegistry;
        this._eiByUid = new HashMap<String, ExtensionInfo>();
        this._actionUidsByType = new HashMap<String, Set<String>>();
        this._globalActionUids = new HashSet<String>();
    }

    public void handleEvent(PluginPackageEvent event) {
        if (!event.isSuccessfulDeploymentEvent()) {
            return;
        }
        this.loadExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Action> getActions(ActionsRequestSpec spec, boolean skipActionFilteringStage) throws NullPointerException {
        if (spec == null) {
            throw new NullPointerException("ActionsRequestSpec must not be null when requesting Actions");
        }
        try {
            List<Action> actionsByUid;
            List<String> applicableTargetTypes;
            this._readLock.lock();
            boolean includePrivateActions = false;
            Collection candidateActionIds = this.getCandidateActions(spec.globalActions);
            if (!ArrayUtil.isNullOrEmpty(spec.actionUids)) {
                candidateActionIds = CollectionUtil.intersection(candidateActionIds, spec.actionUids);
                includePrivateActions = true;
            }
            if ((applicableTargetTypes = this.getApplicableTargetTypes(spec)) != null) {
                Set<String> actionIdsApplicableToTypes = this.getActionIdsByTargetType(applicableTargetTypes);
                if (spec.globalActions == RequestPolicy.INCLUDE || spec.globalActions == RequestPolicy.ONLY) {
                    actionIdsApplicableToTypes.addAll(this._globalActionUids);
                }
                candidateActionIds = CollectionUtil.intersection((Collection)candidateActionIds, actionIdsApplicableToTypes);
            }
            List<Action> list = actionsByUid = this.getActionsList(candidateActionIds, spec.context, includePrivateActions, skipActionFilteringStage);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActionEvaluation> getEvaluatedActions(ActionsRequestSpec spec, boolean skipActionFilteringStage) throws Exception {
        if (spec == null) {
            throw new NullPointerException("ActionsRequestSpec must not be null when evaluating Actions.");
        }
        if (spec.context == null) {
            throw new NullPointerException("ActionContext must not be null when evaluating Actions.");
        }
        try {
            List<ActionEvaluation> actionEvaluations;
            this._readLock.lock();
            List<Action> candidateActions = this.getActions(spec, skipActionFilteringStage);
            if (candidateActions.size() < 1) {
                ArrayList<ActionEvaluation> arrayList = new ArrayList<ActionEvaluation>();
                return arrayList;
            }
            List<ActionEvaluation> list = actionEvaluations = this._actionsEvaluator.evaluate(candidateActions, spec.context, !skipActionFilteringStage);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActionMenuItem> getMenus(ActionMenusRequestSpec spec) {
        try {
            this._readLock.lock();
            List<ActionMenuItem> menuItems = this.getMenusInternal(spec);
            if (spec.context != null) {
                for (ActionMenuItem menu : menuItems) {
                    this.removeNonApplicableActions(menu, spec.context);
                }
            }
            this.sanitizeActionsList(menuItems);
            List<ActionMenuItem> list = menuItems;
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionMenuItem getOrBuildMenu(ActionMenusRequestSpec spec) {
        try {
            this._readLock.lock();
            ActionMenuItem result = null;
            List<ActionMenuItem> availableMenus = this.getFirstMenus(spec);
            this.sanitizeActionsList(availableMenus);
            int noOfMenus = availableMenus.size();
            if (noOfMenus > 0) {
                if (noOfMenus > 1) {
                    _logger.error((Object)"More than one menu available for the selected objects.");
                    for (int iter = 1; iter < noOfMenus; ++iter) {
                        _logger.error((Object)("Skipping menu with id: " + availableMenus.get(iter).getId()));
                    }
                }
                result = availableMenus.get(0);
            }
            if (result == null) {
                ActionsRequestSpec actionsSpec = new ActionsRequestSpec();
                actionsSpec.globalActions = RequestPolicy.EXCLUDE;
                actionsSpec.context = spec.context;
                List<Action> applicableActions = this.getActions(actionsSpec, false);
                result = this.buildMenu(applicableActions);
            }
            ActionMenuItem actionMenuItem = result = this.removeNonApplicableActions(result, spec.context);
            return actionMenuItem;
        }
        finally {
            this._readLock.unlock();
        }
    }

    @Override
    public List<ActionMenuItem> getToolbarActions(ActionToolbarRequestSpec spec) {
        if (spec == null) {
            throw new NullPointerException("ActionToolbarRequestSpec should not be null");
        }
        if (spec.listViewId == null) {
            throw new NullPointerException("listViewId should not be null");
        }
        List extensions = null;
        try {
            extensions = this._extensionService.getExtensionObjects(GLOBAL_LIST_ACTIONS, null, false);
        }
        catch (IllegalArgumentException ex) {
            _logger.error((Object)"Malformed list actions request.", (Throwable)ex);
        }
        if (extensions == null) {
            return new ArrayList<ActionMenuItem>();
        }
        ArrayList<String> globalActionUids = new ArrayList<String>();
        for (ActionPriorityGroup extension : extensions) {
            if (!spec.listViewId.equals(extension.regionId)) continue;
            globalActionUids.addAll(extension.prioritizedIds);
        }
        if (globalActionUids.isEmpty()) {
            return new ArrayList<ActionMenuItem>();
        }
        ActionsRequestSpec actionsSpec = new ActionsRequestSpec();
        actionsSpec.globalActions = RequestPolicy.ONLY;
        actionsSpec.context = spec.context;
        actionsSpec.actionUids = globalActionUids;
        List<Action> applicableActions = this.getActions(actionsSpec, false);
        List<ActionMenuItem> result = this.buildMenuItems(applicableActions);
        return result;
    }

    private List<ActionMenuItem> getFirstMenus(ActionMenusRequestSpec spec) {
        if (spec.menuTypes == null) {
            return this.getMenusInternal(spec);
        }
        ActionMenusRequestSpec specificMenuTypeSpec = new ActionMenusRequestSpec();
        specificMenuTypeSpec.menuIds = spec.menuIds;
        specificMenuTypeSpec.context = spec.context;
        for (String menuType : spec.menuTypes) {
            specificMenuTypeSpec.menuTypes = Collections.singletonList(menuType);
            List<ActionMenuItem> availableMenus = this.getMenusInternal(specificMenuTypeSpec);
            if (availableMenus.isEmpty()) continue;
            return availableMenus;
        }
        return Collections.emptyList();
    }

    private ActionMenuItem removeNonApplicableActions(ActionMenuItem menuItem, ActionContext context) {
        List<String> actionUids = ActionsServiceImpl.getActionIdsFromMenu(menuItem);
        List<ActionImpl> actionsList = this.getActionsList(actionUids, context, true, false);
        Map<String, ActionImpl> actionsByUid = ActionsServiceImpl.buildActionsMap(actionsList);
        ActionsServiceImpl.removeNonApplicableActionsInternal(menuItem, context, actionsByUid);
        return menuItem;
    }

    private static void removeNonApplicableActionsInternal(ActionMenuItem menuItem, ActionContext context, Map<String, ActionImpl> actionsByUid) {
        ListIterator<ActionMenuItem> iter = menuItem.getChildren().listIterator();
        while (iter.hasNext()) {
            ActionMenuItem child = iter.next();
            switch (child.getType()) {
                case ACTION: {
                    ActionImpl actionImpl = actionsByUid.get(child.getId());
                    if (actionImpl != null && actionImpl.evaluateApplicability(context)) break;
                    iter.remove();
                    break;
                }
                case MENU: {
                    ActionsServiceImpl.removeNonApplicableActionsInternal(child, context, actionsByUid);
                    if (!child.getChildren().isEmpty() || ActionsServiceImpl.isPluginMenu(child)) break;
                    iter.remove();
                    break;
                }
            }
        }
        ActionsServiceImpl.removeUnwantedSeparators(menuItem.getChildren());
    }

    private static boolean isPluginMenu(ActionMenuItem menu) {
        return SOLUTION_MENUS_EXTENSION_POINT.equals(menu.getExtendedPoint());
    }

    private static Map<String, ActionImpl> buildActionsMap(List<ActionImpl> actionsList) {
        HashMap<String, ActionImpl> result = new HashMap<String, ActionImpl>();
        for (Action action : actionsList) {
            result.put(action.getUid(), (ActionImpl)action);
        }
        return result;
    }

    private static List<String> getActionIdsFromMenu(ActionMenuItem menuItem) {
        ArrayList<String> result = new ArrayList<String>();
        if (ActionMenuItemType.ACTION.equals((Object)menuItem.getType())) {
            result.add(menuItem.getId());
        } else if (ActionMenuItemType.MENU.equals((Object)menuItem.getType())) {
            for (ActionMenuItem child : menuItem.getChildren()) {
                result.addAll(ActionsServiceImpl.getActionIdsFromMenu(child));
            }
        }
        return result;
    }

    private static List<String> getActionIdsFromMenus(List<ActionMenuItem> menuItems) {
        ArrayList<String> result = new ArrayList<String>();
        for (ActionMenuItem menuItem : menuItems) {
            result.addAll(ActionsServiceImpl.getActionIdsFromMenu(menuItem));
        }
        return result;
    }

    private ActionMenuItem buildMenu(List<Action> actions) {
        ActionMenuItemSpec menuSpec = new ActionMenuItemSpec();
        menuSpec.type = ActionMenuItemType.MENU.name();
        ActionMenuItemImpl menu = new ActionMenuItemImpl(menuSpec);
        menu.children = this.buildMenuItems(actions);
        return menu;
    }

    private List<ActionMenuItem> buildMenuItems(List<Action> actions) {
        ArrayList<ActionMenuItem> menuItems = new ArrayList<ActionMenuItem>(actions.size());
        for (Action action : actions) {
            ActionMenuItemSpec actionSpec = new ActionMenuItemSpec();
            actionSpec.icon = action.getIcon();
            actionSpec.label = action.getLabel();
            actionSpec.type = ActionMenuItemType.ACTION.name();
            actionSpec.setUid(action.getUid());
            menuItems.add(new ActionMenuItemImpl(actionSpec));
        }
        return menuItems;
    }

    private List<ActionMenuItem> getMenusInternal(ActionMenusRequestSpec spec) {
        if (spec == null) {
            throw new NullPointerException("ActionMenusRequestSpec must not be null.");
        }
        ArrayList<ActionMenuItem> menus = new ArrayList<ActionMenuItem>();
        Map<String, Object> filterContext = this.createFilterContext(spec.context);
        List<String> extensionPoints = spec.menuTypes != null ? spec.menuTypes : this.MENU_EXT_POINTS;
        for (String extensionPoint : extensionPoints) {
            List specs;
            try {
                specs = this._extensionService.getExtensionObjects(extensionPoint, filterContext, true);
            }
            catch (IllegalArgumentException ex) {
                _logger.error((Object)"Malformed menus request.", (Throwable)ex);
                continue;
            }
            for (ActionMenuItemSpec extension : specs) {
                if (spec.menuIds != null && !spec.menuIds.contains(extension.getUid())) continue;
                menus.addAll(this.createMenuItems(spec.context, extension, extensionPoint));
            }
        }
        return menus;
    }

    private List<ActionMenuItem> createMenuItems(ActionContext context, ActionMenuItemSpec spec, String extendedPoint) {
        if (spec.type.equals("HOSTEDPOINT")) {
            if (this.isItemFilteredOut(spec)) {
                return Collections.emptyList();
            }
            if (spec.getUid().equals(SOLUTION_MENUS_EXTENSION_POINT)) {
                ExtensionInfo[] nestedMenuExtensions = this._extensionService.getExtensionInfos(spec.getUid());
                if (nestedMenuExtensions.length == 0) {
                    return Collections.emptyList();
                }
                Filterer fastFilterer = new Filterer(true);
                List filters = this._serviceRegistry.getServices(ExtensionObjectFilter.class.getName());
                List probablyRelevantMenus = fastFilterer.filter(Arrays.asList(nestedMenuExtensions), this.createFilterContext(context), filters);
                if (probablyRelevantMenus.isEmpty()) {
                    return Collections.emptyList();
                }
                List menuItemSpecs = this._extensionService.getExtensionObjects(probablyRelevantMenus, null, true);
                ArrayList<ActionMenuItem> menuItems = new ArrayList<ActionMenuItem>();
                for (ActionMenuItemSpec menuSpec : menuItemSpecs) {
                    ActionMenuItemImpl item = new ActionMenuItemImpl(menuSpec, spec.getUid());
                    item.children = new ArrayList<ActionMenuItem>();
                    menuItems.add(item);
                }
                return menuItems;
            }
            ActionMenusRequestSpec subMenusSpec = new ActionMenusRequestSpec();
            subMenusSpec.context = context;
            subMenusSpec.menuTypes = ArrayUtil.toArrayList((Object[])new String[]{spec.getUid()});
            return this.getMenusInternal(subMenusSpec);
        }
        ActionMenuItem item = this.createMenuItem(spec, extendedPoint, context);
        if (item == null) {
            return Collections.emptyList();
        }
        ArrayList itemWrapper = ArrayUtil.toArrayList((Object[])new ActionMenuItem[]{item});
        return itemWrapper;
    }

    private ActionMenuItem createMenuItem(ActionMenuItemSpec spec, String extendedPoint, ActionContext context) {
        ActionMenuItemImpl item = new ActionMenuItemImpl(spec, extendedPoint);
        if (this.isItemFilteredOut(item)) {
            return null;
        }
        if (item.getType().equals((Object)ActionMenuItemType.ACTION)) {
            if (item.getIcon() == null || item.getLabel() == null) {
                this.populateActionMenuItemFromAction(item);
            }
            return item;
        }
        if (item.getType().equals((Object)ActionMenuItemType.MENU) && !ArrayUtil.isNullOrEmpty(spec.children)) {
            ArrayList<ActionMenuItem> children = new ArrayList<ActionMenuItem>();
            for (ActionMenuItemSpec childSpec : spec.children) {
                children.addAll(this.createMenuItems(context, childSpec, null));
            }
            if (children.isEmpty()) {
                return null;
            }
            item.children = children;
        }
        return item;
    }

    private boolean isItemFilteredOut(ActionMenuItemImpl item) {
        String featureExpression = StringUtil.returnNullIfEmpty((String)item.getFeature());
        boolean isFilteredOut = FeatureUtil.evaluateFeatureExpression((FeatureStateService)this._featureStateService, (String)featureExpression);
        return isFilteredOut;
    }

    private boolean isItemFilteredOut(ActionMenuItemSpec spec) {
        String featureExpression = StringUtil.returnNullIfEmpty((String)spec.feature);
        boolean isFilteredOut = FeatureUtil.evaluateFeatureExpression((FeatureStateService)this._featureStateService, (String)featureExpression);
        return isFilteredOut;
    }

    private void sanitizeActionsList(List<ActionMenuItem> menuItems) {
        ListIterator<ActionMenuItem> iter = menuItems.listIterator();
        while (iter.hasNext()) {
            ActionMenuItem item = iter.next();
            if (!item.getType().equals((Object)ActionMenuItemType.MENU) || ActionsServiceImpl.isPluginMenu(item)) continue;
            this.sanitizeActionsList(item.getChildren());
            if (!item.getChildren().isEmpty()) continue;
            _logger.debug((Object)("Removed from list while sanitizing menu since submenu was empty" + item.getId()));
            iter.remove();
        }
        ActionsServiceImpl.removeUnwantedSeparators(menuItems);
    }

    private static void removeUnwantedSeparators(List<ActionMenuItem> menuItems) {
        ListIterator<ActionMenuItem> iter2 = menuItems.listIterator();
        while (iter2.hasNext()) {
            ActionMenuItem previousItem;
            int prevIndex;
            ActionMenuItem item = iter2.next();
            if (!item.getType().equals((Object)ActionMenuItemType.SEPARATOR) || !iter2.hasPrevious() || (prevIndex = iter2.previousIndex() - 1) <= -1 || !(previousItem = menuItems.get(prevIndex)).getType().equals((Object)ActionMenuItemType.SEPARATOR)) continue;
            _logger.debug((Object)"Removed consecutive separators");
            iter2.remove();
        }
        if (menuItems.size() > 0 && menuItems.get(0).getType().equals((Object)ActionMenuItemType.SEPARATOR)) {
            menuItems.remove(0);
        }
        if (menuItems.size() > 0 && menuItems.get(menuItems.size() - 1).getType().equals((Object)ActionMenuItemType.SEPARATOR)) {
            menuItems.remove(menuItems.size() - 1);
        }
    }

    private void populateActionMenuItemFromAction(ActionMenuItemImpl actionItem) {
        ExtensionInfo ei = this._eiByUid.get(actionItem.getId());
        ActionSpec spec = null;
        if (ei != null) {
            spec = (ActionSpec)((Object)this._extensionService.getExtensionObject(ei, null, true));
        }
        if (spec == null) {
            _logger.error((Object)("Action not found: " + actionItem.getId()));
        } else {
            if (actionItem.getLabel() == null) {
                actionItem.label = spec.label;
            }
            if (actionItem.getIcon() == null) {
                actionItem.icon = spec.icon;
            }
        }
    }

    private List<String> getTargetTypes(List<Object> targets) {
        if (targets == null) {
            return null;
        }
        if (targets.size() == 0) {
            return new ArrayList<String>();
        }
        HashSet<String> targetTypes = new HashSet<String>();
        for (Object target : targets) {
            targetTypes.add(ActionsServiceUtil.getTargetType(target, this._objRefService));
        }
        return new ArrayList<String>(targetTypes);
    }

    private Collection<String> getCandidateActions(RequestPolicy globalActionsPolicy) {
        Set<String> candidateActionIds = globalActionsPolicy == RequestPolicy.INCLUDE ? this._eiByUid.keySet() : (globalActionsPolicy == RequestPolicy.ONLY ? this._globalActionUids : CollectionUtil.minus(this._eiByUid.keySet(), this._globalActionUids));
        return candidateActionIds;
    }

    private List<String> getApplicableTargetTypes(ActionsRequestSpec spec) {
        Collection<String> applicableTargetTypes = null;
        if (!ArrayUtil.isNullOrEmpty(spec.targetTypes)) {
            applicableTargetTypes = new HashSet<String>(spec.targetTypes);
        }
        if (spec.context != null && !ArrayUtil.isNullOrEmpty(spec.context.getTargetObjects())) {
            List<String> contextTargetTypes = this.getTargetTypes(spec.context.getTargetObjects());
            applicableTargetTypes = CollectionUtil.intersection(contextTargetTypes, applicableTargetTypes);
        }
        return applicableTargetTypes == null ? null : new ArrayList<String>(applicableTargetTypes);
    }

    private List<ActionImpl> getActionsList(Collection<String> uids, ActionContext context, boolean includePrivateActions, boolean skipActionFilteringStage) {
        List specs;
        if (uids.size() == 0) {
            return new ArrayList<ActionImpl>(0);
        }
        ArrayList<ActionImpl> actions = new ArrayList<ActionImpl>(uids.size());
        ArrayList<ExtensionInfo> eis = new ArrayList<ExtensionInfo>(uids.size());
        for (String uid : uids) {
            if (uid == null) {
                throw new NullPointerException("ActionsRequestSpec.actionUids must not contain null");
            }
            ExtensionInfo ei = this._eiByUid.get(uid);
            if (ei == null) {
                _logger.error((Object)("No action with uid" + uid + " registered with the ActionsService"));
                continue;
            }
            eis.add(ei);
        }
        if (skipActionFilteringStage) {
            specs = this._extensionService.getExtensionObjects(eis, null, true);
            if (context.getTargetObjects() != null && context.getTargetObjects().size() == 1) {
                Map generatedSpecs = this._extensionService.getGeneratedExtensionObjects(eis, context.getTargetObjects().get(0));
                for (int i = 0; i < specs.size(); ++i) {
                    String uid = ((ActionSpec)((Object)specs.get(i))).getUid();
                    if (!generatedSpecs.containsKey(uid)) continue;
                    specs.set(i, generatedSpecs.get(uid));
                }
            }
        } else {
            specs = this._extensionService.getExtensionObjects(eis, this.createFilterContext(context), true);
        }
        for (ActionSpec spec : specs) {
            if (!includePrivateActions && spec.privateAction) continue;
            actions.add(this.createAction(spec));
        }
        return actions;
    }

    private Set<String> getActionIdsByTargetType(List<String> targetTypes) {
        if (ArrayUtil.isNullOrEmpty(targetTypes)) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> actionUids = null;
        for (String type : targetTypes) {
            if (type == null) {
                throw new NullPointerException("ActionsRequestSpec.targetTypes should not contain null");
            }
            Set<String> nextSet = this._actionUidsByType.get(type);
            if (nextSet == null) {
                if (!this._actionUidsByType.keySet().contains(type)) {
                    _logger.warn((Object)("No Actions registered for target type " + type + "."));
                }
                nextSet = new LinkedHashSet<String>();
            }
            if (actionUids == null) {
                actionUids = new LinkedHashSet<String>(nextSet);
            } else {
                actionUids.retainAll(nextSet);
            }
            if (actionUids.size() != 0) continue;
            break;
        }
        return actionUids;
    }

    private Map<String, Object> createFilterContext(ActionContext context) {
        HashMap<String, Object> filterContext = new HashMap<String, Object>();
        if (context != null && !ArrayUtil.isNullOrEmpty(context.getTargetObjects())) {
            filterContext.put(CONTEXT_OBJECTS_FILTER_PROPERTY, context.getTargetObjects().toArray());
        }
        return filterContext;
    }

    private ActionImpl createAction(ActionSpec spec) {
        ExtensionInfo ei = this._eiByUid.get(spec.getUid());
        List<String> applicableTypes = this.getApplicableTypes(ei);
        return new ActionImpl(spec, applicableTypes, this._objRefService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions() {
        try {
            ExtensionInfo[] eis;
            this._writeLock.lock();
            this._eiByUid.clear();
            this._actionUidsByType.clear();
            this._globalActionUids.clear();
            for (ExtensionInfo ei : eis = this._extensionService.getAllExtensionInfos(this.ACTIONS_EXT_POINT)) {
                this._eiByUid.put(ei.getId(), ei);
                this.addEiToTypesCache(ei);
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    private void addEiToTypesCache(ExtensionInfo ei) {
        List<String> applicableTargetTypes = this.getApplicableTypes(ei);
        if (applicableTargetTypes.size() == 0) {
            this._globalActionUids.add(ei.getId());
            return;
        }
        for (String type : applicableTargetTypes) {
            Set<String> ids = this._actionUidsByType.get(type);
            if (ids == null) {
                ids = new LinkedHashSet<String>();
                this._actionUidsByType.put(type, ids);
            }
            ids.add(ei.getId());
        }
    }

    private List<String> getApplicableTypes(ExtensionInfo ei) {
        Map metadata = ei.getMetadata();
        Object typeString = null;
        if (metadata != null) {
            typeString = metadata.get(OBJECT_TYPE);
        }
        if (typeString == null) {
            return new ArrayList<String>();
        }
        return ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)typeString.toString(), (String)","));
    }
}

