/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.license.client.cis.global.ds.LicensingGlobalData;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.LicensingMethodFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetAvailabilityPropertyProvider {
    private static final String LICENSING_GLOBAL_DATA_TYPE = "LicensingGlobalData";
    private static final String LICENSE_GLOBAL_DATA_PROP = "licensingGlobalData";
    private static final Log _logger = LogFactory.getLog(AssetAvailabilityPropertyProvider.class);
    private QueryService _queryService;

    public AssetAvailabilityPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="HostSystem/isAssignLicenseActionAvailable")
    public Collection<Boolean> getHostIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> hostRefs) {
        return this.getIsAssignLicenseActionAvailable(hostRefs);
    }

    @PropertyProvider(value="ClusterComputeResource/isAssignLicenseActionAvailable")
    public Collection<Boolean> getClusterComputeResourceIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> clusterRefs) {
        return this.getIsAssignLicenseActionAvailable(clusterRefs);
    }

    @PropertyProvider(value="Folder/isAssignLicenseActionAvailable")
    public Collection<Boolean> getFolderIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> vcRefs) {
        return this.getIsAssignLicenseActionAvailable(vcRefs);
    }

    private Collection<Boolean> getIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> assetRefs) {
        if (assetRefs == null || assetRefs.size() == 0) {
            return null;
        }
        ManagedObjectReference[] assets = assetRefs.toArray(new ManagedObjectReference[0]);
        if (!LicenseScopeUtil.doAssetsHaveSameScope((ManagedObjectReference[])assets)) {
            return Collections.nCopies(assetRefs.size(), false);
        }
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByMoRef((ManagedObjectReference)assets[0]);
        Boolean hasLicensingAdminPrivilege = this.checkLicensingAdminPrivilege(scope);
        return Collections.nCopies(assetRefs.size(), hasLicensingAdminPrivilege);
    }

    private boolean checkLicensingAdminPrivilege(LicenseScope scope) {
        LicensingGlobalData licensingGlobalData = this.retrieveLicensingGlobalDataForScope(scope);
        if (licensingGlobalData != null) {
            return licensingGlobalData.isLicensingAdminPrivilegeGranted();
        }
        return false;
    }

    private LicensingGlobalData retrieveLicensingGlobalDataForScope(LicenseScope scope) {
        URI licensingGlobalDataUri = DefaultUriSchemeUtil.createUri((String)LICENSING_GLOBAL_DATA_TYPE, (String)scope.getId());
        ResultSet licensePropsResultSet = null;
        try {
            licensePropsResultSet = this._queryService.select(new String[]{LICENSE_GLOBAL_DATA_PROP}).from(new String[]{LICENSING_GLOBAL_DATA_TYPE}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)licensingGlobalDataUri).fetch();
        }
        catch (RuntimeException exception) {
            if (exception.getCause() instanceof LicensingMethodFault) {
                _logger.error((Object)("The request for license global data failed with error: " + exception.getMessage()));
            }
            throw exception;
        }
        if (licensePropsResultSet == null || licensePropsResultSet.getItems() == null || licensePropsResultSet.getItems().isEmpty()) {
            return null;
        }
        ResourceItem resourceItem = (ResourceItem)licensePropsResultSet.getItems().get(0);
        return (LicensingGlobalData)resourceItem.get(LICENSE_GLOBAL_DATA_PROP);
    }
}

