/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.vmdp;

import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.PciDevice;
import com.vmware.vim.binding.vim.host.PciPassthruInfo;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.host.vmdp.VmdpDeviceInfo;
import com.vmware.vsphere.client.h5.host.vmdp.VmdpDeviceInfoUtil;
import com.vmware.vsphere.client.h5.host.vmdp.VmdpDeviceNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class VmdpDeviceInfoConverter {
    private final PciDevice[] pciDevicesArray;
    private final NetworkInfo networkInfo;
    private final StorageDeviceInfo storageDeviceInfo;
    private final Map<String, PciPassthruInfo> pciPassthruMap;

    VmdpDeviceInfoConverter(PciPassthruInfo[] hostPciPassthruInfo, PciDevice[] pciDevicesArray, NetworkInfo networkInfo, StorageDeviceInfo storageDeviceInfo) {
        this.pciDevicesArray = pciDevicesArray;
        this.networkInfo = networkInfo;
        this.storageDeviceInfo = storageDeviceInfo;
        this.pciPassthruMap = this.createPassthruMap(hostPciPassthruInfo);
    }

    Map<String, PciPassthruInfo> createPassthruMap(PciPassthruInfo[] hostPciPassthruInfo) {
        HashMap<String, PciPassthruInfo> pciPassthruMap = new HashMap<String, PciPassthruInfo>();
        if (hostPciPassthruInfo == null) {
            return pciPassthruMap;
        }
        for (PciPassthruInfo info : hostPciPassthruInfo) {
            pciPassthruMap.put(info.getId(), info);
        }
        return pciPassthruMap;
    }

    List<VmdpDeviceInfo> createEnabledVmdpDeviceInfoList() {
        ArrayList<VmdpDeviceInfo> deviceInfoList = new ArrayList<VmdpDeviceInfo>();
        if (this.pciPassthruMap.size() == 0 || this.pciDevicesArray == null || this.pciDevicesArray.length == 0) {
            return deviceInfoList;
        }
        for (PciDevice pciDevice : this.pciDevicesArray) {
            String pciDeviceId = pciDevice.getId();
            PciPassthruInfo pciPassthruInfo = this.pciPassthruMap.get(pciDeviceId);
            if (!this.isPciDeviceAvailable(pciPassthruInfo)) continue;
            VmdpDeviceNode vmdpDeviceInfo = this.createVmdpDeviceNode(this.pciPassthruMap.get(pciDeviceId), pciDevice);
            deviceInfoList.add(vmdpDeviceInfo);
        }
        return deviceInfoList;
    }

    List<VmdpDeviceNode> createVmdpDeviceNodeList() {
        return this.createVmdpDeviceNodeList(false);
    }

    List<VmdpDeviceNode> createVmdpAllDevicesNodeList() {
        return this.createVmdpDeviceNodeList(true);
    }

    private List<VmdpDeviceNode> createVmdpDeviceNodeList(boolean includeNonPassthruCapableDevices) {
        HashMap<String, VmdpDeviceNode> configurableDevices = new HashMap<String, VmdpDeviceNode>();
        Map<String, VmdpDeviceNode> deviceNodeMap = this.getVmdpNodeDevicesMap();
        for (VmdpDeviceNode vmdpDeviceNode : deviceNodeMap.values()) {
            VmdpDeviceNode parentDevice = deviceNodeMap.get(vmdpDeviceNode.parentDeviceId);
            if (parentDevice == null) continue;
            vmdpDeviceNode.parentId = parentDevice.nodeId;
        }
        for (VmdpDeviceNode vmdpDeviceNode : deviceNodeMap.values()) {
            if (includeNonPassthruCapableDevices) {
                configurableDevices.put(vmdpDeviceNode.vmdpDeviceId, vmdpDeviceNode);
                this.putAllNodeParentsInMap(vmdpDeviceNode, deviceNodeMap, configurableDevices);
                continue;
            }
            PciPassthruInfo pciPassthruInfo = this.pciPassthruMap.get(vmdpDeviceNode.vmdpDeviceId);
            if (pciPassthruInfo == null || !pciPassthruInfo.isPassthruCapable()) continue;
            configurableDevices.put(vmdpDeviceNode.vmdpDeviceId, vmdpDeviceNode);
            this.putAllNodeParentsInMap(vmdpDeviceNode, deviceNodeMap, configurableDevices);
        }
        ArrayList<VmdpDeviceNode> list = new ArrayList<VmdpDeviceNode>(configurableDevices.values());
        Collections.sort(list, new Comparator<VmdpDeviceNode>(){

            @Override
            public int compare(VmdpDeviceNode o1, VmdpDeviceNode o2) {
                return o1.hasChildren - o2.hasChildren;
            }
        });
        return list;
    }

    private void putAllNodeParentsInMap(VmdpDeviceNode node, Map<String, VmdpDeviceNode> deviceNodeMap, Map<String, VmdpDeviceNode> configurableDevices) {
        while (node.parentDeviceId != null && (node = deviceNodeMap.get(node.parentDeviceId)) != null) {
            node.hasChildren = 1;
            configurableDevices.put(node.vmdpDeviceId, node);
        }
    }

    private Map<String, VmdpDeviceNode> getVmdpNodeDevicesMap() {
        HashMap<String, VmdpDeviceNode> deviceNodeMap = new HashMap<String, VmdpDeviceNode>();
        if (this.pciPassthruMap.size() == 0 || this.pciDevicesArray == null || this.pciDevicesArray.length == 0) {
            return deviceNodeMap;
        }
        int nodeId = 0;
        for (PciDevice pciDevice : this.pciDevicesArray) {
            String pciDeviceId = pciDevice.getId();
            PciPassthruInfo pciPassthruInfo = this.pciPassthruMap.get(pciDeviceId);
            if (pciPassthruInfo == null) continue;
            VmdpDeviceNode vmdpDeviceNode = this.initVmdpDeviceNode(pciPassthruInfo, pciDevice, nodeId++);
            deviceNodeMap.put(vmdpDeviceNode.vmdpDeviceId, vmdpDeviceNode);
        }
        return deviceNodeMap;
    }

    private VmdpDeviceNode initVmdpDeviceNode(PciPassthruInfo pciPassthruInfo, PciDevice pciDevice, Integer nodeId) {
        boolean dependantDeviceAvailable;
        VmdpDeviceNode vmdpDeviceNode = this.createVmdpDeviceNode(pciPassthruInfo, pciDevice);
        vmdpDeviceNode.nodeId = nodeId;
        if (pciDevice.getParentBridge() != null) {
            vmdpDeviceNode.parentDeviceId = pciDevice.getParentBridge();
        }
        boolean bl = dependantDeviceAvailable = !StringUtil.isNullOrEmpty((String)pciPassthruInfo.dependentDevice);
        if (vmdpDeviceNode.vmdpDeviceId != null && dependantDeviceAvailable && !vmdpDeviceNode.vmdpDeviceId.equals(pciPassthruInfo.dependentDevice)) {
            vmdpDeviceNode.dependentDevice = pciPassthruInfo.dependentDevice;
        }
        return vmdpDeviceNode;
    }

    private boolean isPciDeviceAvailable(PciPassthruInfo pciPassthruInfo) {
        if (pciPassthruInfo == null) {
            return false;
        }
        boolean available = pciPassthruInfo.isPassthruEnabled() || pciPassthruInfo.isPassthruActive();
        return available && pciPassthruInfo.isPassthruCapable();
    }

    private VmdpDeviceNode createVmdpDeviceNode(PciPassthruInfo pciPassthruInfo, PciDevice device) {
        VmdpDeviceNode vmdpDeviceInfo = new VmdpDeviceNode();
        vmdpDeviceInfo.vmdpDeviceId = device.getId();
        vmdpDeviceInfo.vendor = device.getVendorName();
        vmdpDeviceInfo.deviceName = VmdpDeviceInfoUtil.getVmdprDeviceInfoName(device.getDeviceName(), device.getClassId());
        VmdpDeviceInfoUtil.VmdpDeviceDirectPathState vmdpDeviceDirectPathState = VmdpDeviceInfoUtil.getVmdprDeviceInfoStatusAndMessage(pciPassthruInfo.isPassthruCapable(), pciPassthruInfo.isPassthruEnabled(), pciPassthruInfo.isPassthruActive());
        vmdpDeviceInfo.status = vmdpDeviceDirectPathState.getStatus();
        vmdpDeviceInfo.statusMessage = vmdpDeviceDirectPathState.getDirectPathStatusMessage();
        vmdpDeviceInfo.directPathMessage = vmdpDeviceDirectPathState.getDirectPathStateMessage();
        vmdpDeviceInfo.deviceId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getDeviceId());
        vmdpDeviceInfo.subDeviceId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getSubDeviceId());
        vmdpDeviceInfo.classId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getClassId());
        vmdpDeviceInfo.vendorId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getVendorId());
        vmdpDeviceInfo.subVendorId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getSubVendorId());
        if (vmdpDeviceInfo.vmdpDeviceId != null) {
            vmdpDeviceInfo.busId = vmdpDeviceInfo.vmdpDeviceId.toUpperCase();
        }
        vmdpDeviceInfo.bus = VmdpDeviceInfoUtil.getUnsignedByteAsHexString(device.getBus());
        vmdpDeviceInfo.busSlot = VmdpDeviceInfoUtil.getUnsignedByteAsHexString(device.getSlot());
        vmdpDeviceInfo.function = VmdpDeviceInfoUtil.getUnsignedByteAsHexString(device.function);
        vmdpDeviceInfo.esxDeviceInfo = VmdpDeviceInfoUtil.getEsxDeviceInfo(this.storageDeviceInfo, this.networkInfo, vmdpDeviceInfo.vmdpDeviceId, vmdpDeviceInfo.classId);
        return vmdpDeviceInfo;
    }
}

