/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.PredicateProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.cluster.DasFdmAvailabilityState;
import com.vmware.vim.binding.vim.cluster.DasFdmHostState;
import com.vmware.vim.binding.vim.host.BootDeviceInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VcServiceUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class HostExtendedDataModel {
    @Property(value="HostSystem/powerConfigHardware/@info/immutable")
    public Boolean powerConfigInfoImmutable;

    @PredicateProperty(value="HostSystem/isHostConnectedAndPoweredOn")
    public static Filter getIsHostConnectedAndPoweredOn() {
        PropertyPredicate isConnected = new PropertyPredicate("HostSystem/runtime/connectionState", PropertyPredicate.ComparisonOperator.EQUAL, (Object)HostSystem.ConnectionState.connected.name());
        PropertyPredicate isPoweredOn = new PropertyPredicate("HostSystem/runtime/powerState", PropertyPredicate.ComparisonOperator.EQUAL, (Object)HostSystem.PowerState.poweredOn.name());
        return new Filter(Arrays.asList(isConnected, isPoweredOn), LogicalOperator.AND);
    }

    @DerivedProperty(value="HostSystem/isHostConnected")
    public static boolean isHostConnected(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState) {
        return HostExtendedDataModel.isConnectedInternal(connectionState);
    }

    @DerivedProperty(value="HostSystem/isEditVmStartupShutdownAllowed")
    public static boolean isEditVmStartupShutdownAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/runtime/dasHostState") DasFdmHostState dasState) {
        return HostExtendedDataModel.isConnectedInternal(connectionState) && (dasState == null || dasState.state.equals(DasFdmAvailabilityState.uninitialized.name()) || dasState.state.equals(DasFdmAvailabilityState.uninitializationError.name()) || dasState.state.equals(DasFdmAvailabilityState.initializationError.name()));
    }

    @DerivedProperty(value="HostSystem/isAttachedHostProfileAllowed")
    public static boolean isAttachHostProfileAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/hp") ManagedObjectReference profile) {
        return HostExtendedDataModel.isConnectedInternal(connectionState) && profile == null;
    }

    @DerivedProperty(value="HostSystem/isDetachedHostProfileAllowed")
    public static boolean isDetachHostProfileAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/hp") ManagedObjectReference profile) {
        return HostExtendedDataModel.isConnectedInternal(connectionState) && profile != null;
    }

    @DerivedProperty(value="HostSystem/refreshCertificateVisible")
    public static boolean isRefreshCertificateVisible(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/configManager/certificateManager") ManagedObjectReference certManager) {
        return HostExtendedDataModel.isConnectedInternal(connectionState) && certManager != null;
    }

    @DerivedProperty(value="HostSystem/hyperthreadingEditAllowed")
    public static boolean isHyperthreadEditAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/config/hyperThread/available") Boolean htAvailable) {
        return HostExtendedDataModel.isConnectedInternal(connectionState) && htAvailable != false;
    }

    @DerivedProperty(value="HostSystem/bootDevicesEditAllowed")
    public static boolean isBootDevicesEditAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/bootDeviceInfo") BootDeviceInfo bootDeviceInfo) {
        boolean hasBootDevices = bootDeviceInfo != null && bootDeviceInfo.bootDevices != null && bootDeviceInfo.bootDevices.length > 0;
        return HostExtendedDataModel.isConnectedInternal(connectionState) && hasBootDevices;
    }

    @DerivedProperty(value="HostSystem/isHostCustomizationsAvailable")
    public static boolean isHostCustomizationsAvailable(@SourceProperty(value="HostSystem/parent") ManagedObjectReference parent, @SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/hp") ManagedObjectReference profile) {
        return HostExtendedDataModel.isConnectedInternal(connectionState) && profile != null && parent != null && VcServiceUtil.is65VcOrLaterByServerGuid((String)parent.getServerGuid());
    }

    @DerivedProperty(value="ClusterComputeResource/isHostCustomizationsAvailable")
    public static boolean isHostCustomizationsAvailable(@SourceProperty(value="ClusterComputeResource/hp") ManagedObjectReference profile, @SourceProperty(value="ClusterComputeResource/parent") ManagedObjectReference parent, @SourceProperty(value="ClusterComputeResource/host") ManagedObjectReference[] hosts) {
        return profile != null && parent != null && VcServiceUtil.is65VcOrLaterByServerGuid((String)parent.getServerGuid()) && hosts != null && hosts.length > 0;
    }

    @DerivedProperty(value="HostSystem/isHostConnectedAndHasAttachedProfile")
    public static boolean getIsHostConnectedAndHasAttachedProfile(@SourceProperty(value="HostSystem/hp") ManagedObjectReference associatedHostProfileMor, @SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState) {
        boolean isHostProfileAttached = associatedHostProfileMor != null;
        boolean isHostConnected = HostExtendedDataModel.isConnectedInternal(connectionState);
        return isHostConnected && isHostProfileAttached;
    }

    @DerivedProperty(value="HostProfile/isEditTreeHostCustomizationsAvailable")
    public static boolean getIsEditTreeHostCustomizationsAvailable(@SourceProperty(value="HostProfile/entity") ManagedObjectReference[] entities, @SourceProperty(value="HostProfile/isBulkAnswerFileEnabled") boolean isBulkAnswerFileEnabled) {
        ArrayList<ManagedObjectReference> hostRefs = new ArrayList<ManagedObjectReference>();
        if (entities != null) {
            for (ManagedObjectReference ref : entities) {
                if (!HostSystem.class.getSimpleName().equals(ref.getType())) continue;
                hostRefs.add(ref);
            }
        }
        return hostRefs.size() > 0 && isBulkAnswerFileEnabled;
    }

    private static boolean isConnectedInternal(HostSystem.ConnectionState state) {
        return state == HostSystem.ConnectionState.connected;
    }
}

