/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hci.model;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.fault.AlreadyConnected;
import com.vmware.vim.binding.vim.fault.ConflictingDatastoreFound;
import com.vmware.vim.binding.vim.fault.HostConnectFault;
import com.vmware.vim.binding.vim.fault.InvalidLogin;
import com.vmware.vim.binding.vim.fault.NoHost;
import com.vmware.vim.binding.vim.fault.NotSupportedHost;
import com.vmware.vim.binding.vim.fault.SSLDisabledFault;
import com.vmware.vim.binding.vim.fault.SSLVerifyFault;
import java.util.ArrayList;

public class HostConnectionData {
    public Datacenter.BasicConnectInfo[] noErrors;
    public Datacenter.BasicConnectInfo[] connectError;
    public Datacenter.BasicConnectInfo[] loginError;
    public Datacenter.BasicConnectInfo[] notSupportedError;
    public Datacenter.BasicConnectInfo[] alreadyConnectedError;
    public Datacenter.BasicConnectInfo[] sslDisabledError;
    public Datacenter.BasicConnectInfo[] sslVerificationError;
    public Datacenter.BasicConnectInfo[] noHostError;
    public Datacenter.BasicConnectInfo[] conflictDatastoreError;
    public Datacenter.BasicConnectInfo[] otherError;

    public HostConnectionData() {
    }

    public HostConnectionData(Datacenter.BasicConnectInfo[] basicConnectInfos) {
        ArrayList<Datacenter.BasicConnectInfo> sslVerificationHosts = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> sslDisabledHosts = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> alreadyConnectedHosts = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> notSupportedHosts = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> loginErrorHosts = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> connectionErrorHosts = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> conflictDatastore = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> noHosts = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> other = new ArrayList<Datacenter.BasicConnectInfo>();
        ArrayList<Datacenter.BasicConnectInfo> okHosts = new ArrayList<Datacenter.BasicConnectInfo>();
        for (Datacenter.BasicConnectInfo basicConnectInfo : basicConnectInfos) {
            if (basicConnectInfo.error != null) {
                if (basicConnectInfo.error instanceof SSLVerifyFault) {
                    sslVerificationHosts.add(basicConnectInfo);
                    continue;
                }
                if (basicConnectInfo.error instanceof SSLDisabledFault) {
                    sslDisabledHosts.add(basicConnectInfo);
                    continue;
                }
                if (basicConnectInfo.error instanceof AlreadyConnected) {
                    alreadyConnectedHosts.add(basicConnectInfo);
                    continue;
                }
                if (basicConnectInfo.error instanceof NotSupportedHost) {
                    notSupportedHosts.add(basicConnectInfo);
                    continue;
                }
                if (basicConnectInfo.error instanceof InvalidLogin) {
                    loginErrorHosts.add(basicConnectInfo);
                    continue;
                }
                if (basicConnectInfo.error instanceof NoHost) {
                    noHosts.add(basicConnectInfo);
                    continue;
                }
                if (basicConnectInfo.error instanceof HostConnectFault) {
                    connectionErrorHosts.add(basicConnectInfo);
                    continue;
                }
                if (basicConnectInfo.error instanceof ConflictingDatastoreFound) {
                    conflictDatastore.add(basicConnectInfo);
                    continue;
                }
                other.add(basicConnectInfo);
                continue;
            }
            okHosts.add(basicConnectInfo);
        }
        this.sslVerificationError = sslVerificationHosts.toArray(new Datacenter.BasicConnectInfo[0]);
        this.sslDisabledError = sslDisabledHosts.toArray(new Datacenter.BasicConnectInfo[0]);
        this.alreadyConnectedError = alreadyConnectedHosts.toArray(new Datacenter.BasicConnectInfo[0]);
        this.notSupportedError = notSupportedHosts.toArray(new Datacenter.BasicConnectInfo[0]);
        this.loginError = loginErrorHosts.toArray(new Datacenter.BasicConnectInfo[0]);
        this.connectError = connectionErrorHosts.toArray(new Datacenter.BasicConnectInfo[0]);
        this.noHostError = noHosts.toArray(new Datacenter.BasicConnectInfo[0]);
        this.conflictDatastoreError = conflictDatastore.toArray(new Datacenter.BasicConnectInfo[0]);
        this.otherError = other.toArray(new Datacenter.BasicConnectInfo[0]);
        this.noErrors = okHosts.toArray(new Datacenter.BasicConnectInfo[0]);
    }
}

