/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataRetrieverResult<T> {
    private Collection<T> _result;
    private Exception _exception;
    private Class<?> _resultType;
    private static final Collection<InternalServerInfo> EMPTY_SERVER_COLLECTION = Collections.emptyList();
    private static final Collection<InternalServiceInfo> EMPTY_SERVICE_COLLECTION = Collections.emptyList();
    private static final Log _logger = LogFactory.getLog(DataRetrieverResult.class);
    public static final DataRetrieverResult<InternalServiceInfo> EMPTY_SERVICE_RESULT = new DataRetrieverResult<InternalServiceInfo>(EMPTY_SERVICE_COLLECTION, null, InternalServiceInfo.class);
    public static final DataRetrieverResult<InternalServerInfo> EMPTY_SERVER_RESULT = new DataRetrieverResult<InternalServerInfo>(EMPTY_SERVER_COLLECTION, null, InternalServerInfo.class);

    public DataRetrieverResult(Collection<T> result, Exception exception, Class<?> resultType) {
        this._result = result;
        this._exception = exception;
        this._resultType = resultType;
    }

    public T[] getResult() {
        this.makeResultList();
        Object[] buffer = (Object[])Array.newInstance(this._resultType, this._result.size());
        return this._result.toArray(buffer);
    }

    public Exception getException() {
        return this._exception;
    }

    @SafeVarargs
    public static <T> DataRetrieverResult<T> applySetOperation(Conjoiner conjoiner, DataRetrieverResult<T> ... dataRetrieverResults) {
        int i;
        int inputArrayCount = dataRetrieverResults.length;
        assert (inputArrayCount > 0);
        Class<?> resultType = dataRetrieverResults[0]._resultType;
        Collection accumulator = dataRetrieverResults[0]._result;
        block5: for (int i2 = 1; i2 < inputArrayCount; ++i2) {
            Collection<T> tempRes = dataRetrieverResults[i2]._result;
            switch (conjoiner) {
                case AND: {
                    accumulator = CollectionUtil.intersection(accumulator, tempRes);
                    continue block5;
                }
                case OR: {
                    accumulator = CollectionUtil.union(accumulator, tempRes);
                    continue block5;
                }
                case EXCEPT: {
                    accumulator = CollectionUtil.minus(accumulator, tempRes);
                }
            }
        }
        ArrayList<Exception> errors = new ArrayList<Exception>();
        if (CollectionUtil.isNullOrEmpty(accumulator)) {
            for (i = 0; i < inputArrayCount; ++i) {
                Exception e = dataRetrieverResults[i]._exception;
                if (e == null) continue;
                if (e instanceof CompositeException) {
                    for (Exception nested : ((CompositeException)e).getExceptions()) {
                        errors.add(nested);
                    }
                    continue;
                }
                errors.add(e);
            }
        } else {
            for (i = 0; i < inputArrayCount; ++i) {
                Exception e = dataRetrieverResults[i]._exception;
                if (e == null) continue;
                _logger.warn((Object)"Received partial result, igoring error", (Throwable)e);
            }
        }
        Exception resultingException = errors.size() == 0 ? null : (errors.size() == 1 ? (Exception)errors.get(0) : new CompositeException(errors));
        return new DataRetrieverResult<T>(accumulator, resultingException, resultType);
    }

    public void sort(Comparator<T> comparator) {
        this.makeResultList();
        Collections.sort((List)this._result, comparator);
    }

    public DataRetrieverResult<T> slice(int begin, int end) {
        this.makeResultList();
        List orderedResult = (List)this._result;
        List slicedResult = orderedResult.subList(begin, end);
        return new DataRetrieverResult(slicedResult, this._exception, this._resultType);
    }

    Collection<T> getResultCollection() {
        return this._result;
    }

    private void makeResultList() {
        if (!(this._result instanceof List)) {
            this._result = new ArrayList<T>(this._result);
        }
    }
}

