/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class CachingPropertyValueExtractor<T> {
    private static final Log _logger = LogFactory.getLog(CachingPropertyValueExtractor.class);
    private final PropertyCache<T> _cache;
    private final Set<String> _cacheableProperties;
    private final Executor _executor;

    public CachingPropertyValueExtractor(PropertyCache<T> cache, Set<String> cacheableProperties, Executor executor) {
        this._cache = cache;
        this._cacheableProperties = cacheableProperties;
        this._executor = executor;
    }

    protected Object[] getValuesPerProperty(T[] objects, String propertyName) {
        if (this._cacheableProperties.contains(propertyName)) {
            return this.getValuesPerPropertyCached(objects, propertyName);
        }
        return this.retrieveValuesPerProperty(objects, propertyName);
    }

    protected Object[] getValuesPerPropertyCached(T[] objects, String propertyName) {
        assert (this._cacheableProperties.contains(propertyName));
        Object cached = this._cache.getProperty(objects, propertyName);
        if (cached != null) {
            return cached;
        }
        Object[] result = this.retrieveValuesPerProperty(objects, propertyName);
        this._cache.setProperty(objects, propertyName, result);
        return result;
    }

    private Object[] retrieveValuesPerProperty(T[] objects, String propertyName) {
        Object[] result;
        if (this.propertyNeedsRemoteCall(propertyName)) {
            List executorResult;
            Map<String, List<ObjectPositionPair<T>>> objectsByServer = this.mapObjectsByServer(objects);
            String[] servers = objectsByServer.keySet().toArray(new String[objectsByServer.keySet().size()]);
            result = new Object[objects.length];
            ArrayList<PerServerTask> callables = new ArrayList<PerServerTask>();
            for (int i = 0; i < servers.length; ++i) {
                callables.add(new PerServerTask(objectsByServer.get(servers[i]), propertyName));
            }
            try {
                executorResult = ExecutorUtil.executeTasks(callables, (Executor)this._executor);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            for (int i = 0; i < servers.length; ++i) {
                List<ObjectPositionPair<T>> objectsForServer = objectsByServer.get(servers[i]);
                ExecutorUtil.TaskResult taskForServer = (ExecutorUtil.TaskResult)executorResult.get(i);
                Exception error = taskForServer.getException();
                if (error != null) {
                    _logger.warn((Object)("Could not retrieve properties for node " + servers[i]), (Throwable)error);
                    continue;
                }
                Object[] resultsForServer = (Object[])taskForServer.getResult();
                for (int j = 0; j < objectsForServer.size(); ++j) {
                    ObjectPositionPair<T> opp = objectsForServer.get(j);
                    result[opp.position] = resultsForServer[j];
                }
            }
        } else {
            result = this.getValuesPerPropertyDirectly(objects, propertyName, false);
        }
        this.sanitizeValues(propertyName, result);
        return result;
    }

    protected abstract Object[] getValuesPerPropertyDirectly(T[] var1, String var2, boolean var3);

    protected void sanitizeValues(String propertyName, Object[] results) {
    }

    protected boolean propertyNeedsRemoteCall(String propertyName) {
        return true;
    }

    protected abstract String getServerId(T var1);

    private Map<String, List<ObjectPositionPair<T>>> mapObjectsByServer(T[] objects) {
        HashMap<String, List<ObjectPositionPair<T>>> result = new HashMap<String, List<ObjectPositionPair<T>>>();
        for (int i = 0; i < objects.length; ++i) {
            List<Object> listForServer;
            ObjectPositionPair opp = new ObjectPositionPair();
            opp.position = i;
            opp.obj = objects[i];
            String serverId = this.getServerId(objects[i]);
            if (result.containsKey(serverId)) {
                listForServer = result.get(serverId);
                listForServer.add(opp);
                continue;
            }
            listForServer = new ArrayList();
            ((ArrayList)listForServer).add(opp);
            result.put(serverId, listForServer);
        }
        return result;
    }

    private class PerServerTask
    implements Callable<Object[]> {
        private final T[] _objects;
        private final String _propertyName;

        public PerServerTask(List<ObjectPositionPair<T>> objects, String propertyName) {
            assert (objects.size() > 0);
            Object representative = objects.get((int)0).obj;
            Object[] arrayOfT = (Object[])Array.newInstance(representative.getClass(), objects.size());
            for (int i = 0; i < objects.size(); ++i) {
                arrayOfT[i] = objects.get((int)i).obj;
            }
            this._objects = arrayOfT;
            this._propertyName = propertyName;
        }

        @Override
        public Object[] call() throws Exception {
            return CachingPropertyValueExtractor.this.getValuesPerPropertyDirectly(this._objects, this._propertyName, true);
        }
    }

    private static class ObjectPositionPair<T> {
        int position;
        T obj;

        private ObjectPositionPair() {
        }
    }
}

