/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.DataRetriever;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import com.vmware.vsphere.client.cm.util.ServerPropertyValueExtractor;
import java.net.URI;

@type(value="Issue")
public class ServerIssueAdapter
implements DataProviderAdapter {
    private static final String ISSUE_INFO_PROPERTY = "info";
    private static final String ISSUE_ENTITY_PROPERTY = "info.entity";
    private static final String ISSUE_TYPE = "Issue";
    private final DataRetriever _dataRetriever;
    private final PropertyCache<String> _unreachableServerCache;

    public ServerIssueAdapter(DataRetriever dataRetriever, PropertyCache<String> unreachableServerCache) {
        this._dataRetriever = dataRetriever;
        this._unreachableServerCache = unreachableServerCache;
    }

    public Response getData(RequestSpec request) throws Exception {
        Response result = new Response();
        QuerySpec[] queries = request.querySpec;
        result.resultSet = new ResultSet[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            result.resultSet[i] = ServerIssueAdapter.querySpecRelevant(queries[i], this._dataRetriever.getObjectReferenceService()) ? this.getResultSet(queries[i]) : null;
        }
        return result;
    }

    private ResultSet getResultSet(QuerySpec qs) {
        Constraint c = qs.resourceSpec.constraint;
        assert (c instanceof PropertyConstraint);
        PropertyConstraint pc = (PropertyConstraint)c;
        URI server = (URI)pc.comparableValue;
        IssueInfo issue = this.getIssueForServer(server);
        if (issue == null) {
            return null;
        }
        ResultSet result = new ResultSet();
        result.queryName = qs.name;
        result.items = new ResultItem[1];
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = server;
        resultItem.properties = new PropertyValue[1];
        resultItem.properties[0] = new PropertyValue();
        resultItem.properties[0].resourceObject = server;
        resultItem.properties[0].propertyName = ISSUE_INFO_PROPERTY;
        resultItem.properties[0].value = issue;
        result.items[0] = resultItem;
        return result;
    }

    private IssueInfo getIssueForServer(URI serverRef) {
        IssueInfo result = this.getServerUnreachableIssue(serverRef);
        if (result != null) {
            return result;
        }
        result = this.getApplmgmtDownIssue(serverRef);
        return result;
    }

    private IssueInfo getServerUnreachableIssue(URI serverRef) {
        assert (CmReferenceUtil.isReferenceOfType(serverRef, "cm:Server", this._dataRetriever.getObjectReferenceService()));
        IssueInfo result = null;
        String serverId = CmReferenceUtil.getServerId(serverRef);
        if (this._unreachableServerCache.getProperty(serverId, "__singleton") != null) {
            Object[][] serverProps = this.getServerProperties(new String[]{"name"}, serverRef);
            String serverName = (String)serverProps[0][0];
            result = new IssueInfo();
            result.entity = serverRef;
            result.entityName = serverName;
            result.description = CmUtil.getLocalizedString("issue.serverUnreachable", serverName);
            result.typeDisplayName = CmUtil.getLocalizedString("issue.connectionIssueType", new String[0]);
            result.status = IssueStatus.ERROR;
        }
        return result;
    }

    private IssueInfo getApplmgmtDownIssue(URI serverRef) {
        Object[][] serverProps = this.getServerProperties(new String[]{"name", "applmgmtExistsAndDown"}, serverRef);
        String serverName = (String)serverProps[0][0];
        boolean applmgmtDown = (Boolean)serverProps[1][0];
        if (!applmgmtDown) {
            return null;
        }
        IssueInfo result = new IssueInfo();
        result.entity = serverRef;
        result.entityName = serverName;
        result.description = CmUtil.getLocalizedString("issue.applmgmtNotRunning", serverName);
        result.typeDisplayName = CmUtil.getLocalizedString("issue.applmgmtIssueType", new String[0]);
        result.status = IssueStatus.ERROR;
        return result;
    }

    private Object[][] getServerProperties(String[] propertyNames, URI serverRef) {
        ObjectIdentityConstraint serverConstraint = QueryUtil.createObjectIdentityConstraint((Object)serverRef);
        DataRetrieverResult<InternalServerInfo> serverResult = this._dataRetriever.retrieveServers((Constraint)serverConstraint);
        ServerPropertyValueExtractor serverPropertyExtractor = this._dataRetriever.getServerValueExtractor();
        return serverPropertyExtractor.getValues(serverResult.getResult(), propertyNames);
    }

    private static boolean querySpecRelevant(QuerySpec qs, ObjectReferenceService objectReferenceService) {
        Constraint queryConstraint = qs.resourceSpec.constraint;
        if (!(queryConstraint instanceof PropertyConstraint)) {
            return false;
        }
        PropertyConstraint pc = (PropertyConstraint)queryConstraint;
        boolean constraintMatch = ISSUE_TYPE.equals(queryConstraint.targetType) && pc.comparator == Comparator.EQUALS && ISSUE_ENTITY_PROPERTY.equals(pc.propertyName) && CmReferenceUtil.isReferenceOfType(pc.comparableValue, "cm:Server", objectReferenceService);
        PropertySpec[] pSpecs = qs.resourceSpec.propertySpecs;
        boolean propertySpecMatch = pSpecs.length == 1 && pSpecs[0].propertyNames.length == 1 && pSpecs[0].propertyNames[0].equals(ISSUE_INFO_PROPERTY);
        return constraintMatch && propertySpecMatch;
    }
}

