/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vim.binding.sca.control.ServiceControlManager;
import com.vmware.vim.binding.sca.control.StartupType;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vsphere.client.cm.ServiceOperationSpec;
import com.vmware.vsphere.client.cm.ServiceStartupTypeSpec;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import java.net.URI;
import java.util.Locale;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScaServiceControlProvider {
    private static final Log _logger = LogFactory.getLog(ScaServiceControlProvider.class);
    private final ScaServiceManager _scaServiceManager;

    public ScaServiceControlProvider(ScaServiceManager scaServiceManager) {
        this._scaServiceManager = scaServiceManager;
    }

    public OperationResult apply(URI target, ServiceOperationSpec spec) {
        OperationResult result = new OperationResult();
        try {
            Validate.notNull((Object)((Object)spec), (String)"The spec must not be null");
            result.entity = target;
            String serverName = CmReferenceUtil.getServerId(target);
            String serviceId = CmReferenceUtil.getId(target);
            ScaService sca = this._scaServiceManager.getService((Object)serverName);
            ServiceControlManager scm = (ServiceControlManager)sca.getManagedObject(sca.getServiceContent().controlManager);
            switch (spec.operation) {
                case START: {
                    scm.startService(serviceId, 10L);
                    break;
                }
                case STOP: {
                    scm.stopService(serviceId, 10L);
                    break;
                }
                case RESTART: {
                    scm.restartService(serviceId, 10L);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown runtime state: " + (Object)((Object)spec.operation));
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(URI target, ServiceStartupTypeSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = target;
        try {
            Validate.notNull((Object)((Object)spec), (String)"The spec must not be null");
            String serverName = CmReferenceUtil.getServerId(target);
            String serviceId = CmReferenceUtil.getId(target);
            ScaService sca = this._scaServiceManager.getService((Object)serverName);
            ServiceControlManager scm = (ServiceControlManager)sca.getManagedObject(sca.getServiceContent().controlManager);
            StartupType startupType = new StartupType(spec.type.toString().toUpperCase(Locale.ENGLISH));
            scm.setStartupType(serviceId, startupType);
        }
        catch (ServiceManagerFault e) {
            _logger.error((Object)"Error while trying to chage service startup type", (Throwable)e);
            result.error = e;
        }
        return result;
    }
}

